/*
 * Decompiled with CFR 0.152.
 */
package com.fsck.k9.mail.store.imap;

import android.util.Log;

class ImapPushState {
    private static final long DEFAULT_UID_NEXT = -1L;
    private static final String PUSH_STATE_PREFIX = "uidNext=";
    private static final int PUSH_STATE_PREFIX_LENGTH = 8;
    public final long uidNext;

    public static ImapPushState parse(String pushState) {
        if (pushState == null || !pushState.startsWith(PUSH_STATE_PREFIX)) {
            return ImapPushState.createDefaultImapPushState();
        }
        String value = pushState.substring(8);
        try {
            long newUidNext = Long.parseLong(value);
            return new ImapPushState(newUidNext);
        }
        catch (NumberFormatException e) {
            Log.e((String)"k9", (String)("Unable to part uidNext value " + value), (Throwable)e);
            return ImapPushState.createDefaultImapPushState();
        }
    }

    static ImapPushState createDefaultImapPushState() {
        return new ImapPushState(-1L);
    }

    public ImapPushState(long uidNext) {
        this.uidNext = uidNext;
    }

    public String toString() {
        return PUSH_STATE_PREFIX + this.uidNext;
    }
}

