/*
 * Decompiled with CFR 0.152.
 */
package com.fsck.k9.mail.store.imap;

import android.content.Context;
import android.util.Log;
import com.fsck.k9.mail.AuthenticationFailedException;
import com.fsck.k9.mail.Flag;
import com.fsck.k9.mail.K9MailLib;
import com.fsck.k9.mail.Message;
import com.fsck.k9.mail.MessagingException;
import com.fsck.k9.mail.PushReceiver;
import com.fsck.k9.mail.power.TracingPowerManager;
import com.fsck.k9.mail.store.imap.ImapConnection;
import com.fsck.k9.mail.store.imap.ImapFolder;
import com.fsck.k9.mail.store.imap.ImapMessage;
import com.fsck.k9.mail.store.imap.ImapPushState;
import com.fsck.k9.mail.store.imap.ImapResponse;
import com.fsck.k9.mail.store.imap.ImapResponseParser;
import com.fsck.k9.mail.store.imap.ImapStore;
import com.fsck.k9.mail.store.imap.UntaggedHandler;
import java.io.IOException;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

class ImapFolderPusher
extends ImapFolder {
    private static final int IDLE_READ_TIMEOUT_INCREMENT = 300000;
    private static final int IDLE_FAILURE_COUNT_LIMIT = 10;
    private static final int MAX_DELAY_TIME = 300000;
    private static final int NORMAL_DELAY_TIME = 5000;
    private final PushReceiver pushReceiver;
    private final Object threadLock = new Object();
    private final IdleStopper idleStopper = new IdleStopper();
    private final TracingPowerManager.TracingWakeLock wakeLock;
    private final List<ImapResponse> storedUntaggedResponses = new ArrayList<ImapResponse>();
    private Thread listeningThread;
    private volatile boolean stop = false;
    private volatile boolean idling = false;

    public ImapFolderPusher(ImapStore store, String name, PushReceiver pushReceiver) {
        super(store, name);
        this.pushReceiver = pushReceiver;
        Context context = pushReceiver.getContext();
        TracingPowerManager powerManager = TracingPowerManager.getPowerManager(context);
        String tag = "ImapFolderPusher " + store.getStoreConfig().toString() + ":" + this.getName();
        this.wakeLock = powerManager.newWakeLock(1, tag);
        this.wakeLock.setReferenceCounted(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.threadLock;
        synchronized (object) {
            if (this.listeningThread != null) {
                throw new IllegalStateException("start() called twice");
            }
            this.listeningThread = new Thread(new PushRunnable());
            this.listeningThread.start();
        }
    }

    public void refresh() throws IOException, MessagingException {
        if (this.idling) {
            this.wakeLock.acquire(60000L);
            this.idleStopper.stopIdle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.threadLock;
        synchronized (object) {
            if (this.listeningThread == null) {
                throw new IllegalStateException("stop() called twice");
            }
            this.stop = true;
            this.listeningThread.interrupt();
            this.listeningThread = null;
        }
        ImapConnection conn = this.connection;
        if (conn != null) {
            if (K9MailLib.isDebug()) {
                Log.v((String)"k9", (String)("Closing connection to stop pushing for " + this.getLogId()));
            }
            conn.close();
        } else {
            Log.w((String)"k9", (String)("Attempt to interrupt null connection to stop pushing on folderPusher for " + this.getLogId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleUntaggedResponse(ImapResponse response) {
        if (response.getTag() == null && response.size() > 1) {
            Object responseType = response.get(1);
            if (ImapResponseParser.equalsIgnoreCase(responseType, "FETCH") || ImapResponseParser.equalsIgnoreCase(responseType, "EXPUNGE") || ImapResponseParser.equalsIgnoreCase(responseType, "EXISTS")) {
                if (K9MailLib.isDebug()) {
                    Log.d((String)"k9", (String)("Storing response " + response + " for later processing"));
                }
                List<ImapResponse> list = this.storedUntaggedResponses;
                synchronized (list) {
                    this.storedUntaggedResponses.add(response);
                }
            }
            this.handlePossibleUidNext(response);
        }
    }

    private void superHandleUntaggedResponse(ImapResponse response) {
        super.handleUntaggedResponse(response);
    }

    private static class IdleStopper {
        private boolean acceptDoneContinuation = false;
        private ImapConnection imapConnection;

        private IdleStopper() {
        }

        public synchronized void startAcceptingDoneContinuation(ImapConnection connection) {
            if (connection == null) {
                throw new NullPointerException("connection must not be null");
            }
            this.acceptDoneContinuation = true;
            this.imapConnection = connection;
        }

        public synchronized void stopAcceptingDoneContinuation() {
            this.acceptDoneContinuation = false;
            this.imapConnection = null;
        }

        public synchronized void stopIdle() {
            if (this.acceptDoneContinuation) {
                this.acceptDoneContinuation = false;
                this.sendDone();
            }
        }

        private void sendDone() {
            try {
                this.imapConnection.setReadTimeout(120000);
                this.imapConnection.sendContinuation("DONE");
            }
            catch (IOException e) {
                this.imapConnection.close();
            }
        }
    }

    private class PushRunnable
    implements Runnable,
    UntaggedHandler {
        private int delayTime = 5000;
        private int idleFailureCount = 0;
        private boolean needsPoll = false;

        private PushRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ImapFolderPusher.this.wakeLock.acquire(60000L);
            if (K9MailLib.isDebug()) {
                Log.i((String)"k9", (String)("Pusher starting for " + ImapFolderPusher.this.getLogId()));
            }
            long lastUidNext = -1L;
            while (!ImapFolderPusher.this.stop) {
                try {
                    long newUidNext;
                    long oldUidNext = this.getOldUidNext();
                    if (oldUidNext < lastUidNext) {
                        oldUidNext = lastUidNext;
                    }
                    boolean openedNewConnection = this.openConnectionIfNecessary();
                    if (ImapFolderPusher.this.stop) break;
                    boolean pushPollOnConnect = ImapFolderPusher.this.store.getStoreConfig().isPushPollOnConnect();
                    if (pushPollOnConnect && (openedNewConnection || this.needsPoll)) {
                        this.needsPoll = false;
                        this.syncFolderOnConnect();
                    }
                    if (ImapFolderPusher.this.stop) break;
                    lastUidNext = newUidNext = this.getNewUidNext();
                    long startUid = this.getStartUid(oldUidNext, newUidNext);
                    if (newUidNext > startUid) {
                        this.notifyMessagesArrived(startUid, newUidNext);
                        continue;
                    }
                    this.processStoredUntaggedResponses();
                    if (K9MailLib.isDebug()) {
                        Log.i((String)"k9", (String)("About to IDLE for " + ImapFolderPusher.this.getLogId()));
                    }
                    this.prepareForIdle();
                    ImapConnection conn = ImapFolderPusher.this.connection;
                    this.setReadTimeoutForIdle(conn);
                    this.sendIdle(conn);
                    this.returnFromIdle();
                }
                catch (AuthenticationFailedException e) {
                    this.reacquireWakeLockAndCleanUp();
                    if (K9MailLib.isDebug()) {
                        Log.e((String)"k9", (String)"Authentication failed. Stopping ImapFolderPusher.", (Throwable)e);
                    }
                    ImapFolderPusher.this.pushReceiver.authenticationFailed();
                    ImapFolderPusher.this.stop = true;
                }
                catch (Exception e) {
                    this.reacquireWakeLockAndCleanUp();
                    if (ImapFolderPusher.this.stop) {
                        Log.i((String)"k9", (String)("Got exception while idling, but stop is set for " + ImapFolderPusher.this.getLogId()));
                        continue;
                    }
                    ImapFolderPusher.this.pushReceiver.pushError("Push error for " + ImapFolderPusher.this.getName(), e);
                    Log.e((String)"k9", (String)("Got exception while idling for " + ImapFolderPusher.this.getLogId()), (Throwable)e);
                    ImapFolderPusher.this.pushReceiver.sleep(ImapFolderPusher.this.wakeLock, this.delayTime);
                    this.delayTime *= 2;
                    if (this.delayTime > 300000) {
                        this.delayTime = 300000;
                    }
                    ++this.idleFailureCount;
                    if (this.idleFailureCount <= 10) continue;
                    Log.e((String)"k9", (String)("Disabling pusher for " + ImapFolderPusher.this.getLogId() + " after " + this.idleFailureCount + " consecutive errors"));
                    ImapFolderPusher.this.pushReceiver.pushError("Push disabled for " + ImapFolderPusher.this.getName() + " after " + this.idleFailureCount + " consecutive errors", e);
                    ImapFolderPusher.this.stop = true;
                }
            }
            ImapFolderPusher.this.pushReceiver.setPushActive(ImapFolderPusher.this.getName(), false);
            try {
                if (K9MailLib.isDebug()) {
                    Log.i((String)"k9", (String)("Pusher for " + ImapFolderPusher.this.getLogId() + " is exiting"));
                }
                ImapFolderPusher.this.close();
            }
            catch (Exception me) {
                Log.e((String)"k9", (String)("Got exception while closing for " + ImapFolderPusher.this.getLogId()), (Throwable)me);
            }
            finally {
                ImapFolderPusher.this.wakeLock.release();
            }
        }

        private void reacquireWakeLockAndCleanUp() {
            ImapFolderPusher.this.wakeLock.acquire(60000L);
            this.clearStoredUntaggedResponses();
            ImapFolderPusher.this.idling = false;
            ImapFolderPusher.this.pushReceiver.setPushActive(ImapFolderPusher.this.getName(), false);
            try {
                ImapFolderPusher.this.connection.close();
            }
            catch (Exception me) {
                Log.e((String)"k9", (String)("Got exception while closing for exception for " + ImapFolderPusher.this.getLogId()), (Throwable)me);
            }
            ImapFolderPusher.this.connection = null;
        }

        private long getNewUidNext() throws MessagingException {
            long highestUid;
            long newUidNext = ImapFolderPusher.this.uidNext;
            if (newUidNext != -1L) {
                return newUidNext;
            }
            if (K9MailLib.isDebug()) {
                Log.d((String)"k9", (String)"uidNext is -1, using search to find highest UID");
            }
            if ((highestUid = ImapFolderPusher.this.getHighestUid()) == -1L) {
                return -1L;
            }
            newUidNext = highestUid + 1L;
            if (K9MailLib.isDebug()) {
                Log.d((String)"k9", (String)("highest UID = " + highestUid + ", set newUidNext to " + newUidNext));
            }
            return newUidNext;
        }

        private long getStartUid(long oldUidNext, long newUidNext) {
            long startUid = oldUidNext;
            int displayCount = ImapFolderPusher.this.store.getStoreConfig().getDisplayCount();
            if (startUid < newUidNext - (long)displayCount) {
                startUid = newUidNext - (long)displayCount;
            }
            if (startUid < 1L) {
                startUid = 1L;
            }
            return startUid;
        }

        private void prepareForIdle() {
            ImapFolderPusher.this.pushReceiver.setPushActive(ImapFolderPusher.this.getName(), true);
            ImapFolderPusher.this.idling = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendIdle(ImapConnection conn) throws MessagingException, IOException {
            List<ImapResponse> responses;
            String tag = conn.sendCommand("IDLE", false);
            try {
                try {
                    responses = conn.readStatusResponse(tag, "IDLE", this);
                }
                finally {
                    ImapFolderPusher.this.idleStopper.stopAcceptingDoneContinuation();
                }
            }
            catch (IOException e) {
                conn.close();
                throw e;
            }
            ImapFolderPusher.this.handleUntaggedResponses(responses);
        }

        private void returnFromIdle() {
            ImapFolderPusher.this.idling = false;
            this.delayTime = 5000;
            this.idleFailureCount = 0;
        }

        private boolean openConnectionIfNecessary() throws MessagingException {
            ImapConnection oldConnection = ImapFolderPusher.this.connection;
            ImapFolderPusher.this.internalOpen(1);
            ImapConnection conn = ImapFolderPusher.this.connection;
            this.checkConnectionNotNull(conn);
            this.checkConnectionIdleCapable(conn);
            return conn != oldConnection;
        }

        private void checkConnectionNotNull(ImapConnection conn) throws MessagingException {
            if (conn == null) {
                String message = "Could not establish connection for IDLE";
                ImapFolderPusher.this.pushReceiver.pushError(message, null);
                throw new MessagingException(message);
            }
        }

        private void checkConnectionIdleCapable(ImapConnection conn) throws MessagingException {
            if (!conn.isIdleCapable()) {
                ImapFolderPusher.this.stop = true;
                String message = "IMAP server is not IDLE capable: " + conn.toString();
                ImapFolderPusher.this.pushReceiver.pushError(message, null);
                throw new MessagingException(message);
            }
        }

        private void setReadTimeoutForIdle(ImapConnection conn) throws SocketException {
            int idleRefreshTimeout = ImapFolderPusher.this.store.getStoreConfig().getIdleRefreshMinutes() * 60 * 1000;
            conn.setReadTimeout(idleRefreshTimeout + 300000);
        }

        @Override
        public void handleAsyncUntaggedResponse(ImapResponse response) {
            if (K9MailLib.isDebug()) {
                Log.v((String)"k9", (String)("Got async response: " + response));
            }
            if (ImapFolderPusher.this.stop) {
                if (K9MailLib.isDebug()) {
                    Log.d((String)"k9", (String)("Got async untagged response: " + response + ", but stop is set for " + ImapFolderPusher.this.getLogId()));
                }
                ImapFolderPusher.this.idleStopper.stopIdle();
            } else if (response.getTag() == null) {
                if (response.size() > 1) {
                    Object responseType = response.get(1);
                    if (ImapResponseParser.equalsIgnoreCase(responseType, "EXISTS") || ImapResponseParser.equalsIgnoreCase(responseType, "EXPUNGE") || ImapResponseParser.equalsIgnoreCase(responseType, "FETCH")) {
                        ImapFolderPusher.this.wakeLock.acquire(60000L);
                        if (K9MailLib.isDebug()) {
                            Log.d((String)"k9", (String)("Got useful async untagged response: " + response + " for " + ImapFolderPusher.this.getLogId()));
                        }
                        ImapFolderPusher.this.idleStopper.stopIdle();
                    }
                } else if (response.isContinuationRequested()) {
                    if (K9MailLib.isDebug()) {
                        Log.d((String)"k9", (String)("Idling " + ImapFolderPusher.this.getLogId()));
                    }
                    ImapFolderPusher.this.idleStopper.startAcceptingDoneContinuation(ImapFolderPusher.this.connection);
                    ImapFolderPusher.this.wakeLock.release();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void clearStoredUntaggedResponses() {
            List list = ImapFolderPusher.this.storedUntaggedResponses;
            synchronized (list) {
                ImapFolderPusher.this.storedUntaggedResponses.clear();
            }
        }

        private void processStoredUntaggedResponses() throws MessagingException {
            List<ImapResponse> untaggedResponses;
            while (!(untaggedResponses = this.getAndClearStoredUntaggedResponses()).isEmpty()) {
                if (K9MailLib.isDebug()) {
                    Log.i((String)"k9", (String)("Processing " + untaggedResponses.size() + " untagged responses from previous commands for " + ImapFolderPusher.this.getLogId()));
                }
                this.processUntaggedResponses(untaggedResponses);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<ImapResponse> getAndClearStoredUntaggedResponses() {
            List list = ImapFolderPusher.this.storedUntaggedResponses;
            synchronized (list) {
                if (ImapFolderPusher.this.storedUntaggedResponses.isEmpty()) {
                    return Collections.emptyList();
                }
                ArrayList<ImapResponse> untaggedResponses = new ArrayList<ImapResponse>(ImapFolderPusher.this.storedUntaggedResponses);
                ImapFolderPusher.this.storedUntaggedResponses.clear();
                return untaggedResponses;
            }
        }

        private void processUntaggedResponses(List<ImapResponse> responses) throws MessagingException {
            boolean skipSync = false;
            int oldMessageCount = ImapFolderPusher.this.messageCount;
            if (oldMessageCount == -1) {
                skipSync = true;
            }
            ArrayList<Long> flagSyncMsgSeqs = new ArrayList<Long>();
            LinkedList<String> removeMsgUids = new LinkedList<String>();
            for (ImapResponse response : responses) {
                oldMessageCount += this.processUntaggedResponse(oldMessageCount, response, flagSyncMsgSeqs, removeMsgUids);
            }
            if (!skipSync) {
                if (oldMessageCount < 0) {
                    oldMessageCount = 0;
                }
                if (ImapFolderPusher.this.messageCount > oldMessageCount) {
                    this.syncMessages(ImapFolderPusher.this.messageCount);
                }
            }
            if (K9MailLib.isDebug()) {
                Log.d((String)"k9", (String)("UIDs for messages needing flag sync are " + flagSyncMsgSeqs + "  for " + ImapFolderPusher.this.getLogId()));
            }
            if (!flagSyncMsgSeqs.isEmpty()) {
                this.syncMessages(flagSyncMsgSeqs);
            }
            if (!removeMsgUids.isEmpty()) {
                this.removeMessages(removeMsgUids);
            }
        }

        private int processUntaggedResponse(long oldMessageCount, ImapResponse response, List<Long> flagSyncMsgSeqs, List<String> removeMsgUids) {
            ImapFolderPusher.this.superHandleUntaggedResponse(response);
            int messageCountDelta = 0;
            if (response.getTag() == null && response.size() > 1) {
                try {
                    long msgSeq;
                    Object responseType = response.get(1);
                    if (ImapResponseParser.equalsIgnoreCase(responseType, "FETCH")) {
                        Log.i((String)"k9", (String)("Got FETCH " + response));
                        msgSeq = response.getLong(0);
                        if (K9MailLib.isDebug()) {
                            Log.d((String)"k9", (String)("Got untagged FETCH for msgseq " + msgSeq + " for " + ImapFolderPusher.this.getLogId()));
                        }
                        if (!flagSyncMsgSeqs.contains(msgSeq)) {
                            flagSyncMsgSeqs.add(msgSeq);
                        }
                    }
                    if (ImapResponseParser.equalsIgnoreCase(responseType, "EXPUNGE")) {
                        msgSeq = response.getLong(0);
                        if (msgSeq <= oldMessageCount) {
                            messageCountDelta = -1;
                        }
                        if (K9MailLib.isDebug()) {
                            Log.d((String)"k9", (String)("Got untagged EXPUNGE for msgseq " + msgSeq + " for " + ImapFolderPusher.this.getLogId()));
                        }
                        ArrayList<Long> newSeqs = new ArrayList<Long>();
                        Iterator<Long> flagIter = flagSyncMsgSeqs.iterator();
                        while (flagIter.hasNext()) {
                            long flagMsg = flagIter.next();
                            if (flagMsg < msgSeq) continue;
                            flagIter.remove();
                            if (flagMsg <= msgSeq) continue;
                            newSeqs.add(flagMsg);
                        }
                        flagSyncMsgSeqs.addAll(newSeqs);
                        ArrayList msgSeqs = new ArrayList(ImapFolderPusher.this.msgSeqUidMap.keySet());
                        Collections.sort(msgSeqs);
                        Iterator iterator = msgSeqs.iterator();
                        while (iterator.hasNext()) {
                            String uid;
                            long msgSeqNum = (Long)iterator.next();
                            if (K9MailLib.isDebug()) {
                                Log.v((String)"k9", (String)("Comparing EXPUNGEd msgSeq " + msgSeq + " to " + msgSeqNum));
                            }
                            if (msgSeqNum == msgSeq) {
                                uid = (String)ImapFolderPusher.this.msgSeqUidMap.get(msgSeqNum);
                                if (K9MailLib.isDebug()) {
                                    Log.d((String)"k9", (String)("Scheduling removal of UID " + uid + " because msgSeq " + msgSeqNum + " was expunged"));
                                }
                                removeMsgUids.add(uid);
                                ImapFolderPusher.this.msgSeqUidMap.remove(msgSeqNum);
                                continue;
                            }
                            if (msgSeqNum <= msgSeq) continue;
                            uid = (String)ImapFolderPusher.this.msgSeqUidMap.get(msgSeqNum);
                            if (K9MailLib.isDebug()) {
                                Log.d((String)"k9", (String)("Reducing msgSeq for UID " + uid + " from " + msgSeqNum + " to " + (msgSeqNum - 1L)));
                            }
                            ImapFolderPusher.this.msgSeqUidMap.remove(msgSeqNum);
                            ImapFolderPusher.this.msgSeqUidMap.put(msgSeqNum - 1L, uid);
                        }
                    }
                }
                catch (Exception e) {
                    Log.e((String)"k9", (String)("Could not handle untagged FETCH for " + ImapFolderPusher.this.getLogId()), (Throwable)e);
                }
            }
            return messageCountDelta;
        }

        private void syncMessages(int end) throws MessagingException {
            long oldUidNext = this.getOldUidNext();
            List<ImapMessage> messageList = ImapFolderPusher.this.getMessages(end, end, null, true, null);
            if (messageList != null && messageList.size() > 0) {
                long startUid;
                long newUid = Long.parseLong(messageList.get(0).getUid());
                if (K9MailLib.isDebug()) {
                    Log.i((String)"k9", (String)("Got newUid " + newUid + " for message " + end + " on " + ImapFolderPusher.this.getLogId()));
                }
                if ((startUid = oldUidNext) < newUid - 10L) {
                    startUid = newUid - 10L;
                }
                if (startUid < 1L) {
                    startUid = 1L;
                }
                if (newUid >= startUid) {
                    if (K9MailLib.isDebug()) {
                        Log.i((String)"k9", (String)("Needs sync from uid " + startUid + " to " + newUid + " for " + ImapFolderPusher.this.getLogId()));
                    }
                    ArrayList<Message> messages = new ArrayList<Message>();
                    for (long uid = startUid; uid <= newUid; ++uid) {
                        ImapMessage message = new ImapMessage(Long.toString(uid), ImapFolderPusher.this);
                        messages.add(message);
                    }
                    if (!messages.isEmpty()) {
                        ImapFolderPusher.this.pushReceiver.messagesArrived(ImapFolderPusher.this, messages);
                    }
                }
            }
        }

        private void syncMessages(List<Long> flagSyncMsgSeqs) {
            try {
                List<ImapMessage> messageList = ImapFolderPusher.this.getMessages(flagSyncMsgSeqs, true, null);
                ArrayList<Message> messages = new ArrayList<Message>();
                messages.addAll(messageList);
                ImapFolderPusher.this.pushReceiver.messagesFlagsChanged(ImapFolderPusher.this, messages);
            }
            catch (Exception e) {
                ImapFolderPusher.this.pushReceiver.pushError("Exception while processing Push untagged responses", e);
            }
        }

        private void removeMessages(List<String> removeUids) {
            ArrayList<Message> messages = new ArrayList<Message>(removeUids.size());
            try {
                List<ImapMessage> existingMessages = ImapFolderPusher.this.getMessagesFromUids(removeUids);
                for (Message message : existingMessages) {
                    this.needsPoll = true;
                    ImapFolderPusher.this.msgSeqUidMap.clear();
                    String existingUid = message.getUid();
                    Log.w((String)"k9", (String)("Message with UID " + existingUid + " still exists on server, not expunging"));
                    removeUids.remove(existingUid);
                }
                for (String string : removeUids) {
                    ImapMessage message = new ImapMessage(string, ImapFolderPusher.this);
                    try {
                        message.setFlagInternal(Flag.DELETED, true);
                    }
                    catch (MessagingException me) {
                        Log.e((String)"k9", (String)("Unable to set DELETED flag on message " + message.getUid()));
                    }
                    messages.add(message);
                }
                ImapFolderPusher.this.pushReceiver.messagesRemoved(ImapFolderPusher.this, messages);
            }
            catch (Exception e) {
                Log.e((String)"k9", (String)"Cannot remove EXPUNGEd messages", (Throwable)e);
            }
        }

        private void syncFolderOnConnect() throws MessagingException {
            this.processStoredUntaggedResponses();
            if (ImapFolderPusher.this.messageCount == -1) {
                throw new MessagingException("Message count = -1 for idling");
            }
            ImapFolderPusher.this.pushReceiver.syncFolder(ImapFolderPusher.this);
        }

        private void notifyMessagesArrived(long startUid, long uidNext) {
            if (K9MailLib.isDebug()) {
                Log.i((String)"k9", (String)("Needs sync from uid " + startUid + " to " + uidNext + " for " + ImapFolderPusher.this.getLogId()));
            }
            int count = (int)(uidNext - startUid);
            ArrayList<Message> messages = new ArrayList<Message>(count);
            for (long uid = startUid; uid < uidNext; ++uid) {
                ImapMessage message = new ImapMessage(Long.toString(uid), ImapFolderPusher.this);
                messages.add(message);
            }
            ImapFolderPusher.this.pushReceiver.messagesArrived(ImapFolderPusher.this, messages);
        }

        private long getOldUidNext() {
            long oldUidNext = -1L;
            try {
                String serializedPushState = ImapFolderPusher.this.pushReceiver.getPushState(ImapFolderPusher.this.getName());
                ImapPushState pushState = ImapPushState.parse(serializedPushState);
                oldUidNext = pushState.uidNext;
                if (K9MailLib.isDebug()) {
                    Log.i((String)"k9", (String)("Got oldUidNext " + oldUidNext + " for " + ImapFolderPusher.this.getLogId()));
                }
            }
            catch (Exception e) {
                Log.e((String)"k9", (String)("Unable to get oldUidNext for " + ImapFolderPusher.this.getLogId()), (Throwable)e);
            }
            return oldUidNext;
        }
    }
}

