/*
 * Decompiled with CFR 0.152.
 */
package com.fsck.k9.mail.store.imap;

import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.util.Log;
import com.fsck.k9.mail.Authentication;
import com.fsck.k9.mail.AuthenticationFailedException;
import com.fsck.k9.mail.CertificateValidationException;
import com.fsck.k9.mail.ConnectionSecurity;
import com.fsck.k9.mail.K9MailLib;
import com.fsck.k9.mail.MessagingException;
import com.fsck.k9.mail.NetworkType;
import com.fsck.k9.mail.filter.Base64;
import com.fsck.k9.mail.filter.PeekableInputStream;
import com.fsck.k9.mail.ssl.TrustedSocketFactory;
import com.fsck.k9.mail.store.imap.CapabilityResponse;
import com.fsck.k9.mail.store.imap.ImapResponse;
import com.fsck.k9.mail.store.imap.ImapResponseCallback;
import com.fsck.k9.mail.store.imap.ImapResponseParser;
import com.fsck.k9.mail.store.imap.ImapSettings;
import com.fsck.k9.mail.store.imap.NamespaceResponse;
import com.fsck.k9.mail.store.imap.NegativeImapResponseException;
import com.fsck.k9.mail.store.imap.UntaggedHandler;
import com.fsck.k9.mail.store.imap.XOAuth2AuthenticationFailedException;
import com.jcraft.jzlib.ZOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.net.ssl.SSLException;
import org.apache.commons.io.IOUtils;
import org.json.JSONException;
import org.json.JSONObject;

class ImapConnection {
    private static final int BUFFER_SIZE = 1024;
    private final ConnectivityManager connectivityManager;
    private final TrustedSocketFactory socketFactory;
    private final int socketConnectTimeout;
    private final int socketReadTimeout;
    private Socket socket;
    private PeekableInputStream inputStream;
    private OutputStream outputStream;
    private ImapResponseParser responseParser;
    private int nextCommandTag;
    private Set<String> capabilities = new HashSet<String>();
    private ImapSettings settings;
    private Exception stacktraceForClose;
    private boolean open = false;

    public ImapConnection(ImapSettings settings, TrustedSocketFactory socketFactory, ConnectivityManager connectivityManager) {
        this.settings = settings;
        this.socketFactory = socketFactory;
        this.connectivityManager = connectivityManager;
        this.socketConnectTimeout = 30000;
        this.socketReadTimeout = 120000;
    }

    ImapConnection(ImapSettings settings, TrustedSocketFactory socketFactory, ConnectivityManager connectivityManager, int socketConnectTimeout, int socketReadTimeout) {
        this.settings = settings;
        this.socketFactory = socketFactory;
        this.connectivityManager = connectivityManager;
        this.socketConnectTimeout = socketConnectTimeout;
        this.socketReadTimeout = socketReadTimeout;
    }

    public void open() throws IOException, MessagingException {
        if (this.open) {
            return;
        }
        if (this.stacktraceForClose != null) {
            throw new IllegalStateException("open() called after close(). Check wrapped exception to see where close() was called.", this.stacktraceForClose);
        }
        this.open = true;
        boolean authSuccess = false;
        this.nextCommandTag = 1;
        this.adjustDNSCacheTTL();
        try {
            this.socket = this.connect();
            this.configureSocket();
            this.setUpStreamsAndParserFromSocket();
            this.readInitialResponse();
            this.requestCapabilitiesIfNecessary();
            this.upgradeToTlsIfNecessary();
            this.authenticate();
            authSuccess = true;
            this.enableCompressionIfRequested();
            this.retrievePathPrefixIfNecessary();
            this.retrievePathDelimiterIfNecessary();
        }
        catch (SSLException e) {
            this.handleSslException(e);
        }
        catch (ConnectException e) {
            this.handleConnectException(e);
        }
        catch (GeneralSecurityException e) {
            throw new MessagingException("Unable to open connection to IMAP server due to security error.", e);
        }
        finally {
            if (!authSuccess) {
                Log.e((String)"k9", (String)("Failed to login, closing connection for " + this.getLogId()));
                this.close();
            }
        }
    }

    private void handleSslException(SSLException e) throws CertificateValidationException, SSLException {
        if (e.getCause() instanceof CertificateException) {
            throw new CertificateValidationException(e.getMessage(), e);
        }
        throw e;
    }

    private void handleConnectException(ConnectException e) throws ConnectException {
        String message = e.getMessage();
        String[] tokens = message.split("-");
        if (tokens.length > 1 && tokens[1] != null) {
            Log.e((String)"k9", (String)("Stripping host/port from ConnectionException for " + this.getLogId()), (Throwable)e);
            throw new ConnectException(tokens[1].trim());
        }
        throw e;
    }

    public boolean isConnected() {
        return this.inputStream != null && this.outputStream != null && this.socket != null && this.socket.isConnected() && !this.socket.isClosed();
    }

    private void adjustDNSCacheTTL() {
        try {
            Security.setProperty("networkaddress.cache.ttl", "0");
        }
        catch (Exception e) {
            Log.w((String)"k9", (String)("Could not set DNS ttl to 0 for " + this.getLogId()), (Throwable)e);
        }
        try {
            Security.setProperty("networkaddress.cache.negative.ttl", "0");
        }
        catch (Exception e) {
            Log.w((String)"k9", (String)("Could not set DNS negative ttl to 0 for " + this.getLogId()), (Throwable)e);
        }
    }

    private Socket connect() throws GeneralSecurityException, MessagingException, IOException {
        return this.connectToAddress(InetAddress.getAllByName(this.settings.getHost()));
    }

    Socket connectToAddress(InetAddress[] addresses) throws NoSuchAlgorithmException, KeyManagementException, MessagingException {
        String host = this.settings.getHost();
        int port = this.settings.getPort();
        String clientCertificateAlias = this.settings.getClientCertificateAlias();
        ArrayList<ConnectableAddress> connectableAddresses = new ArrayList<ConnectableAddress>();
        for (InetAddress address : addresses) {
            connectableAddresses.add(new ConnectableAddress(new InetSocketAddress(address, port)));
        }
        Collections.sort(connectableAddresses);
        long startConnect = System.currentTimeMillis();
        while (!connectableAddresses.isEmpty() && System.currentTimeMillis() - startConnect < (long)this.socketConnectTimeout) {
            block5: {
                ConnectableAddress address = (ConnectableAddress)connectableAddresses.get(0);
                try {
                    Socket socket = this.settings.getConnectionSecurity() == ConnectionSecurity.SSL_TLS_REQUIRED ? this.socketFactory.createSocket(null, host, port, clientCertificateAlias) : new Socket();
                    address.connect(socket, (long)this.socketConnectTimeout - (System.currentTimeMillis() - startConnect));
                    return socket;
                }
                catch (ConnectableAddress.MaxRetriesException e) {
                    connectableAddresses.remove(address);
                }
                catch (IOException ignored) {
                    if (!K9MailLib.isDebug()) break block5;
                    Log.w((String)"k9", (Throwable)ignored);
                }
            }
            Collections.sort(connectableAddresses);
        }
        throw new MessagingException("Cannot connect to host " + host + ":" + port);
    }

    private void configureSocket() throws SocketException {
        this.socket.setSoTimeout(this.socketReadTimeout);
    }

    private void setUpStreamsAndParserFromSocket() throws IOException {
        this.setUpStreamsAndParser(this.socket.getInputStream(), this.socket.getOutputStream());
    }

    private void setUpStreamsAndParser(InputStream input, OutputStream output) {
        this.inputStream = new PeekableInputStream(new BufferedInputStream(input, 1024));
        this.responseParser = new ImapResponseParser(this.inputStream);
        this.outputStream = new BufferedOutputStream(output, 1024);
    }

    private void readInitialResponse() throws IOException {
        ImapResponse initialResponse = this.responseParser.readResponse();
        if (K9MailLib.isDebug() && K9MailLib.DEBUG_PROTOCOL_IMAP) {
            Log.v((String)"k9", (String)(this.getLogId() + "<<<" + initialResponse));
        }
        this.extractCapabilities(Collections.singletonList(initialResponse));
    }

    private List<ImapResponse> extractCapabilities(List<ImapResponse> responses) {
        CapabilityResponse capabilityResponse = CapabilityResponse.parse(responses);
        if (capabilityResponse != null) {
            Set<String> receivedCapabilities = capabilityResponse.getCapabilities();
            if (K9MailLib.isDebug()) {
                Log.d((String)"k9", (String)("Saving " + receivedCapabilities + " capabilities for " + this.getLogId()));
            }
            this.capabilities = receivedCapabilities;
        }
        return responses;
    }

    private void requestCapabilitiesIfNecessary() throws IOException, MessagingException {
        if (!this.capabilities.isEmpty()) {
            return;
        }
        if (K9MailLib.isDebug()) {
            Log.i((String)"k9", (String)("Did not get capabilities in banner, requesting CAPABILITY for " + this.getLogId()));
        }
        this.requestCapabilities();
    }

    private void requestCapabilities() throws IOException, MessagingException {
        List<ImapResponse> responses = this.extractCapabilities(this.executeSimpleCommand("CAPABILITY"));
        if (responses.size() != 2) {
            throw new MessagingException("Invalid CAPABILITY response received");
        }
    }

    private void upgradeToTlsIfNecessary() throws IOException, MessagingException, GeneralSecurityException {
        if (this.settings.getConnectionSecurity() == ConnectionSecurity.STARTTLS_REQUIRED) {
            this.upgradeToTls();
        }
    }

    private void upgradeToTls() throws IOException, MessagingException, GeneralSecurityException {
        if (!this.hasCapability("STARTTLS")) {
            throw new CertificateValidationException("STARTTLS connection security not available");
        }
        this.startTLS();
    }

    private void startTLS() throws IOException, MessagingException, GeneralSecurityException {
        this.executeSimpleCommand("STARTTLS");
        String host = this.settings.getHost();
        int port = this.settings.getPort();
        String clientCertificateAlias = this.settings.getClientCertificateAlias();
        this.socket = this.socketFactory.createSocket(this.socket, host, port, clientCertificateAlias);
        this.configureSocket();
        this.setUpStreamsAndParserFromSocket();
        if (K9MailLib.isDebug()) {
            Log.i((String)"k9", (String)("Updating capabilities after STARTTLS for " + this.getLogId()));
        }
        this.requestCapabilities();
    }

    private void authenticate() throws MessagingException, IOException {
        switch (this.settings.getAuthType()) {
            case CRAM_MD5: {
                if (this.hasCapability("AUTH=CRAM-MD5")) {
                    this.authCramMD5();
                    break;
                }
                throw new MessagingException("Server doesn't support encrypted passwords using CRAM-MD5.");
            }
            case PLAIN: {
                if (this.hasCapability("AUTH=PLAIN")) {
                    this.saslAuthPlainWithLoginFallback();
                    break;
                }
                if (!this.hasCapability("LOGINDISABLED")) {
                    this.login();
                    break;
                }
                throw new MessagingException("Server doesn't support unencrypted passwords using AUTH=PLAIN and LOGIN is disabled.");
            }
            case EXTERNAL: {
                if (this.hasCapability("AUTH=EXTERNAL")) {
                    this.saslAuthExternal();
                    break;
                }
                throw new CertificateValidationException(CertificateValidationException.Reason.MissingCapability);
            }
            case XOAUTH2: {
                this.handleXOAuth(this.settings.getAuthType().name(), this.settings.getPassword());
                break;
            }
            default: {
                throw new MessagingException("Unhandled authentication method found in the server settings (bug).");
            }
        }
    }

    private void handleXOAuth(String name, String token) throws IOException, MessagingException {
        if (!this.hasCapability("AUTH=" + name)) {
            throw new MessagingException("Server does not support " + name);
        }
        final JSONObject[] obj = new JSONObject[1];
        try {
            String tag = this.sendCommand("AUTHENTICATE " + name + " " + token, true);
            this.readStatusResponse(tag, null, new UntaggedHandler(){

                @Override
                public void handleAsyncUntaggedResponse(ImapResponse response) {
                    if (K9MailLib.isDebug() && K9MailLib.DEBUG_PROTOCOL_IMAP) {
                        Log.d((String)"k9", (String)("Untagged response " + response.toString()));
                    }
                    if (response.isContinuationRequested() && response.size() == 1) {
                        String resp = new String(Base64.decodeBase64(response.get(0).toString().getBytes()));
                        try {
                            obj[0] = new JSONObject(resp);
                        }
                        catch (JSONException e) {
                            Log.w((String)"k9", (String)("error parsing response" + response.toString()), (Throwable)e);
                        }
                        try {
                            ImapConnection.this.outputStream.write(13);
                            ImapConnection.this.outputStream.write(10);
                            ImapConnection.this.outputStream.flush();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            });
        }
        catch (MessagingException e) {
            throw new XOAuth2AuthenticationFailedException(e.getMessage(), obj[0]);
        }
    }

    private void authCramMD5() throws MessagingException, IOException {
        String command = "AUTHENTICATE CRAM-MD5";
        String tag = this.sendCommand(command, false);
        ImapResponse response = this.readContinuationResponse(tag);
        if (response.size() != 1 || !(response.get(0) instanceof String)) {
            throw new MessagingException("Invalid Cram-MD5 nonce received");
        }
        byte[] b64Nonce = response.getString(0).getBytes();
        byte[] b64CRAM = Authentication.computeCramMd5Bytes(this.settings.getUsername(), this.settings.getPassword(), b64Nonce);
        this.outputStream.write(b64CRAM);
        this.outputStream.write(13);
        this.outputStream.write(10);
        this.outputStream.flush();
        try {
            this.extractCapabilities(this.responseParser.readStatusResponse(tag, command, this.getLogId(), null));
        }
        catch (NegativeImapResponseException e) {
            throw new AuthenticationFailedException(e.getMessage());
        }
    }

    private void saslAuthPlainWithLoginFallback() throws IOException, MessagingException {
        try {
            this.saslAuthPlain();
        }
        catch (AuthenticationFailedException e) {
            this.login();
        }
    }

    private void saslAuthPlain() throws IOException, MessagingException {
        String command = "AUTHENTICATE PLAIN";
        String tag = this.sendCommand(command, false);
        this.readContinuationResponse(tag);
        String credentials = "\u0000" + this.settings.getUsername() + "\u0000" + this.settings.getPassword();
        byte[] encodedCredentials = Base64.encodeBase64(credentials.getBytes());
        this.outputStream.write(encodedCredentials);
        this.outputStream.write(13);
        this.outputStream.write(10);
        this.outputStream.flush();
        try {
            this.extractCapabilities(this.responseParser.readStatusResponse(tag, command, this.getLogId(), null));
        }
        catch (NegativeImapResponseException e) {
            throw new AuthenticationFailedException(e.getMessage());
        }
    }

    private void login() throws IOException, MessagingException {
        Pattern p = Pattern.compile("[\\\\\"]");
        String replacement = "\\\\$0";
        String username = p.matcher(this.settings.getUsername()).replaceAll(replacement);
        String password = p.matcher(this.settings.getPassword()).replaceAll(replacement);
        try {
            String command = String.format("LOGIN \"%s\" \"%s\"", username, password);
            this.extractCapabilities(this.executeSimpleCommand(command, true));
        }
        catch (NegativeImapResponseException e) {
            throw new AuthenticationFailedException(e.getMessage());
        }
    }

    private void saslAuthExternal() throws IOException, MessagingException {
        try {
            String command = "AUTHENTICATE EXTERNAL " + Base64.encode(this.settings.getUsername());
            this.extractCapabilities(this.executeSimpleCommand(command, false));
        }
        catch (NegativeImapResponseException e) {
            throw new CertificateValidationException(e.getMessage());
        }
    }

    private void enableCompressionIfRequested() throws IOException, MessagingException {
        if (this.hasCapability("COMPRESS=DEFLATE") && this.shouldEnableCompression()) {
            this.enableCompression();
        }
    }

    private boolean shouldEnableCompression() {
        boolean useCompression = true;
        NetworkInfo networkInfo = this.connectivityManager.getActiveNetworkInfo();
        if (networkInfo != null) {
            int type = networkInfo.getType();
            if (K9MailLib.isDebug()) {
                Log.d((String)"k9", (String)("On network type " + type));
            }
            NetworkType networkType = NetworkType.fromConnectivityManagerType(type);
            useCompression = this.settings.useCompression(networkType);
        }
        if (K9MailLib.isDebug()) {
            Log.d((String)"k9", (String)("useCompression " + useCompression));
        }
        return useCompression;
    }

    private void enableCompression() throws IOException, MessagingException {
        try {
            this.executeSimpleCommand("COMPRESS DEFLATE");
        }
        catch (NegativeImapResponseException e) {
            Log.d((String)"k9", (String)("Unable to negotiate compression: " + e.getMessage()));
            return;
        }
        try {
            InflaterInputStream input = new InflaterInputStream(this.socket.getInputStream(), new Inflater(true));
            ZOutputStream output = new ZOutputStream(this.socket.getOutputStream(), 1, true);
            output.setFlushMode(1);
            this.setUpStreamsAndParser(input, (OutputStream)output);
            if (K9MailLib.isDebug()) {
                Log.i((String)"k9", (String)("Compression enabled for " + this.getLogId()));
            }
        }
        catch (IOException e) {
            this.close();
            Log.e((String)"k9", (String)"Error enabling compression", (Throwable)e);
        }
    }

    private void retrievePathPrefixIfNecessary() throws IOException, MessagingException {
        if (this.settings.getPathPrefix() != null) {
            return;
        }
        if (this.hasCapability("NAMESPACE")) {
            if (K9MailLib.isDebug()) {
                Log.i((String)"k9", (String)"pathPrefix is unset and server has NAMESPACE capability");
            }
            this.handleNamespace();
        } else {
            if (K9MailLib.isDebug()) {
                Log.i((String)"k9", (String)"pathPrefix is unset but server does not have NAMESPACE capability");
            }
            this.settings.setPathPrefix("");
        }
    }

    private void handleNamespace() throws IOException, MessagingException {
        List<ImapResponse> responses = this.executeSimpleCommand("NAMESPACE");
        NamespaceResponse namespaceResponse = NamespaceResponse.parse(responses);
        if (namespaceResponse != null) {
            String prefix = namespaceResponse.getPrefix();
            String hierarchyDelimiter = namespaceResponse.getHierarchyDelimiter();
            this.settings.setPathPrefix(prefix);
            this.settings.setPathDelimiter(hierarchyDelimiter);
            this.settings.setCombinedPrefix(null);
            if (K9MailLib.isDebug()) {
                Log.d((String)"k9", (String)("Got path '" + prefix + "' and separator '" + hierarchyDelimiter + "'"));
            }
        }
    }

    private void retrievePathDelimiterIfNecessary() throws IOException, MessagingException {
        if (this.settings.getPathDelimiter() == null) {
            this.retrievePathDelimiter();
        }
    }

    private void retrievePathDelimiter() throws IOException, MessagingException {
        List<ImapResponse> listResponses;
        try {
            listResponses = this.executeSimpleCommand("LIST \"\" \"\"");
        }
        catch (NegativeImapResponseException e) {
            Log.d((String)"k9", (String)"Error getting path delimiter using LIST command", (Throwable)e);
            return;
        }
        for (ImapResponse response : listResponses) {
            if (!this.isListResponse(response)) continue;
            String hierarchyDelimiter = response.getString(2);
            this.settings.setPathDelimiter(hierarchyDelimiter);
            this.settings.setCombinedPrefix(null);
            if (!K9MailLib.isDebug()) break;
            Log.d((String)"k9", (String)("Got path delimiter '" + this.settings.getPathDelimiter() + "' for " + this.getLogId()));
            break;
        }
    }

    private boolean isListResponse(ImapResponse response) {
        boolean responseTooShort;
        boolean bl = responseTooShort = response.size() < 4;
        if (responseTooShort) {
            return false;
        }
        boolean isListResponse = ImapResponseParser.equalsIgnoreCase(response.get(0), "LIST");
        boolean hierarchyDelimiterValid = response.get(2) instanceof String;
        return isListResponse && hierarchyDelimiterValid;
    }

    protected boolean hasCapability(String capability) {
        return this.capabilities.contains(capability.toUpperCase(Locale.US));
    }

    protected boolean isIdleCapable() {
        if (K9MailLib.isDebug()) {
            Log.v((String)"k9", (String)("Connection " + this.getLogId() + " has " + this.capabilities.size() + " capabilities"));
        }
        return this.capabilities.contains("IDLE");
    }

    public void close() {
        this.open = false;
        this.stacktraceForClose = new Exception();
        IOUtils.closeQuietly((InputStream)this.inputStream);
        IOUtils.closeQuietly((OutputStream)this.outputStream);
        IOUtils.closeQuietly((Socket)this.socket);
        this.inputStream = null;
        this.outputStream = null;
        this.socket = null;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    protected String getLogId() {
        return "conn" + this.hashCode();
    }

    public List<ImapResponse> executeSimpleCommand(String command) throws IOException, MessagingException {
        return this.executeSimpleCommand(command, false);
    }

    public List<ImapResponse> executeSimpleCommand(String command, boolean sensitive) throws IOException, MessagingException {
        String commandToLog = command;
        if (sensitive && !K9MailLib.isDebugSensitive()) {
            commandToLog = "*sensitive*";
        }
        String tag = this.sendCommand(command, sensitive);
        try {
            return this.responseParser.readStatusResponse(tag, commandToLog, this.getLogId(), null);
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    public List<ImapResponse> readStatusResponse(String tag, String commandToLog, UntaggedHandler untaggedHandler) throws IOException, NegativeImapResponseException {
        return this.responseParser.readStatusResponse(tag, commandToLog, this.getLogId(), untaggedHandler);
    }

    public String sendCommand(String command, boolean sensitive) throws MessagingException, IOException {
        try {
            this.open();
            String tag = Integer.toString(this.nextCommandTag++);
            String commandToSend = tag + " " + command + "\r\n";
            this.outputStream.write(commandToSend.getBytes());
            this.outputStream.flush();
            if (K9MailLib.isDebug() && K9MailLib.DEBUG_PROTOCOL_IMAP) {
                if (sensitive && !K9MailLib.isDebugSensitive()) {
                    Log.v((String)"k9", (String)(this.getLogId() + ">>> [Command Hidden, Enable Sensitive Debug Logging To Show]"));
                } else {
                    Log.v((String)"k9", (String)(this.getLogId() + ">>> " + tag + " " + command));
                }
            }
            return tag;
        }
        catch (MessagingException | IOException e) {
            this.close();
            throw e;
        }
    }

    public void sendContinuation(String continuation) throws IOException {
        this.outputStream.write(continuation.getBytes());
        this.outputStream.write(13);
        this.outputStream.write(10);
        this.outputStream.flush();
        if (K9MailLib.isDebug() && K9MailLib.DEBUG_PROTOCOL_IMAP) {
            Log.v((String)"k9", (String)(this.getLogId() + ">>> " + continuation));
        }
    }

    public ImapResponse readResponse() throws IOException, MessagingException {
        return this.readResponse(null);
    }

    public ImapResponse readResponse(ImapResponseCallback callback) throws IOException {
        try {
            ImapResponse response = this.responseParser.readResponse(callback);
            if (K9MailLib.isDebug() && K9MailLib.DEBUG_PROTOCOL_IMAP) {
                Log.v((String)"k9", (String)(this.getLogId() + "<<<" + response));
            }
            return response;
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    protected void setReadTimeout(int millis) throws SocketException {
        Socket sock = this.socket;
        if (sock != null) {
            sock.setSoTimeout(millis);
        }
    }

    private ImapResponse readContinuationResponse(String tag) throws IOException, MessagingException {
        ImapResponse response;
        do {
            String responseTag;
            if ((responseTag = (response = this.readResponse()).getTag()) == null) continue;
            if (responseTag.equalsIgnoreCase(tag)) {
                throw new MessagingException("Command continuation aborted: " + response);
            }
            Log.w((String)"k9", (String)("After sending tag " + tag + ", got tag response from previous command " + response + " for " + this.getLogId()));
        } while (!response.isContinuationRequested());
        return response;
    }

    private static class ConnectableAddress
    implements Comparable<ConnectableAddress> {
        private final long initialBackoff = 5000L;
        private final int maxTries = 3;
        private final InetSocketAddress socketAddress;
        private long lastAttempt;
        private int numTries;

        ConnectableAddress(InetSocketAddress socketAddress) {
            this.socketAddress = socketAddress;
        }

        void connect(Socket socket, long remainingTime) throws IOException {
            if (this.numTries++ >= 3) {
                throw new MaxRetriesException();
            }
            if (remainingTime <= 0L) {
                throw new SocketTimeoutException();
            }
            int timeout = (int)Math.min((double)remainingTime, 5000.0 * Math.pow(2.0, this.numTries - 1));
            if (K9MailLib.isDebug() && K9MailLib.DEBUG_PROTOCOL_IMAP) {
                Log.d((String)"k9", (String)("Connecting to " + this + ", timeout=" + timeout));
            }
            this.lastAttempt = System.currentTimeMillis();
            socket.connect(this.socketAddress, timeout);
        }

        public String toString() {
            return "ConnectableAddress{ " + this.socketAddress + ", lastAttempt=" + this.lastAttempt + ", numTries=" + this.numTries + '}';
        }

        @Override
        public int compareTo(ConnectableAddress other) {
            int val = ConnectableAddress.compare(this.lastAttempt, other.lastAttempt);
            if (val == 0) {
                val = ConnectableAddress.compare(this.numTries, other.numTries);
            }
            if (val == 0) {
                val = ConnectableAddress.compare(other.socketAddress.getAddress().getAddress().length, this.socketAddress.getAddress().getAddress().length);
            }
            return val;
        }

        private static int compare(long a, long b) {
            return Long.valueOf(a).compareTo(b);
        }

        static class MaxRetriesException
        extends IOException {
            MaxRetriesException() {
            }
        }
    }
}

