/*
 * Decompiled with CFR 0.152.
 */
package com.fsck.k9.mail.store.imap;

import com.fsck.k9.mail.store.imap.ImapList;
import com.fsck.k9.mail.store.imap.ImapResponse;
import com.fsck.k9.mail.store.imap.ImapResponseParser;
import com.fsck.k9.mail.store.imap.ImapUtility;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class CopyUidResponse {
    private final Map<String, String> uidMapping;

    private CopyUidResponse(Map<String, String> uidMapping) {
        this.uidMapping = Collections.unmodifiableMap(uidMapping);
    }

    public static CopyUidResponse parse(ImapResponse response) {
        if (!(response.isTagged() && response.size() >= 2 && ImapResponseParser.equalsIgnoreCase(response.get(0), "OK") && response.isList(1))) {
            return null;
        }
        ImapList responseTextList = response.getList(1);
        if (!(responseTextList.size() >= 4 && ImapResponseParser.equalsIgnoreCase(responseTextList.get(0), "COPYUID") && responseTextList.isString(1) && responseTextList.isString(2) && responseTextList.isString(3))) {
            return null;
        }
        List<String> sourceUids = ImapUtility.getImapSequenceValues(responseTextList.getString(2));
        List<String> destinationUids = ImapUtility.getImapSequenceValues(responseTextList.getString(3));
        int size = sourceUids.size();
        if (size == 0 || size != destinationUids.size()) {
            return null;
        }
        HashMap<String, String> uidMapping = new HashMap<String, String>(size);
        for (int i = 0; i < size; ++i) {
            String sourceUid = sourceUids.get(i);
            String destinationUid = destinationUids.get(i);
            uidMapping.put(sourceUid, destinationUid);
        }
        return new CopyUidResponse(uidMapping);
    }

    public Map<String, String> getUidMapping() {
        return this.uidMapping;
    }
}

