/*
 * Decompiled with CFR 0.152.
 */
package com.fsck.k9.mail.ssl;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.security.KeyChain;
import android.security.KeyChainException;
import android.util.Log;
import com.fsck.k9.mail.CertificateValidationException;
import com.fsck.k9.mail.MessagingException;
import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.security.auth.x500.X500Principal;

@TargetApi(value=14)
class KeyChainKeyManager
extends X509ExtendedKeyManager {
    private static PrivateKey sClientCertificateReferenceWorkaround;
    private final String mAlias;
    private final X509Certificate[] mChain;
    private final PrivateKey mPrivateKey;

    private static synchronized void savePrivateKeyReference(PrivateKey privateKey) {
        if (sClientCertificateReferenceWorkaround == null) {
            sClientCertificateReferenceWorkaround = privateKey;
        }
    }

    public KeyChainKeyManager(Context context, String alias) throws MessagingException {
        this.mAlias = alias;
        try {
            this.mChain = this.fetchCertificateChain(context, alias);
            this.mPrivateKey = this.fetchPrivateKey(context, alias);
        }
        catch (KeyChainException e) {
            throw new CertificateValidationException(e.getMessage(), CertificateValidationException.Reason.RetrievalFailure, alias);
        }
        catch (InterruptedException e) {
            throw new CertificateValidationException(e.getMessage(), CertificateValidationException.Reason.RetrievalFailure, alias);
        }
    }

    private X509Certificate[] fetchCertificateChain(Context context, String alias) throws KeyChainException, InterruptedException, MessagingException {
        X509Certificate[] chain = KeyChain.getCertificateChain((Context)context, (String)alias);
        if (chain == null || chain.length == 0) {
            throw new MessagingException("No certificate chain found for: " + alias);
        }
        try {
            for (X509Certificate certificate : chain) {
                certificate.checkValidity();
            }
        }
        catch (CertificateException e) {
            throw new CertificateValidationException(e.getMessage(), CertificateValidationException.Reason.Expired, alias);
        }
        return chain;
    }

    private PrivateKey fetchPrivateKey(Context context, String alias) throws KeyChainException, InterruptedException, MessagingException {
        PrivateKey privateKey = KeyChain.getPrivateKey((Context)context, (String)alias);
        if (privateKey == null) {
            throw new MessagingException("No private key found for: " + alias);
        }
        if (Build.VERSION.SDK_INT < 17) {
            KeyChainKeyManager.savePrivateKeyReference(privateKey);
        }
        return privateKey;
    }

    @Override
    public String chooseClientAlias(String[] keyTypes, Principal[] issuers, Socket socket) {
        return this.chooseAlias(keyTypes, issuers);
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        return this.mAlias.equals(alias) ? this.mChain : null;
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        return this.mAlias.equals(alias) ? this.mPrivateKey : null;
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        return this.chooseAlias(new String[]{keyType}, issuers);
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        String[] stringArray;
        String al = this.chooseAlias(new String[]{keyType}, issuers);
        if (al == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = al;
        }
        return stringArray;
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        String[] stringArray;
        String al = this.chooseAlias(new String[]{keyType}, issuers);
        if (al == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = al;
        }
        return stringArray;
    }

    @Override
    public String chooseEngineClientAlias(String[] keyTypes, Principal[] issuers, SSLEngine engine) {
        return this.chooseAlias(keyTypes, issuers);
    }

    @Override
    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
        return this.chooseAlias(new String[]{keyType}, issuers);
    }

    private String chooseAlias(String[] keyTypes, Principal[] issuers) {
        if (keyTypes == null || keyTypes.length == 0) {
            return null;
        }
        X509Certificate cert = this.mChain[0];
        String certKeyAlg = cert.getPublicKey().getAlgorithm();
        String certSigAlg = cert.getSigAlgName().toUpperCase(Locale.US);
        for (String keyAlgorithm : keyTypes) {
            String sigAlgorithm;
            if (keyAlgorithm == null) continue;
            int index = keyAlgorithm.indexOf(95);
            if (index == -1) {
                sigAlgorithm = null;
            } else {
                sigAlgorithm = keyAlgorithm.substring(index + 1);
                keyAlgorithm = keyAlgorithm.substring(0, index);
            }
            if (!certKeyAlg.equals(keyAlgorithm) || sigAlgorithm != null && certSigAlg != null && !certSigAlg.contains(sigAlgorithm)) continue;
            if (issuers == null || issuers.length == 0) {
                return this.mAlias;
            }
            List<Principal> issuersList = Arrays.asList(issuers);
            for (X509Certificate certFromChain : this.mChain) {
                X500Principal issuerFromChain = certFromChain.getIssuerX500Principal();
                if (!issuersList.contains(issuerFromChain)) continue;
                return this.mAlias;
            }
            Log.w((String)"k9", (String)("Client certificate " + this.mAlias + " not issued by any of the requested issuers"));
            return null;
        }
        Log.w((String)"k9", (String)("Client certificate " + this.mAlias + " does not match any of the requested key types"));
        return null;
    }
}

