/*
 * Decompiled with CFR 0.152.
 */
package com.fsck.k9.mail.ssl;

import android.content.Context;
import android.net.SSLCertificateSocketFactory;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import com.fsck.k9.mail.MessagingException;
import com.fsck.k9.mail.ssl.KeyChainKeyManager;
import com.fsck.k9.mail.ssl.TrustManagerFactory;
import com.fsck.k9.mail.ssl.TrustedSocketFactory;
import java.io.IOException;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class DefaultTrustedSocketFactory
implements TrustedSocketFactory {
    protected static final String[] ENABLED_CIPHERS;
    protected static final String[] ENABLED_PROTOCOLS;
    protected static final String[] ORDERED_KNOWN_CIPHERS;
    protected static final String[] BLACKLISTED_CIPHERS;
    protected static final String[] ORDERED_KNOWN_PROTOCOLS;
    protected static final String[] BLACKLISTED_PROTOCOLS;
    private Context context;

    public DefaultTrustedSocketFactory(Context context) {
        this.context = context;
    }

    protected static String[] reorder(String[] enabled, String[] known, String[] blacklisted) {
        ArrayList unknown = new ArrayList();
        Collections.addAll(unknown, enabled);
        if (blacklisted != null) {
            for (String item : blacklisted) {
                unknown.remove(item);
            }
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String item : known) {
            if (!unknown.remove(item)) continue;
            result.add(item);
        }
        result.addAll(unknown);
        return result.toArray(new String[result.size()]);
    }

    @Override
    public Socket createSocket(Socket socket, String host, int port, String clientCertificateAlias) throws NoSuchAlgorithmException, KeyManagementException, MessagingException, IOException {
        TrustManager[] trustManagers = new TrustManager[]{TrustManagerFactory.get(host, port)};
        KeyManager[] keyManagers = null;
        if (!TextUtils.isEmpty((CharSequence)clientCertificateAlias)) {
            if (Build.VERSION.SDK_INT >= 14) {
                keyManagers = new KeyManager[]{new KeyChainKeyManager(this.context, clientCertificateAlias)};
            } else {
                throw new KeyManagementException("clientCertificates are not supported with this version of Android");
            }
        }
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(keyManagers, trustManagers, null);
        SSLSocketFactory socketFactory = sslContext.getSocketFactory();
        Socket trustedSocket = socket == null ? socketFactory.createSocket() : socketFactory.createSocket(socket, host, port, true);
        SSLSocket sslSocket = (SSLSocket)trustedSocket;
        DefaultTrustedSocketFactory.hardenSocket(sslSocket);
        DefaultTrustedSocketFactory.setSniHost(socketFactory, sslSocket, host);
        return trustedSocket;
    }

    private static void hardenSocket(SSLSocket sock) {
        if (ENABLED_CIPHERS != null) {
            sock.setEnabledCipherSuites(ENABLED_CIPHERS);
        }
        if (ENABLED_PROTOCOLS != null) {
            sock.setEnabledProtocols(ENABLED_PROTOCOLS);
        }
    }

    public static void setSniHost(SSLSocketFactory factory, SSLSocket socket, String hostname) {
        if (Build.VERSION.SDK_INT >= 17 && factory instanceof SSLCertificateSocketFactory) {
            SSLCertificateSocketFactory sslCertificateSocketFactory = (SSLCertificateSocketFactory)factory;
            sslCertificateSocketFactory.setHostname((Socket)socket, hostname);
        } else {
            DefaultTrustedSocketFactory.setHostnameViaReflection(socket, hostname);
        }
    }

    private static void setHostnameViaReflection(SSLSocket socket, String hostname) {
        try {
            socket.getClass().getMethod("setHostname", String.class).invoke((Object)socket, hostname);
        }
        catch (Throwable e) {
            Log.e((String)"k9", (String)"Could not call SSLSocket#setHostname(String) method ", (Throwable)e);
        }
    }

    static {
        ORDERED_KNOWN_CIPHERS = new String[]{"TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_DHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_DHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA", "TLS_DHE_DSS_WITH_AES_256_CBC_SHA", "TLS_ECDH_RSA_WITH_AES_256_CBC_SHA", "TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA", "TLS_RSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA", "TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA", "TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA", "TLS_DHE_DSS_WITH_AES_128_CBC_SHA", "TLS_ECDH_RSA_WITH_AES_128_CBC_SHA", "TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA"};
        BLACKLISTED_CIPHERS = new String[]{"SSL_RSA_WITH_DES_CBC_SHA", "SSL_DHE_RSA_WITH_DES_CBC_SHA", "SSL_DHE_DSS_WITH_DES_CBC_SHA", "SSL_RSA_EXPORT_WITH_RC4_40_MD5", "SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA", "TLS_ECDHE_RSA_WITH_RC4_128_SHA", "TLS_ECDHE_ECDSA_WITH_RC4_128_SHA", "TLS_ECDH_RSA_WITH_RC4_128_SHA", "TLS_ECDH_ECDSA_WITH_RC4_128_SHA", "SSL_RSA_WITH_RC4_128_SHA", "SSL_RSA_WITH_RC4_128_MD5"};
        ORDERED_KNOWN_PROTOCOLS = new String[]{"TLSv1.2", "TLSv1.1", "TLSv1"};
        BLACKLISTED_PROTOCOLS = new String[]{"SSLv3"};
        String[] enabledCiphers = null;
        String[] supportedProtocols = null;
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, null, null);
            SSLSocketFactory sf = sslContext.getSocketFactory();
            SSLSocket sock = (SSLSocket)sf.createSocket();
            enabledCiphers = sock.getEnabledCipherSuites();
            supportedProtocols = sock.getSupportedProtocols();
        }
        catch (Exception e) {
            Log.e((String)"k9", (String)"Error getting information about available SSL/TLS ciphers and protocols", (Throwable)e);
        }
        ENABLED_CIPHERS = enabledCiphers == null ? null : DefaultTrustedSocketFactory.reorder(enabledCiphers, ORDERED_KNOWN_CIPHERS, BLACKLISTED_CIPHERS);
        ENABLED_PROTOCOLS = supportedProtocols == null ? null : DefaultTrustedSocketFactory.reorder(supportedProtocols, ORDERED_KNOWN_PROTOCOLS, BLACKLISTED_PROTOCOLS);
    }
}

