/*
 * Decompiled with CFR 0.152.
 */
package com.fsck.k9.mail.power;

import android.content.Context;
import android.os.PowerManager;
import android.util.Log;
import com.fsck.k9.mail.K9MailLib;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;

public class TracingPowerManager {
    private static final boolean TRACE = false;
    public static AtomicInteger wakeLockId = new AtomicInteger(0);
    PowerManager pm = null;
    private static TracingPowerManager tracingPowerManager;
    private Timer timer = null;

    public static synchronized TracingPowerManager getPowerManager(Context context) {
        Context appContext = context.getApplicationContext();
        if (tracingPowerManager == null) {
            if (K9MailLib.isDebug()) {
                Log.v((String)"k9", (String)"Creating TracingPowerManager");
            }
            tracingPowerManager = new TracingPowerManager(appContext);
        }
        return tracingPowerManager;
    }

    private TracingPowerManager(Context context) {
        this.pm = (PowerManager)context.getSystemService("power");
    }

    public TracingWakeLock newWakeLock(int flags, String tag) {
        return new TracingWakeLock(flags, tag);
    }

    public class TracingWakeLock {
        final PowerManager.WakeLock wakeLock;
        final int id;
        final String tag;
        volatile TimerTask timerTask;
        volatile Long startTime = null;
        volatile Long timeout = null;

        public TracingWakeLock(int flags, String ntag) {
            this.tag = ntag;
            this.wakeLock = TracingPowerManager.this.pm.newWakeLock(flags, this.tag);
            this.id = wakeLockId.getAndIncrement();
            if (K9MailLib.isDebug()) {
                Log.v((String)"k9", (String)("TracingWakeLock for tag " + this.tag + " / id " + this.id + ": Create"));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void acquire(long timeout) {
            PowerManager.WakeLock wakeLock = this.wakeLock;
            synchronized (wakeLock) {
                this.wakeLock.acquire(timeout);
            }
            if (K9MailLib.isDebug()) {
                Log.v((String)"k9", (String)("TracingWakeLock for tag " + this.tag + " / id " + this.id + " for " + timeout + " ms: acquired"));
            }
            this.raiseNotification();
            if (this.startTime == null) {
                this.startTime = System.currentTimeMillis();
            }
            this.timeout = timeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void acquire() {
            PowerManager.WakeLock wakeLock = this.wakeLock;
            synchronized (wakeLock) {
                this.wakeLock.acquire();
            }
            this.raiseNotification();
            if (K9MailLib.isDebug()) {
                Log.w((String)"k9", (String)("TracingWakeLock for tag " + this.tag + " / id " + this.id + ": acquired with no timeout.  K-9 Mail should not do this"));
            }
            if (this.startTime == null) {
                this.startTime = System.currentTimeMillis();
            }
            this.timeout = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setReferenceCounted(boolean counted) {
            PowerManager.WakeLock wakeLock = this.wakeLock;
            synchronized (wakeLock) {
                this.wakeLock.setReferenceCounted(counted);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            if (this.startTime != null) {
                Long endTime = System.currentTimeMillis();
                if (K9MailLib.isDebug()) {
                    Log.v((String)"k9", (String)("TracingWakeLock for tag " + this.tag + " / id " + this.id + ": releasing after " + (endTime - this.startTime) + " ms, timeout = " + this.timeout + " ms"));
                }
            } else if (K9MailLib.isDebug()) {
                Log.v((String)"k9", (String)("TracingWakeLock for tag " + this.tag + " / id " + this.id + ", timeout = " + this.timeout + " ms: releasing"));
            }
            this.cancelNotification();
            PowerManager.WakeLock wakeLock = this.wakeLock;
            synchronized (wakeLock) {
                this.wakeLock.release();
            }
            this.startTime = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cancelNotification() {
            if (TracingPowerManager.this.timer != null) {
                Timer timer = TracingPowerManager.this.timer;
                synchronized (timer) {
                    if (this.timerTask != null) {
                        this.timerTask.cancel();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void raiseNotification() {
            if (TracingPowerManager.this.timer != null) {
                Timer timer = TracingPowerManager.this.timer;
                synchronized (timer) {
                    if (this.timerTask != null) {
                        this.timerTask.cancel();
                        this.timerTask = null;
                    }
                    this.timerTask = new TimerTask(){

                        @Override
                        public void run() {
                            if (TracingWakeLock.this.startTime != null) {
                                Long endTime = System.currentTimeMillis();
                                Log.i((String)"k9", (String)("TracingWakeLock for tag " + TracingWakeLock.this.tag + " / id " + TracingWakeLock.this.id + ": has been active for " + (endTime - TracingWakeLock.this.startTime) + " ms, timeout = " + TracingWakeLock.this.timeout + " ms"));
                            } else {
                                Log.i((String)"k9", (String)("TracingWakeLock for tag " + TracingWakeLock.this.tag + " / id " + TracingWakeLock.this.id + ": still active, timeout = " + TracingWakeLock.this.timeout + " ms"));
                            }
                        }
                    };
                    TracingPowerManager.this.timer.schedule(this.timerTask, 1000L, 1000L);
                }
            }
        }
    }
}

