/*
 * Decompiled with CFR 0.152.
 */
package com.fsck.k9.mail.internet;

import android.support.annotation.Nullable;
import android.util.Log;
import com.fsck.k9.mail.Body;
import com.fsck.k9.mail.MessagingException;
import com.fsck.k9.mail.filter.CountingOutputStream;
import com.fsck.k9.mail.filter.SignSafeOutputStream;
import com.fsck.k9.mail.internet.SizeAware;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.james.mime4j.codec.QuotedPrintableOutputStream;

public class TextBody
implements Body,
SizeAware {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final String text;
    private String encoding;
    private String charset = "UTF-8";
    @Nullable
    private Integer composedMessageLength;
    @Nullable
    private Integer composedMessageOffset;

    public TextBody(String body) {
        this.text = body;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException, MessagingException {
        if (this.text != null) {
            byte[] bytes = this.text.getBytes(this.charset);
            if ("quoted-printable".equalsIgnoreCase(this.encoding)) {
                this.writeSignSafeQuotedPrintable(out, bytes);
            } else if ("8bit".equalsIgnoreCase(this.encoding)) {
                out.write(bytes);
            } else {
                throw new IllegalStateException("Cannot get size for encoding!");
            }
        }
    }

    public String getRawText() {
        return this.text;
    }

    @Override
    public InputStream getInputStream() throws MessagingException {
        try {
            byte[] b = this.text != null ? this.text.getBytes(this.charset) : EMPTY_BYTE_ARRAY;
            return new ByteArrayInputStream(b);
        }
        catch (UnsupportedEncodingException uee) {
            Log.e((String)"k9", (String)("Unsupported charset: " + this.charset), (Throwable)uee);
            return null;
        }
    }

    @Override
    public void setEncoding(String encoding) {
        boolean isSupportedEncoding;
        boolean bl = isSupportedEncoding = "quoted-printable".equalsIgnoreCase(encoding) || "8bit".equalsIgnoreCase(encoding);
        if (!isSupportedEncoding) {
            throw new IllegalArgumentException("Cannot encode to " + encoding);
        }
        this.encoding = encoding;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    @Nullable
    public Integer getComposedMessageLength() {
        return this.composedMessageLength;
    }

    public void setComposedMessageLength(@Nullable Integer composedMessageLength) {
        this.composedMessageLength = composedMessageLength;
    }

    @Nullable
    public Integer getComposedMessageOffset() {
        return this.composedMessageOffset;
    }

    public void setComposedMessageOffset(@Nullable Integer composedMessageOffset) {
        this.composedMessageOffset = composedMessageOffset;
    }

    @Override
    public long getSize() {
        try {
            byte[] bytes = this.text.getBytes(this.charset);
            if ("quoted-printable".equalsIgnoreCase(this.encoding)) {
                return this.getLengthWhenQuotedPrintableEncoded(bytes);
            }
            if ("8bit".equalsIgnoreCase(this.encoding)) {
                return bytes.length;
            }
            throw new IllegalStateException("Cannot get size for encoding!");
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't get body size", e);
        }
    }

    private long getLengthWhenQuotedPrintableEncoded(byte[] bytes) throws IOException {
        CountingOutputStream countingOutputStream = new CountingOutputStream();
        this.writeSignSafeQuotedPrintable(countingOutputStream, bytes);
        return countingOutputStream.getCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSignSafeQuotedPrintable(OutputStream out, byte[] bytes) throws IOException {
        try (SignSafeOutputStream signSafeOutputStream = new SignSafeOutputStream(out);
             QuotedPrintableOutputStream signSafeQuotedPrintableOutputStream = new QuotedPrintableOutputStream((OutputStream)signSafeOutputStream, false);){
            signSafeQuotedPrintableOutputStream.write(bytes);
        }
    }

    public String getEncoding() {
        return this.encoding;
    }
}

