/*
 * Decompiled with CFR 0.152.
 */
package com.fsck.k9.mail.internet;

import android.net.MailTo;
import com.fsck.k9.mail.Address;
import com.fsck.k9.mail.Message;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ListHeaders {
    public static final String LIST_POST_HEADER = "List-Post";
    private static final Pattern MAILTO_CONTAINER_PATTERN = Pattern.compile("<(mailto:.+)>");

    public static Address[] getListPostAddresses(Message message) {
        String[] headerValues = message.getHeader(LIST_POST_HEADER);
        if (headerValues.length < 1) {
            return new Address[0];
        }
        ArrayList<Address> listPostAddresses = new ArrayList<Address>();
        for (String headerValue : headerValues) {
            Address address = ListHeaders.extractAddress(headerValue);
            if (address == null) continue;
            listPostAddresses.add(address);
        }
        return listPostAddresses.toArray(new Address[listPostAddresses.size()]);
    }

    private static Address extractAddress(String headerValue) {
        if (headerValue == null || headerValue.isEmpty()) {
            return null;
        }
        Matcher matcher = MAILTO_CONTAINER_PATTERN.matcher(headerValue);
        if (!matcher.find()) {
            return null;
        }
        String mailToUri = matcher.group(1);
        String emailAddress = MailTo.parse((String)mailToUri).getTo();
        return new Address(emailAddress);
    }
}

