/*
 * Decompiled with CFR 0.152.
 */
package com.fsck.k9.mail.internet;

import com.fsck.k9.mail.internet.CharsetSupport;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.BitSet;
import org.apache.james.mime4j.codec.EncoderUtil;
import org.apache.james.mime4j.util.CharsetUtil;

class EncoderUtil {
    private static final BitSet Q_RESTRICTED_CHARS = EncoderUtil.initChars("=_?\"#$%&'(),.:;<>@[\\]^`{|}~");
    private static final String ENC_WORD_PREFIX = "=?";
    private static final String ENC_WORD_SUFFIX = "?=";
    private static final int ENCODED_WORD_MAX_LENGTH = 75;

    private static BitSet initChars(String specials) {
        BitSet bs = new BitSet(128);
        for (int ch = 33; ch < 127; ch = (int)((char)(ch + 1))) {
            if (specials.indexOf(ch) != -1) continue;
            bs.set(ch);
        }
        return bs;
    }

    private EncoderUtil() {
    }

    public static String encodeEncodedWord(String text, Charset charset) {
        if (text == null) {
            throw new IllegalArgumentException();
        }
        if (charset == null) {
            charset = EncoderUtil.determineCharset(text);
        }
        String mimeCharset = CharsetSupport.getExternalCharset(charset.name());
        byte[] bytes = EncoderUtil.encode(text, charset);
        Encoding encoding = EncoderUtil.determineEncoding(bytes);
        if (encoding == Encoding.B) {
            String prefix = ENC_WORD_PREFIX + mimeCharset + "?B?";
            return EncoderUtil.encodeB(prefix, text, charset, bytes);
        }
        String prefix = ENC_WORD_PREFIX + mimeCharset + "?Q?";
        return EncoderUtil.encodeQ(prefix, text, charset, bytes);
    }

    private static String encodeB(String prefix, String text, Charset charset, byte[] bytes) {
        int encodedLength = EncoderUtil.bEncodedLength(bytes);
        int totalLength = prefix.length() + encodedLength + ENC_WORD_SUFFIX.length();
        if (totalLength <= 75) {
            return prefix + org.apache.james.mime4j.codec.EncoderUtil.encodeB((byte[])bytes) + ENC_WORD_SUFFIX;
        }
        String part1 = text.substring(0, text.length() / 2);
        byte[] bytes1 = EncoderUtil.encode(part1, charset);
        String word1 = EncoderUtil.encodeB(prefix, part1, charset, bytes1);
        String part2 = text.substring(text.length() / 2);
        byte[] bytes2 = EncoderUtil.encode(part2, charset);
        String word2 = EncoderUtil.encodeB(prefix, part2, charset, bytes2);
        return word1 + " " + word2;
    }

    private static int bEncodedLength(byte[] bytes) {
        return (bytes.length + 2) / 3 * 4;
    }

    private static String encodeQ(String prefix, String text, Charset charset, byte[] bytes) {
        int encodedLength = EncoderUtil.qEncodedLength(bytes);
        int totalLength = prefix.length() + encodedLength + ENC_WORD_SUFFIX.length();
        if (totalLength <= 75) {
            return prefix + org.apache.james.mime4j.codec.EncoderUtil.encodeQ((byte[])bytes, (EncoderUtil.Usage)EncoderUtil.Usage.WORD_ENTITY) + ENC_WORD_SUFFIX;
        }
        String part1 = text.substring(0, text.length() / 2);
        byte[] bytes1 = EncoderUtil.encode(part1, charset);
        String word1 = EncoderUtil.encodeQ(prefix, part1, charset, bytes1);
        String part2 = text.substring(text.length() / 2);
        byte[] bytes2 = EncoderUtil.encode(part2, charset);
        String word2 = EncoderUtil.encodeQ(prefix, part2, charset, bytes2);
        return word1 + " " + word2;
    }

    private static int qEncodedLength(byte[] bytes) {
        int count = 0;
        for (byte b : bytes) {
            int v = b & 0xFF;
            if (v == 32) {
                ++count;
                continue;
            }
            if (!Q_RESTRICTED_CHARS.get(v)) {
                count += 3;
                continue;
            }
            ++count;
        }
        return count;
    }

    private static byte[] encode(String text, Charset charset) {
        ByteBuffer buffer = charset.encode(text);
        byte[] bytes = new byte[buffer.limit()];
        buffer.get(bytes);
        return bytes;
    }

    private static Charset determineCharset(String text) {
        boolean ascii = true;
        int len = text.length();
        for (int index = 0; index < len; ++index) {
            char ch = text.charAt(index);
            if (ch > '\u00ff') {
                return CharsetUtil.UTF_8;
            }
            if (ch <= '\u007f') continue;
            ascii = false;
        }
        return ascii ? CharsetUtil.US_ASCII : CharsetUtil.ISO_8859_1;
    }

    private static Encoding determineEncoding(byte[] bytes) {
        if (bytes.length == 0) {
            return Encoding.Q;
        }
        int qEncoded = 0;
        for (int i = 0; i < bytes.length; ++i) {
            int v = bytes[i] & 0xFF;
            if (v == 32 || Q_RESTRICTED_CHARS.get(v)) continue;
            ++qEncoded;
        }
        int percentage = qEncoded * 100 / bytes.length;
        return percentage > 30 ? Encoding.B : Encoding.Q;
    }

    public static enum Encoding {
        B,
        Q;

    }
}

