/*
 * Decompiled with CFR 0.152.
 */
package com.fsck.k9.mail.filter;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;

public class FixedLengthInputStream
extends InputStream {
    private final InputStream mIn;
    private final int mLength;
    private int mCount = 0;

    public FixedLengthInputStream(InputStream in, int length) {
        this.mIn = in;
        this.mLength = length;
    }

    @Override
    public int available() throws IOException {
        return this.mLength - this.mCount;
    }

    @Override
    public int read() throws IOException {
        if (this.mCount >= this.mLength) {
            return -1;
        }
        int d = this.mIn.read();
        if (d != -1) {
            ++this.mCount;
        }
        return d;
    }

    @Override
    public int read(byte[] b, int offset, int length) throws IOException {
        if (this.mCount >= this.mLength) {
            return -1;
        }
        int d = this.mIn.read(b, offset, Math.min(this.mLength - this.mCount, length));
        if (d != -1) {
            this.mCount += d;
        }
        return d;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public long skip(long n) throws IOException {
        long d = this.mIn.skip(Math.min(n, (long)this.available()));
        if (d > 0L) {
            this.mCount = (int)((long)this.mCount + d);
        }
        return d;
    }

    public String toString() {
        return String.format(Locale.US, "FixedLengthInputStream(in=%s, length=%d)", this.mIn.toString(), this.mLength);
    }
}

