/*
 * Decompiled with CFR 0.152.
 */
package com.fsck.k9.mail.filter;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class EOLConvertingOutputStream
extends FilterOutputStream {
    private static final int CR = 13;
    private static final int LF = 10;
    private int lastByte;
    private boolean ignoreLf = false;

    public EOLConvertingOutputStream(OutputStream out) {
        super(out);
    }

    @Override
    public void write(int oneByte) throws IOException {
        if (oneByte == 10 && this.ignoreLf) {
            this.ignoreLf = false;
            return;
        }
        if (oneByte == 10 && this.lastByte != 13) {
            this.writeByte(13);
        } else if (oneByte != 10 && this.lastByte == 13) {
            this.writeByte(10);
        }
        this.writeByte(oneByte);
        this.ignoreLf = false;
    }

    @Override
    public void flush() throws IOException {
        this.completeCrLf();
        super.flush();
    }

    public void endWithCrLfAndFlush() throws IOException {
        this.completeCrLf();
        if (this.lastByte != 10) {
            this.writeByte(13);
            this.writeByte(10);
        }
        super.flush();
    }

    private void completeCrLf() throws IOException {
        if (this.lastByte == 13) {
            this.writeByte(10);
            this.ignoreLf = true;
        }
    }

    private void writeByte(int oneByte) throws IOException {
        super.write(oneByte);
        this.lastByte = oneByte;
    }
}

