/*
 * Decompiled with CFR 0.152.
 */
package com.fsck.k9.mail;

import com.fsck.k9.mail.CertificateChainException;
import com.fsck.k9.mail.MessagingException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLHandshakeException;

public class CertificateValidationException
extends MessagingException {
    public static final long serialVersionUID = -1L;
    private final Reason mReason;
    private X509Certificate[] mCertChain;
    private boolean mNeedsUserAttention = false;
    private String mAlias;

    public CertificateValidationException(String message) {
        this(message, Reason.UseMessage, null);
    }

    public CertificateValidationException(Reason reason) {
        this(null, reason, null);
    }

    public CertificateValidationException(String message, Reason reason, String alias) {
        super(message);
        this.mNeedsUserAttention = true;
        this.mReason = reason;
        this.mAlias = alias;
    }

    public CertificateValidationException(String message, Throwable throwable) {
        super(message, throwable);
        this.mReason = Reason.Unknown;
        this.scanForCause();
    }

    public String getAlias() {
        return this.mAlias;
    }

    public Reason getReason() {
        return this.mReason;
    }

    private void scanForCause() {
        Throwable throwable;
        for (throwable = this.getCause(); !(throwable == null || throwable instanceof CertPathValidatorException || throwable instanceof CertificateException || "android.security.KeyChainException".equals(throwable.getClass().getName()) || throwable instanceof SSLHandshakeException); throwable = throwable.getCause()) {
        }
        if (throwable != null) {
            this.mNeedsUserAttention = true;
            if (throwable instanceof SSLHandshakeException) {
                while (throwable != null && !(throwable instanceof CertificateChainException)) {
                    throwable = throwable.getCause();
                }
            }
            if (throwable != null && throwable instanceof CertificateChainException) {
                this.mCertChain = ((CertificateChainException)throwable).getCertChain();
            }
        }
    }

    public boolean needsUserAttention() {
        return this.mNeedsUserAttention;
    }

    public X509Certificate[] getCertChain() {
        return this.mCertChain;
    }

    public static enum Reason {
        Unknown,
        UseMessage,
        Expired,
        MissingCapability,
        RetrievalFailure;

    }
}

