/*
 * Decompiled with CFR 0.152.
 */
package com.fsck.k9.mail;

import android.text.TextUtils;
import android.text.util.Rfc822Token;
import android.text.util.Rfc822Tokenizer;
import android.util.Log;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.codec.EncoderUtil;
import org.apache.james.mime4j.dom.address.Mailbox;
import org.apache.james.mime4j.dom.address.MailboxList;
import org.apache.james.mime4j.field.address.AddressBuilder;

public class Address
implements Serializable {
    private static final Pattern ATOM = Pattern.compile("^(?:[a-zA-Z0-9!#$%&'*+\\-/=?^_`{|}~]|\\s)+$");
    private static final Address[] EMPTY_ADDRESS_ARRAY = new Address[0];
    private String mAddress;
    private String mPersonal;

    public Address(Address address) {
        this.mAddress = address.mAddress;
        this.mPersonal = address.mPersonal;
    }

    public Address(String address, String personal) {
        this(address, personal, true);
    }

    public Address(String address) {
        this(address, null, true);
    }

    public Address(String address, String personal, boolean parse) {
        if (parse) {
            Rfc822Token[] tokens = Rfc822Tokenizer.tokenize((CharSequence)address);
            if (tokens.length > 0) {
                Rfc822Token token = tokens[0];
                this.mAddress = token.getAddress();
                String name = token.getName();
                this.mPersonal = !TextUtils.isEmpty((CharSequence)name) ? name : (personal == null ? null : personal.trim());
            }
        } else {
            this.mAddress = address;
            this.mPersonal = personal;
        }
    }

    public String getAddress() {
        return this.mAddress;
    }

    public String getHostname() {
        int hostIdx = this.mAddress.lastIndexOf("@");
        if (hostIdx == -1) {
            return null;
        }
        return this.mAddress.substring(hostIdx + 1);
    }

    public void setAddress(String address) {
        this.mAddress = address;
    }

    public String getPersonal() {
        return this.mPersonal;
    }

    public void setPersonal(String personal) {
        if ("".equals(personal)) {
            personal = null;
        }
        if (personal != null) {
            personal = personal.trim();
        }
        this.mPersonal = personal;
    }

    public static Address[] parseUnencoded(String addressList) {
        ArrayList<Address> addresses = new ArrayList<Address>();
        if (!TextUtils.isEmpty((CharSequence)addressList)) {
            Rfc822Token[] tokens;
            for (Rfc822Token token : tokens = Rfc822Tokenizer.tokenize((CharSequence)addressList)) {
                String address = token.getAddress();
                if (TextUtils.isEmpty((CharSequence)address)) continue;
                addresses.add(new Address(token.getAddress(), token.getName(), false));
            }
        }
        return addresses.toArray(EMPTY_ADDRESS_ARRAY);
    }

    public static Address[] parse(String addressList) {
        if (TextUtils.isEmpty((CharSequence)addressList)) {
            return EMPTY_ADDRESS_ARRAY;
        }
        ArrayList<Address> addresses = new ArrayList<Address>();
        try {
            MailboxList parsedList = AddressBuilder.DEFAULT.parseAddressList(addressList).flatten();
            int count = parsedList.size();
            for (int i = 0; i < count; ++i) {
                Mailbox address = parsedList.get(i);
                if (address instanceof Mailbox) {
                    Mailbox mailbox = address;
                    addresses.add(new Address(mailbox.getLocalPart() + "@" + mailbox.getDomain(), mailbox.getName(), false));
                    continue;
                }
                Log.e((String)"k9", (String)("Unknown address type from Mime4J: " + address.getClass().toString()));
            }
        }
        catch (MimeException pe) {
            Log.e((String)"k9", (String)"MimeException in Address.parse()", (Throwable)pe);
            addresses.add(new Address(null, addressList, false));
        }
        return addresses.toArray(EMPTY_ADDRESS_ARRAY);
    }

    public boolean equals(Object o) {
        if (o instanceof Address) {
            Address other = (Address)o;
            if (this.mPersonal != null && other.mPersonal != null && !this.mPersonal.equals(other.mPersonal)) {
                return false;
            }
            return this.mAddress.equals(other.mAddress);
        }
        return super.equals(o);
    }

    public int hashCode() {
        int hash = this.mAddress.hashCode();
        if (this.mPersonal != null) {
            hash += 3 * this.mPersonal.hashCode();
        }
        return hash;
    }

    public String toString() {
        if (!TextUtils.isEmpty((CharSequence)this.mPersonal)) {
            return Address.quoteAtoms(this.mPersonal) + " <" + this.mAddress + ">";
        }
        return this.mAddress;
    }

    public static String toString(Address[] addresses) {
        if (addresses == null) {
            return null;
        }
        return TextUtils.join((CharSequence)", ", (Object[])addresses);
    }

    public String toEncodedString() {
        if (!TextUtils.isEmpty((CharSequence)this.mPersonal)) {
            return EncoderUtil.encodeAddressDisplayName((String)this.mPersonal) + " <" + this.mAddress + ">";
        }
        return this.mAddress;
    }

    public static String toEncodedString(Address[] addresses) {
        if (addresses == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < addresses.length; ++i) {
            sb.append(addresses[i].toEncodedString());
            if (i >= addresses.length - 1) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    public static Address[] unpack(String addressList) {
        if (addressList == null) {
            return new Address[0];
        }
        ArrayList<Address> addresses = new ArrayList<Address>();
        int length = addressList.length();
        int pairStartIndex = 0;
        int pairEndIndex = 0;
        int addressEndIndex = 0;
        while (pairStartIndex < length) {
            pairEndIndex = addressList.indexOf(",\u0000", pairStartIndex);
            if (pairEndIndex == -1) {
                pairEndIndex = length;
            }
            addressEndIndex = addressList.indexOf(";\u0000", pairStartIndex);
            String address = null;
            String personal = null;
            if (addressEndIndex == -1 || addressEndIndex > pairEndIndex) {
                address = addressList.substring(pairStartIndex, pairEndIndex);
            } else {
                address = addressList.substring(pairStartIndex, addressEndIndex);
                personal = addressList.substring(addressEndIndex + 2, pairEndIndex);
            }
            addresses.add(new Address(address, personal, false));
            pairStartIndex = pairEndIndex + 2;
        }
        return addresses.toArray(new Address[addresses.size()]);
    }

    public static String pack(Address[] addresses) {
        if (addresses == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int count = addresses.length;
        for (int i = 0; i < count; ++i) {
            Address address = addresses[i];
            sb.append(address.getAddress());
            String personal = address.getPersonal();
            if (personal != null) {
                sb.append(";\u0000");
                personal = personal.replaceAll("\"", "\\\"");
                sb.append(personal);
            }
            if (i >= count - 1) continue;
            sb.append(",\u0000");
        }
        return sb.toString();
    }

    public static String quoteAtoms(String text) {
        if (ATOM.matcher(text).matches()) {
            return text;
        }
        return Address.quoteString(text);
    }

    static String quoteString(String s) {
        if (s == null) {
            return null;
        }
        if (!s.matches("^\".*\"$")) {
            return "\"" + s + "\"";
        }
        return s;
    }
}

