/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.reflectionmodel;

import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedClassDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedConstructorDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedParameterDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionClassDeclaration;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionFactory;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionParameterDeclaration;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionTypeParameter;
import java.lang.reflect.Constructor;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ReflectionConstructorDeclaration
implements ResolvedConstructorDeclaration {
    private Constructor<?> constructor;
    private TypeSolver typeSolver;

    public ReflectionConstructorDeclaration(Constructor<?> constructor, TypeSolver typeSolver) {
        this.constructor = constructor;
        this.typeSolver = typeSolver;
    }

    public ResolvedClassDeclaration declaringType() {
        return new ReflectionClassDeclaration(this.constructor.getDeclaringClass(), this.typeSolver);
    }

    public int getNumberOfParams() {
        return this.constructor.getParameterCount();
    }

    public ResolvedParameterDeclaration getParam(int i) {
        if (i < 0 || i >= this.getNumberOfParams()) {
            throw new IllegalArgumentException(String.format("No param with index %d. Number of params: %d", i, this.getNumberOfParams()));
        }
        boolean variadic = false;
        if (this.constructor.isVarArgs()) {
            variadic = i == this.constructor.getParameterCount() - 1;
        }
        return new ReflectionParameterDeclaration(this.constructor.getParameterTypes()[i], this.constructor.getGenericParameterTypes()[i], this.typeSolver, variadic, this.constructor.getParameters()[i].getName());
    }

    public String getName() {
        return this.constructor.getDeclaringClass().getSimpleName();
    }

    public Modifier.Keyword accessSpecifier() {
        return ReflectionFactory.modifiersToAccessLevel(this.constructor.getModifiers());
    }

    public List<ResolvedTypeParameterDeclaration> getTypeParameters() {
        return Arrays.stream(this.constructor.getTypeParameters()).map(refTp -> new ReflectionTypeParameter((TypeVariable)refTp, false, this.typeSolver)).collect(Collectors.toList());
    }

    public int getNumberOfSpecifiedExceptions() {
        return this.constructor.getExceptionTypes().length;
    }

    public ResolvedType getSpecifiedException(int index) {
        if (index < 0 || index >= this.getNumberOfSpecifiedExceptions()) {
            throw new IllegalArgumentException();
        }
        return ReflectionFactory.typeUsageFor(this.constructor.getExceptionTypes()[index], this.typeSolver);
    }

    public Optional<ConstructorDeclaration> toAst() {
        return Optional.empty();
    }
}

