/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.javaparsermodel.declarations;

import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.type.TypeParameter;
import com.github.javaparser.resolution.declarations.ResolvedConstructorDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedParameterDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFacade;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserParameterDeclaration;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserTypeParameter;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class JavaParserConstructorDeclaration<N extends ResolvedReferenceTypeDeclaration>
implements ResolvedConstructorDeclaration {
    private N declaringType;
    private ConstructorDeclaration wrappedNode;
    private TypeSolver typeSolver;

    JavaParserConstructorDeclaration(N declaringType, ConstructorDeclaration wrappedNode, TypeSolver typeSolver) {
        this.declaringType = declaringType;
        this.wrappedNode = wrappedNode;
        this.typeSolver = typeSolver;
    }

    public N declaringType() {
        return this.declaringType;
    }

    public int getNumberOfParams() {
        return this.wrappedNode.getParameters().size();
    }

    public ResolvedParameterDeclaration getParam(int i) {
        if (i < 0 || i >= this.getNumberOfParams()) {
            throw new IllegalArgumentException(String.format("No param with index %d. Number of params: %d", i, this.getNumberOfParams()));
        }
        return new JavaParserParameterDeclaration((Parameter)this.wrappedNode.getParameters().get(i), this.typeSolver);
    }

    public String getName() {
        return this.declaringType.getName();
    }

    public ConstructorDeclaration getWrappedNode() {
        return this.wrappedNode;
    }

    public Modifier.Keyword accessSpecifier() {
        return this.wrappedNode.getAccessSpecifier();
    }

    public List<ResolvedTypeParameterDeclaration> getTypeParameters() {
        return this.wrappedNode.getTypeParameters().stream().map(astTp -> new JavaParserTypeParameter((TypeParameter)astTp, this.typeSolver)).collect(Collectors.toList());
    }

    public int getNumberOfSpecifiedExceptions() {
        return this.wrappedNode.getThrownExceptions().size();
    }

    public ResolvedType getSpecifiedException(int index) {
        if (index < 0 || index >= this.getNumberOfSpecifiedExceptions()) {
            throw new IllegalArgumentException(String.format("No exception with index %d. Number of exceptions: %d", index, this.getNumberOfSpecifiedExceptions()));
        }
        return JavaParserFacade.get(this.typeSolver).convert((Type)this.wrappedNode.getThrownExceptions().get(index), (Node)this.wrappedNode);
    }

    public Optional<ConstructorDeclaration> toAst() {
        return Optional.of(this.wrappedNode);
    }
}

