/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.reflectionmodel;

import com.github.javaparser.ast.AccessSpecifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.resolution.MethodUsage;
import com.github.javaparser.resolution.declarations.ResolvedConstructorDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedFieldDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedInterfaceDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedValueDeclaration;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.core.resolution.Context;
import com.github.javaparser.symbolsolver.core.resolution.MethodUsageResolutionCapability;
import com.github.javaparser.symbolsolver.javaparsermodel.LambdaArgumentTypePlaceholder;
import com.github.javaparser.symbolsolver.logic.AbstractTypeDeclaration;
import com.github.javaparser.symbolsolver.logic.ConfilictingGenericTypesException;
import com.github.javaparser.symbolsolver.logic.InferenceContext;
import com.github.javaparser.symbolsolver.logic.MethodResolutionCapability;
import com.github.javaparser.symbolsolver.logic.ObjectProvider;
import com.github.javaparser.symbolsolver.model.resolution.SymbolReference;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import com.github.javaparser.symbolsolver.model.typesystem.NullType;
import com.github.javaparser.symbolsolver.model.typesystem.ReferenceTypeImpl;
import com.github.javaparser.symbolsolver.reflectionmodel.MyObjectProvider;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionClassAdapter;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionFactory;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionFieldDeclaration;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionMethodResolutionLogic;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class ReflectionInterfaceDeclaration
extends AbstractTypeDeclaration
implements ResolvedInterfaceDeclaration,
MethodResolutionCapability,
MethodUsageResolutionCapability {
    private Class<?> clazz;
    private TypeSolver typeSolver;
    private ReflectionClassAdapter reflectionClassAdapter;

    public ReflectionInterfaceDeclaration(Class<?> clazz, TypeSolver typeSolver) {
        if (!clazz.isInterface()) {
            throw new IllegalArgumentException();
        }
        this.clazz = clazz;
        this.typeSolver = typeSolver;
        this.reflectionClassAdapter = new ReflectionClassAdapter(clazz, typeSolver, (ResolvedReferenceTypeDeclaration)this);
    }

    public boolean isAssignableBy(ResolvedReferenceTypeDeclaration other) {
        return this.isAssignableBy((ResolvedType)new ReferenceTypeImpl(other, this.typeSolver));
    }

    public String getPackageName() {
        if (this.clazz.getPackage() != null) {
            return this.clazz.getPackage().getName();
        }
        return null;
    }

    public String getClassName() {
        String canonicalName = this.clazz.getCanonicalName();
        if (canonicalName != null && this.getPackageName() != null) {
            return canonicalName.substring(this.getPackageName().length() + 1, canonicalName.length());
        }
        return null;
    }

    public String getQualifiedName() {
        return this.clazz.getCanonicalName();
    }

    @Deprecated
    public SymbolReference<ResolvedMethodDeclaration> solveMethod(String name, List<ResolvedType> parameterTypes, boolean staticOnly) {
        return ReflectionMethodResolutionLogic.solveMethod(name, parameterTypes, staticOnly, this.typeSolver, (ResolvedReferenceTypeDeclaration)this, this.clazz);
    }

    public String toString() {
        return "ReflectionInterfaceDeclaration{clazz=" + this.clazz.getCanonicalName() + '}';
    }

    public ResolvedType getUsage(Node node) {
        return new ReferenceTypeImpl((ResolvedReferenceTypeDeclaration)this, this.typeSolver);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReflectionInterfaceDeclaration)) {
            return false;
        }
        ReflectionInterfaceDeclaration that = (ReflectionInterfaceDeclaration)o;
        if (!this.clazz.getCanonicalName().equals(that.clazz.getCanonicalName())) {
            return false;
        }
        return this.getTypeParameters().equals(that.getTypeParameters());
    }

    public int hashCode() {
        return this.clazz.hashCode();
    }

    @Override
    public Optional<MethodUsage> solveMethodAsUsage(String name, List<ResolvedType> parameterTypes, Context invokationContext, List<ResolvedType> typeParameterValues) {
        Optional<MethodUsage> res = ReflectionMethodResolutionLogic.solveMethodAsUsage(name, parameterTypes, this.typeSolver, invokationContext, typeParameterValues, (ResolvedReferenceTypeDeclaration)this, this.clazz);
        if (res.isPresent()) {
            InferenceContext inferenceContext = new InferenceContext((ObjectProvider)MyObjectProvider.INSTANCE);
            MethodUsage methodUsage = res.get();
            int i = 0;
            LinkedList<ResolvedType> parameters = new LinkedList<ResolvedType>();
            for (ResolvedType actualType : parameterTypes) {
                ResolvedType formalType = methodUsage.getParamType(i);
                parameters.add(inferenceContext.addPair(formalType, actualType));
                ++i;
            }
            try {
                ResolvedType returnType = inferenceContext.addSingle(methodUsage.returnType());
                for (int j = 0; j < parameters.size(); ++j) {
                    methodUsage = methodUsage.replaceParamType(j, inferenceContext.resolve((ResolvedType)parameters.get(j)));
                }
                methodUsage = methodUsage.replaceReturnType(inferenceContext.resolve(returnType));
                return Optional.of(methodUsage);
            }
            catch (ConfilictingGenericTypesException e) {
                return Optional.empty();
            }
        }
        return res;
    }

    public boolean canBeAssignedTo(ResolvedReferenceTypeDeclaration other) {
        if (other instanceof LambdaArgumentTypePlaceholder) {
            return this.isFunctionalInterface();
        }
        if (other.getQualifiedName().equals(this.getQualifiedName())) {
            return true;
        }
        if (this.clazz.getSuperclass() != null && new ReflectionInterfaceDeclaration(this.clazz.getSuperclass(), this.typeSolver).canBeAssignedTo(other)) {
            return true;
        }
        for (Class<?> interfaze : this.clazz.getInterfaces()) {
            if (!new ReflectionInterfaceDeclaration(interfaze, this.typeSolver).canBeAssignedTo(other)) continue;
            return true;
        }
        return other.getQualifiedName().equals(Object.class.getCanonicalName());
    }

    public boolean isAssignableBy(ResolvedType type) {
        if (type instanceof NullType) {
            return true;
        }
        if (type instanceof LambdaArgumentTypePlaceholder) {
            return this.isFunctionalInterface();
        }
        if (type.isArray()) {
            return false;
        }
        if (type.isPrimitive()) {
            return false;
        }
        if (type.describe().equals(this.getQualifiedName())) {
            return true;
        }
        if (type instanceof ReferenceTypeImpl) {
            ReferenceTypeImpl otherTypeDeclaration = (ReferenceTypeImpl)type;
            return otherTypeDeclaration.getTypeDeclaration().canBeAssignedTo((ResolvedReferenceTypeDeclaration)this);
        }
        return false;
    }

    public boolean isTypeParameter() {
        return false;
    }

    public ResolvedFieldDeclaration getField(String name) {
        return this.reflectionClassAdapter.getField(name);
    }

    public List<ResolvedFieldDeclaration> getAllFields() {
        return this.reflectionClassAdapter.getAllFields();
    }

    @Deprecated
    public SymbolReference<? extends ResolvedValueDeclaration> solveSymbol(String name, TypeSolver typeSolver) {
        for (Field field : this.clazz.getFields()) {
            if (!field.getName().equals(name)) continue;
            return SymbolReference.solved((ResolvedDeclaration)new ReflectionFieldDeclaration(field, typeSolver));
        }
        return SymbolReference.unsolved(ResolvedValueDeclaration.class);
    }

    public List<ResolvedReferenceType> getAncestors(boolean acceptIncompleteList) {
        return this.reflectionClassAdapter.getAncestors();
    }

    public Set<ResolvedMethodDeclaration> getDeclaredMethods() {
        return this.reflectionClassAdapter.getDeclaredMethods();
    }

    public boolean hasField(String name) {
        return this.reflectionClassAdapter.hasField(name);
    }

    public String getName() {
        return this.clazz.getSimpleName();
    }

    public boolean isInterface() {
        return true;
    }

    public List<ResolvedReferenceType> getInterfacesExtended() {
        ArrayList<ResolvedReferenceType> res = new ArrayList<ResolvedReferenceType>();
        for (Class<?> i : this.clazz.getInterfaces()) {
            res.add(new ReferenceTypeImpl((ResolvedReferenceTypeDeclaration)new ReflectionInterfaceDeclaration(i, this.typeSolver), this.typeSolver));
        }
        return res;
    }

    public Optional<ResolvedReferenceTypeDeclaration> containerType() {
        return this.reflectionClassAdapter.containerType();
    }

    public Set<ResolvedReferenceTypeDeclaration> internalTypes() {
        return Arrays.stream(this.clazz.getDeclaredClasses()).map(ic -> ReflectionFactory.typeDeclarationFor(ic, this.typeSolver)).collect(Collectors.toSet());
    }

    public ResolvedInterfaceDeclaration asInterface() {
        return this;
    }

    public boolean hasDirectlyAnnotation(String canonicalName) {
        return this.reflectionClassAdapter.hasDirectlyAnnotation(canonicalName);
    }

    public List<ResolvedTypeParameterDeclaration> getTypeParameters() {
        return this.reflectionClassAdapter.getTypeParameters();
    }

    public AccessSpecifier accessSpecifier() {
        return ReflectionFactory.modifiersToAccessLevel(this.clazz.getModifiers());
    }

    public List<ResolvedConstructorDeclaration> getConstructors() {
        return Collections.emptyList();
    }

    public Optional<ClassOrInterfaceDeclaration> toAst() {
        return Optional.empty();
    }
}

