/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.javaparsermodel.declarations;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.nodeTypes.NodeWithMembers;
import com.github.javaparser.ast.nodeTypes.NodeWithSimpleName;
import com.github.javaparser.ast.nodeTypes.NodeWithTypeParameters;
import com.github.javaparser.ast.type.TypeParameter;
import com.github.javaparser.resolution.declarations.ResolvedDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedFieldDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeDeclaration;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.javaparser.Navigator;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFactory;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.AstResolutionUtils;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserClassDeclaration;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserEnumDeclaration;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserFieldDeclaration;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserInterfaceDeclaration;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserTypeVariableDeclaration;
import com.github.javaparser.symbolsolver.model.resolution.SymbolReference;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import com.github.javaparser.symbolsolver.model.typesystem.ReferenceTypeImpl;
import com.github.javaparser.symbolsolver.resolution.SymbolSolver;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class JavaParserTypeAdapter<T extends Node & NodeWithMembers<T>> {
    private T wrappedNode;
    private TypeSolver typeSolver;

    public JavaParserTypeAdapter(T wrappedNode, TypeSolver typeSolver) {
        this.wrappedNode = wrappedNode;
        this.typeSolver = typeSolver;
    }

    public String getPackageName() {
        return AstResolutionUtils.getPackageName(this.wrappedNode);
    }

    public String getClassName() {
        return AstResolutionUtils.getClassName("", this.wrappedNode);
    }

    public String getQualifiedName() {
        String containerName = AstResolutionUtils.containerName(Navigator.getParentNode(this.wrappedNode));
        if (containerName.isEmpty()) {
            return ((NodeWithSimpleName)this.wrappedNode).getName().getId();
        }
        return containerName + "." + ((NodeWithSimpleName)this.wrappedNode).getName().getId();
    }

    public boolean isAssignableBy(ResolvedReferenceTypeDeclaration other) {
        List ancestorsOfOther = other.getAllAncestors();
        ancestorsOfOther.add(new ReferenceTypeImpl(other, this.typeSolver));
        for (ResolvedReferenceType ancestorOfOther : ancestorsOfOther) {
            if (!ancestorOfOther.getQualifiedName().equals(this.getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    public boolean isAssignableBy(ResolvedType type) {
        if (type.isNull()) {
            return true;
        }
        if (type.isReferenceType()) {
            ResolvedReferenceTypeDeclaration other = this.typeSolver.solveType(type.describe());
            return this.isAssignableBy(other);
        }
        throw new UnsupportedOperationException();
    }

    public SymbolReference<ResolvedTypeDeclaration> solveType(String name, TypeSolver typeSolver) {
        if (this.wrappedNode instanceof NodeWithTypeParameters) {
            NodeList typeParameters = ((NodeWithTypeParameters)this.wrappedNode).getTypeParameters();
            for (TypeParameter typeParameter : typeParameters) {
                if (!typeParameter.getName().getId().equals(name)) continue;
                return SymbolReference.solved((ResolvedDeclaration)new JavaParserTypeVariableDeclaration(typeParameter, typeSolver));
            }
        }
        for (BodyDeclaration member : ((NodeWithMembers)this.wrappedNode).getMembers()) {
            if (!(member instanceof TypeDeclaration)) continue;
            TypeDeclaration internalType = (TypeDeclaration)member;
            String prefix = internalType.getName() + ".";
            if (internalType.getName().getId().equals(name)) {
                if (internalType instanceof ClassOrInterfaceDeclaration) {
                    if (((ClassOrInterfaceDeclaration)internalType).isInterface()) {
                        return SymbolReference.solved((ResolvedDeclaration)new JavaParserInterfaceDeclaration((ClassOrInterfaceDeclaration)internalType, typeSolver));
                    }
                    return SymbolReference.solved((ResolvedDeclaration)new JavaParserClassDeclaration((ClassOrInterfaceDeclaration)internalType, typeSolver));
                }
                if (internalType instanceof EnumDeclaration) {
                    return SymbolReference.solved((ResolvedDeclaration)new JavaParserEnumDeclaration((EnumDeclaration)internalType, typeSolver));
                }
                throw new UnsupportedOperationException();
            }
            if (!name.startsWith(prefix) || name.length() <= prefix.length()) continue;
            if (internalType instanceof ClassOrInterfaceDeclaration) {
                if (((ClassOrInterfaceDeclaration)internalType).isInterface()) {
                    return new JavaParserInterfaceDeclaration((ClassOrInterfaceDeclaration)internalType, typeSolver).solveType(name.substring(prefix.length()), typeSolver);
                }
                return new JavaParserClassDeclaration((ClassOrInterfaceDeclaration)internalType, typeSolver).solveType(name.substring(prefix.length()), typeSolver);
            }
            if (internalType instanceof EnumDeclaration) {
                return new SymbolSolver(typeSolver).solveTypeInType((ResolvedTypeDeclaration)new JavaParserEnumDeclaration((EnumDeclaration)internalType, typeSolver), name.substring(prefix.length()));
            }
            throw new UnsupportedOperationException();
        }
        return SymbolReference.unsolved(ResolvedTypeDeclaration.class);
    }

    public Optional<ResolvedReferenceTypeDeclaration> containerType() {
        return this.wrappedNode.getParentNode().map(node -> JavaParserFactory.toTypeDeclaration(node, this.typeSolver));
    }

    public List<ResolvedFieldDeclaration> getFieldsForDeclaredVariables() {
        ArrayList<ResolvedFieldDeclaration> fields = new ArrayList<ResolvedFieldDeclaration>();
        if (((NodeWithMembers)this.wrappedNode).getMembers() != null) {
            for (BodyDeclaration member : ((NodeWithMembers)this.wrappedNode).getMembers()) {
                if (!(member instanceof FieldDeclaration)) continue;
                FieldDeclaration field = (FieldDeclaration)member;
                for (VariableDeclarator vd : field.getVariables()) {
                    fields.add(new JavaParserFieldDeclaration(vd, this.typeSolver));
                }
            }
        }
        return fields;
    }
}

