/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.javaparsermodel.declarations;

import com.github.javaparser.ast.AccessSpecifier;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.symbolsolver.javaparser.Navigator;
import java.util.EnumSet;
import java.util.Optional;

class Helper {
    Helper() {
    }

    public static AccessSpecifier toAccessLevel(EnumSet<Modifier> modifiers) {
        if (modifiers.contains(Modifier.PRIVATE)) {
            return AccessSpecifier.PRIVATE;
        }
        if (modifiers.contains(Modifier.PROTECTED)) {
            return AccessSpecifier.PROTECTED;
        }
        if (modifiers.contains(Modifier.PUBLIC)) {
            return AccessSpecifier.PUBLIC;
        }
        return AccessSpecifier.DEFAULT;
    }

    static String containerName(Node container) {
        String packageName = Helper.getPackageName(container);
        String className = Helper.getClassName("", container);
        return packageName + (!packageName.isEmpty() && !className.isEmpty() ? "." : "") + className;
    }

    static String getPackageName(Node container) {
        if (container instanceof CompilationUnit) {
            Optional p = ((CompilationUnit)container).getPackageDeclaration();
            if (p.isPresent()) {
                return ((PackageDeclaration)p.get()).getName().toString();
            }
        } else if (container != null) {
            return Helper.getPackageName(Navigator.getParentNode(container));
        }
        return "";
    }

    static String getClassName(String base, Node container) {
        if (container instanceof ClassOrInterfaceDeclaration) {
            String b = Helper.getClassName(base, Navigator.getParentNode(container));
            String cn = ((ClassOrInterfaceDeclaration)container).getName().getId();
            if (b.isEmpty()) {
                return cn;
            }
            return b + "." + cn;
        }
        if (container instanceof EnumDeclaration) {
            String b = Helper.getClassName(base, Navigator.getParentNode(container));
            String cn = ((EnumDeclaration)container).getName().getId();
            if (b.isEmpty()) {
                return cn;
            }
            return b + "." + cn;
        }
        if (container != null) {
            return Helper.getClassName(base, Navigator.getParentNode(container));
        }
        return base;
    }
}

