/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseException;
import com.github.javaparser.Position;
import com.github.javaparser.Range;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.javaparser.Navigator;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFacade;
import com.github.javaparser.symbolsolver.model.resolution.SymbolReference;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.List;

public class SourceFileInfoExtractor {
    private TypeSolver typeSolver;
    private int ok = 0;
    private int ko = 0;
    private int unsupported = 0;
    private boolean printFileName = true;
    private PrintStream out = System.out;
    private PrintStream err = System.err;
    private boolean verbose = false;

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setPrintFileName(boolean printFileName) {
        this.printFileName = printFileName;
    }

    public void clear() {
        this.ok = 0;
        this.ko = 0;
        this.unsupported = 0;
    }

    public void setOut(PrintStream out) {
        this.out = out;
    }

    public void setErr(PrintStream err) {
        this.err = err;
    }

    public int getOk() {
        return this.ok;
    }

    public int getUnsupported() {
        return this.unsupported;
    }

    public int getKo() {
        return this.ko;
    }

    private void solveTypeDecl(ClassOrInterfaceDeclaration node) {
        ResolvedReferenceTypeDeclaration typeDeclaration = JavaParserFacade.get(this.typeSolver).getTypeDeclaration(node);
        if (typeDeclaration.isClass()) {
            this.out.println("\n[ Class " + typeDeclaration.getQualifiedName() + " ]");
            for (ResolvedReferenceType sc : typeDeclaration.asClass().getAllSuperClasses()) {
                this.out.println("  superclass: " + sc.getQualifiedName());
            }
            for (ResolvedReferenceType sc : typeDeclaration.asClass().getAllInterfaces()) {
                this.out.println("  interface: " + sc.getQualifiedName());
            }
        }
    }

    private void solve(Node node) {
        if (node instanceof ClassOrInterfaceDeclaration) {
            this.solveTypeDecl((ClassOrInterfaceDeclaration)node);
        } else if (!(!(node instanceof Expression) || Navigator.getParentNode(node) instanceof ImportDeclaration || Navigator.getParentNode(node) instanceof Expression || Navigator.getParentNode(node) instanceof MethodDeclaration || Navigator.getParentNode(node) instanceof PackageDeclaration || !(Navigator.getParentNode(node) instanceof Statement) && !(Navigator.getParentNode(node) instanceof VariableDeclarator))) {
            try {
                ResolvedType ref = JavaParserFacade.get(this.typeSolver).getType(node);
                this.out.println("  Line " + ((Range)node.getRange().get()).begin.line + ") " + node + " ==> " + ref.describe());
                ++this.ok;
            }
            catch (UnsupportedOperationException upe) {
                ++this.unsupported;
                this.err.println(upe.getMessage());
                throw upe;
            }
            catch (RuntimeException re) {
                ++this.ko;
                this.err.println(re.getMessage());
                throw re;
            }
        }
    }

    private void solveMethodCalls(Node node) {
        if (node instanceof MethodCallExpr) {
            this.out.println("  Line " + ((Position)node.getBegin().get()).line + ") " + node + " ==> " + this.toString((MethodCallExpr)node));
        }
        for (Node child : node.getChildNodes()) {
            this.solveMethodCalls(child);
        }
    }

    private String toString(MethodCallExpr node) {
        try {
            return this.toString(JavaParserFacade.get(this.typeSolver).solve(node));
        }
        catch (Exception e) {
            if (this.verbose) {
                System.err.println("Error resolving call at L" + ((Position)node.getBegin().get()).line + ": " + node);
                e.printStackTrace();
            }
            return "ERROR";
        }
    }

    private String toString(SymbolReference<ResolvedMethodDeclaration> methodDeclarationSymbolReference) {
        if (methodDeclarationSymbolReference.isSolved()) {
            return ((ResolvedMethodDeclaration)methodDeclarationSymbolReference.getCorrespondingDeclaration()).getQualifiedSignature();
        }
        return "UNSOLVED";
    }

    private List<Node> collectAllNodes(Node node) {
        LinkedList<Node> nodes = new LinkedList<Node>();
        this.collectAllNodes(node, nodes);
        nodes.sort((n1, n2) -> ((Position)n1.getBegin().get()).compareTo((Position)n2.getBegin().get()));
        return nodes;
    }

    private void collectAllNodes(Node node, List<Node> nodes) {
        nodes.add(node);
        node.getChildNodes().forEach(c -> this.collectAllNodes((Node)c, nodes));
    }

    public void solve(File file) throws IOException, ParseException {
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                this.solve(f);
            }
        } else if (file.getName().endsWith(".java")) {
            if (this.printFileName) {
                this.out.println("- parsing " + file.getAbsolutePath());
            }
            CompilationUnit cu = JavaParser.parse((File)file);
            List<Node> nodes = this.collectAllNodes((Node)cu);
            nodes.forEach(n -> this.solve((Node)n));
        }
    }

    public void solveMethodCalls(File file) throws IOException, ParseException {
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                this.solveMethodCalls(f);
            }
        } else if (file.getName().endsWith(".java")) {
            if (this.printFileName) {
                this.out.println("- parsing " + file.getAbsolutePath());
            }
            CompilationUnit cu = JavaParser.parse((File)file);
            this.solveMethodCalls((Node)cu);
        }
    }

    public void setTypeSolver(TypeSolver typeSolver) {
        this.typeSolver = typeSolver;
    }
}

