/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.javaparser;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.SwitchStmt;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public final class Navigator {
    private Navigator() {
    }

    public static Node getParentNode(Node node) {
        Node parent = node.getParentNode().orElse(null);
        return parent;
    }

    public static Node requireParentNode(Node node) {
        Node parent = Navigator.getParentNode(node);
        if (parent == null) {
            throw new IllegalStateException("Parent not found, the node does not appear to be inserted in a correct AST");
        }
        return parent;
    }

    public static Optional<TypeDeclaration<?>> findType(CompilationUnit cu, String qualifiedName) {
        if (cu.getTypes().isEmpty()) {
            return Optional.empty();
        }
        String typeName = Navigator.getOuterTypeName(qualifiedName);
        Optional<TypeDeclaration<?>> type = cu.getTypes().stream().filter(t -> t.getName().getId().equals(typeName)).findFirst();
        String innerTypeName = Navigator.getInnerTypeName(qualifiedName);
        if (type.isPresent() && !innerTypeName.isEmpty()) {
            return Navigator.findType(type.get(), innerTypeName);
        }
        return type;
    }

    public static Optional<TypeDeclaration<?>> findType(TypeDeclaration<?> td, String qualifiedName) {
        String typeName = Navigator.getOuterTypeName(qualifiedName);
        Optional<TypeDeclaration<?>> type = Optional.empty();
        for (Node n : td.getMembers()) {
            if (!(n instanceof TypeDeclaration) || !((TypeDeclaration)n).getName().getId().equals(typeName)) continue;
            type = Optional.of((TypeDeclaration)n);
            break;
        }
        String innerTypeName = Navigator.getInnerTypeName(qualifiedName);
        if (type.isPresent() && !innerTypeName.isEmpty()) {
            return Navigator.findType(type.get(), innerTypeName);
        }
        return type;
    }

    public static ClassOrInterfaceDeclaration demandClass(CompilationUnit cu, String qualifiedName) {
        ClassOrInterfaceDeclaration cd = Navigator.demandClassOrInterface(cu, qualifiedName);
        if (cd.isInterface()) {
            throw new IllegalStateException("Type is not a class");
        }
        return cd;
    }

    public static EnumDeclaration demandEnum(CompilationUnit cu, String qualifiedName) {
        Optional<TypeDeclaration<?>> res = Navigator.findType(cu, qualifiedName);
        if (!res.isPresent()) {
            throw new IllegalStateException("No type found");
        }
        if (!(res.get() instanceof EnumDeclaration)) {
            throw new IllegalStateException("Type is not an enum");
        }
        return (EnumDeclaration)res.get();
    }

    public static MethodDeclaration demandMethod(TypeDeclaration<?> cd, String name) {
        MethodDeclaration found = null;
        for (BodyDeclaration bd : cd.getMembers()) {
            MethodDeclaration md;
            if (!(bd instanceof MethodDeclaration) || !(md = (MethodDeclaration)bd).getName().getId().equals(name)) continue;
            if (found != null) {
                throw new IllegalStateException("Ambiguous getName");
            }
            found = md;
        }
        if (found == null) {
            throw new IllegalStateException("No method with given name");
        }
        return found;
    }

    public static VariableDeclarator demandField(ClassOrInterfaceDeclaration cd, String name) {
        for (BodyDeclaration bd : cd.getMembers()) {
            if (!(bd instanceof FieldDeclaration)) continue;
            FieldDeclaration fd = (FieldDeclaration)bd;
            for (VariableDeclarator vd : fd.getVariables()) {
                if (!vd.getName().getId().equals(name)) continue;
                return vd;
            }
        }
        throw new IllegalStateException("No field with given name");
    }

    public static NameExpr findNameExpression(Node node, String name) {
        NameExpr nameExpr;
        if (node instanceof NameExpr && (nameExpr = (NameExpr)node).getName() != null && nameExpr.getName().getId().equals(name)) {
            return nameExpr;
        }
        for (Node child : node.getChildNodes()) {
            NameExpr res = Navigator.findNameExpression(child, name);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public static SimpleName findSimpleName(Node node, String name) {
        SimpleName nameExpr;
        if (node instanceof SimpleName && (nameExpr = (SimpleName)node).getId() != null && nameExpr.getId().equals(name)) {
            return nameExpr;
        }
        for (Node child : node.getChildNodes()) {
            SimpleName res = Navigator.findSimpleName(child, name);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public static MethodCallExpr findMethodCall(Node node, String methodName) {
        MethodCallExpr methodCallExpr;
        if (node instanceof MethodCallExpr && (methodCallExpr = (MethodCallExpr)node).getName().getId().equals(methodName)) {
            return methodCallExpr;
        }
        for (Node child : node.getChildNodes()) {
            MethodCallExpr res = Navigator.findMethodCall(child, methodName);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public static VariableDeclarator demandVariableDeclaration(Node node, String name) {
        VariableDeclarator variableDeclarator;
        if (node instanceof VariableDeclarator && (variableDeclarator = (VariableDeclarator)node).getName().getId().equals(name)) {
            return variableDeclarator;
        }
        for (Node child : node.getChildNodes()) {
            VariableDeclarator res = Navigator.demandVariableDeclaration(child, name);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public static ClassOrInterfaceDeclaration demandClassOrInterface(CompilationUnit compilationUnit, String qualifiedName) {
        Optional<TypeDeclaration<?>> res = Navigator.findType(compilationUnit, qualifiedName);
        if (!res.isPresent()) {
            throw new IllegalStateException("No type named '" + qualifiedName + "'found");
        }
        if (!(res.get() instanceof ClassOrInterfaceDeclaration)) {
            throw new IllegalStateException("Type is not a class or an interface, it is " + res.get().getClass().getCanonicalName());
        }
        ClassOrInterfaceDeclaration cd = (ClassOrInterfaceDeclaration)res.get();
        return cd;
    }

    public static SwitchStmt findSwitch(Node node) {
        SwitchStmt res = Navigator.findSwitchHelper(node);
        if (res == null) {
            throw new IllegalArgumentException();
        }
        return res;
    }

    @Deprecated
    public static <N> N findNodeOfGivenClass(Node node, Class<N> clazz) {
        N res = Navigator.findNodeOfGivenClassHelper(node, clazz);
        if (res == null) {
            throw new IllegalArgumentException();
        }
        return res;
    }

    @Deprecated
    public static <N> List<N> findAllNodesOfGivenClass(Node node, Class<N> clazz) {
        LinkedList res = new LinkedList();
        Navigator.findAllNodesOfGivenClassHelper(node, clazz, res);
        return res;
    }

    public static ReturnStmt findReturnStmt(MethodDeclaration method) {
        return Navigator.findNodeOfGivenClass((Node)method, ReturnStmt.class);
    }

    public static <N extends Node> Optional<N> findAncestor(Node node, Class<N> clazz) {
        if (!node.getParentNode().isPresent()) {
            return Optional.empty();
        }
        if (clazz.isInstance(node.getParentNode().get())) {
            return Optional.of(clazz.cast(node.getParentNode().get()));
        }
        return Navigator.findAncestor((Node)node.getParentNode().get(), clazz);
    }

    private static String getOuterTypeName(String qualifiedName) {
        return qualifiedName.split("\\.", 2)[0];
    }

    private static String getInnerTypeName(String qualifiedName) {
        if (qualifiedName.contains(".")) {
            return qualifiedName.split("\\.", 2)[1];
        }
        return "";
    }

    private static SwitchStmt findSwitchHelper(Node node) {
        if (node instanceof SwitchStmt) {
            return (SwitchStmt)node;
        }
        for (Node child : node.getChildNodes()) {
            SwitchStmt resChild = Navigator.findSwitchHelper(child);
            if (resChild == null) continue;
            return resChild;
        }
        return null;
    }

    private static <N> N findNodeOfGivenClassHelper(Node node, Class<N> clazz) {
        if (clazz.isInstance(node)) {
            return clazz.cast(node);
        }
        for (Node child : node.getChildNodes()) {
            N resChild = Navigator.findNodeOfGivenClassHelper(child, clazz);
            if (resChild == null) continue;
            return resChild;
        }
        return null;
    }

    private static <N> void findAllNodesOfGivenClassHelper(Node node, Class<N> clazz, List<N> collector) {
        if (clazz.isInstance(node)) {
            collector.add(clazz.cast(node));
        }
        for (Node child : node.getChildNodes()) {
            Navigator.findAllNodesOfGivenClassHelper(child, clazz, collector);
        }
    }
}

