/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.utils;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;

public class ModuleLayerHelper {
    public static HashMap<String, Set<String>> getModulePackagesFromLayers(Iterable<Object> moduleLayers) {
        HashMap<String, Set<String>> modulePackages = new HashMap<String, Set<String>>();
        for (Object moduleLayer : moduleLayers) {
            if (!moduleLayer.getClass().getCanonicalName().equals("java.lang.ModuleLayer")) {
                throw new IllegalArgumentException("getModuleExportedPackagesFromLayer must be called with a ModuleLayer argument but was called with " + moduleLayer.getClass().getCanonicalName());
            }
            try {
                Set modulesSet = (Set)moduleLayer.getClass().getMethod("modules", new Class[0]).invoke(moduleLayer, new Object[0]);
                for (Object module : modulesSet) {
                    String name = module.getClass().getMethod("getName", new Class[0]).invoke(module, new Object[0]).toString();
                    Set packages = (Set)module.getClass().getMethod("getPackages", new Class[0]).invoke(module, new Object[0]);
                    if (modulePackages.containsKey(name)) {
                        modulePackages.get(name).addAll(packages);
                        continue;
                    }
                    modulePackages.put(name, packages);
                }
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            }
        }
        return modulePackages;
    }

    public static Optional<Object> getBootModuleLayer() {
        try {
            Class<?> moduleLayerClass = Class.forName("java.lang.ModuleLayer");
            Object bootModuleLayer = moduleLayerClass.getDeclaredMethod("boot", new Class[0]).invoke(moduleLayerClass, new Object[0]);
            return Optional.of(bootModuleLayer);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return Optional.empty();
        }
    }
}

