/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.utils;

import com.github.javaparser.utils.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javassist.CtClass;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;

public class JavassistModuleHelper {
    public static String MODULE_INFO_CLASS_NAME = "module-info";

    public static Optional<Pair<String, List<String>>> getModuleWithExportedPackages(CtClass moduleInfo) {
        ClassFile classFile = moduleInfo.getClassFile();
        if (!classFile.getName().equals(MODULE_INFO_CLASS_NAME)) {
            throw new IllegalArgumentException("getModuleWithExportedPackages only supports module-info.class");
        }
        ConstPool constPool = classFile.getConstPool();
        byte[] moduleAttribute = classFile.getAttribute("Module").get();
        int attrIdx = 0;
        int moduleNameIndex = moduleAttribute[attrIdx++] << 16;
        String moduleName = constPool.getModuleInfo(moduleNameIndex |= moduleAttribute[attrIdx++]);
        ArrayList<String> exportedPackages = new ArrayList<String>();
        attrIdx += 4;
        int requiresCount = moduleAttribute[attrIdx++] << 16;
        attrIdx += (requiresCount |= moduleAttribute[attrIdx++]) * 6;
        int exportsCount = moduleAttribute[attrIdx++] << 16;
        exportsCount |= moduleAttribute[attrIdx++];
        for (int i = 0; i < exportsCount; ++i) {
            int exportsIndex = moduleAttribute[attrIdx++] << 16;
            exportsIndex = moduleAttribute[attrIdx++];
            String exportedPackageName = constPool.getPackageInfo(exportsIndex).replace('/', '.');
            exportedPackages.add(exportedPackageName);
            attrIdx += 2;
            int exportsToCount = moduleAttribute[attrIdx++] << 16;
            attrIdx += 2 + (exportsToCount |= moduleAttribute[attrIdx++]);
        }
        return Optional.of(new Pair((Object)moduleName, exportedPackages));
    }
}

