/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.resolution.typesolvers;

import com.github.javaparser.symbolsolver.resolution.typesolvers.ClassLoaderTypeSolver;
import com.github.javaparser.symbolsolver.utils.ModuleLayerHelper;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class ReflectionTypeSolver
extends ClassLoaderTypeSolver {
    private final Predicate<String> classFilter;
    public static final Predicate<String> ALL_CLASSES = name -> true;
    public static final Predicate<String> JRE_ONLY = name -> name.startsWith("java.") || name.startsWith("javax.");
    public static final Predicate<String> JCL_ONLY = name -> Stream.of("java.", "javax.", "org.ietf.jgss.", "org.omg.COBRA.", "org.omg.COBRA_2_3.", "org.omg.CosNaming.", "org.omg.Dynamic.", "org.omg.DynamicAny.", "org.omg.IOP.", "org.omg.Messaging.", "org.omg.PortableInterceptor.", "org.omg.PortableServer.", "org.omg.stub.java.rmi.", "org.w3c.dom.", "org.xml.sax.").anyMatch(name::startsWith);

    public ReflectionTypeSolver(Predicate<String> classFilter) {
        super(ReflectionTypeSolver.class.getClassLoader());
        this.classFilter = classFilter;
        Optional<Object> bootModuleLayer = ModuleLayerHelper.getBootModuleLayer();
        if (bootModuleLayer.isPresent()) {
            ArrayList<Object> moduleLayers = new ArrayList<Object>(1);
            moduleLayers.add(bootModuleLayer.get());
            this.setModulePackagesFromLayers(moduleLayers);
        }
    }

    public ReflectionTypeSolver(boolean jreOnly) {
        this(jreOnly ? JRE_ONLY : ALL_CLASSES);
    }

    public ReflectionTypeSolver() {
        this(true);
    }

    @Override
    protected boolean filterName(String name) {
        return this.classFilter.test(name);
    }
}

