/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.resolution.typesolvers;

import com.github.javaparser.resolution.TypeSolver;
import com.github.javaparser.resolution.UnsolvedSymbolException;
import com.github.javaparser.resolution.cache.Cache;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.model.SymbolReference;
import com.github.javaparser.symbolsolver.cache.InMemoryCache;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class CombinedTypeSolver
implements TypeSolver {
    private final Cache<String, SymbolReference<ResolvedReferenceTypeDeclaration>> typeCache;
    private TypeSolver parent;
    private List<TypeSolver> elements = new ArrayList<TypeSolver>();
    private Predicate<Exception> exceptionHandler;

    public CombinedTypeSolver(TypeSolver ... elements) {
        this(Arrays.asList(elements));
    }

    public CombinedTypeSolver(Predicate<Exception> exceptionHandler, TypeSolver ... elements) {
        this(exceptionHandler, Arrays.asList(elements));
    }

    public CombinedTypeSolver(Iterable<TypeSolver> elements) {
        this(ExceptionHandlers.IGNORE_NONE, elements);
    }

    public CombinedTypeSolver(Predicate<Exception> exceptionHandler, Iterable<TypeSolver> elements) {
        this(exceptionHandler, elements, InMemoryCache.create());
    }

    public CombinedTypeSolver(Predicate<Exception> exceptionHandler, Iterable<TypeSolver> elements, Cache<String, SymbolReference<ResolvedReferenceTypeDeclaration>> typeCache) {
        Objects.requireNonNull(typeCache, "The typeCache can't be null.");
        this.setExceptionHandler(exceptionHandler);
        this.typeCache = typeCache;
        for (TypeSolver el : elements) {
            this.add(el, false);
        }
    }

    public void setExceptionHandler(Predicate<Exception> exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public TypeSolver getParent() {
        return this.parent;
    }

    public void setParent(TypeSolver parent) {
        Objects.requireNonNull(parent);
        if (this.parent != null) {
            throw new IllegalStateException("This TypeSolver already has a parent.");
        }
        if (parent == this) {
            throw new IllegalStateException("The parent of this TypeSolver cannot be itself.");
        }
        this.parent = parent;
    }

    public void add(TypeSolver typeSolver, boolean resetCache) {
        Objects.requireNonNull(typeSolver, "The type solver can't be null");
        this.elements.add(typeSolver);
        typeSolver.setParent((TypeSolver)this);
        if (resetCache) {
            this.typeCache.removeAll();
        }
    }

    public void add(TypeSolver typeSolver) {
        this.add(typeSolver, true);
    }

    public SymbolReference<ResolvedReferenceTypeDeclaration> tryToSolveType(String name) {
        Optional cachedSymbol = this.typeCache.get((Object)name);
        if (cachedSymbol.isPresent()) {
            return (SymbolReference)cachedSymbol.get();
        }
        for (TypeSolver ts : this.elements) {
            try {
                SymbolReference res = ts.tryToSolveType(name);
                if (!res.isSolved()) continue;
                this.typeCache.put((Object)name, (Object)res);
                return res;
            }
            catch (Exception e) {
                if (this.exceptionHandler.test(e)) continue;
                throw e;
            }
        }
        SymbolReference unsolvedSymbol = SymbolReference.unsolved();
        this.typeCache.put((Object)name, (Object)unsolvedSymbol);
        return unsolvedSymbol;
    }

    public static String createModuleTypeName(String moduleQualifiedName, String simpleTypeName) {
        return String.format("<%s>.%s", moduleQualifiedName, simpleTypeName);
    }

    public SymbolReference<ResolvedReferenceTypeDeclaration> tryToSolveTypeInModule(String moduleQualifiedName, String simpleTypeName) {
        String cacheName = CombinedTypeSolver.createModuleTypeName(moduleQualifiedName, simpleTypeName);
        Optional cachedType = this.typeCache.get((Object)cacheName);
        if (cachedType.isPresent()) {
            return (SymbolReference)cachedType.get();
        }
        for (TypeSolver ts : this.elements) {
            try {
                SymbolReference res = ts.tryToSolveTypeInModule(moduleQualifiedName, simpleTypeName);
                if (!res.isSolved()) continue;
                this.typeCache.put((Object)cacheName, (Object)res);
                return res;
            }
            catch (Exception e) {
                if (this.exceptionHandler.test(e)) continue;
                throw e;
            }
        }
        SymbolReference unsolvedSymbol = SymbolReference.unsolved();
        this.typeCache.put((Object)cacheName, (Object)unsolvedSymbol);
        return unsolvedSymbol;
    }

    public ResolvedReferenceTypeDeclaration solveType(String name) throws UnsolvedSymbolException {
        SymbolReference<ResolvedReferenceTypeDeclaration> res = this.tryToSolveType(name);
        if (res.isSolved()) {
            return (ResolvedReferenceTypeDeclaration)res.getCorrespondingDeclaration();
        }
        throw new UnsolvedSymbolException(name);
    }

    public ResolvedReferenceTypeDeclaration solveTypeInModule(String moduleQualifiedName, String simpleTypeName) throws UnsolvedSymbolException {
        SymbolReference<ResolvedReferenceTypeDeclaration> res = this.tryToSolveTypeInModule(moduleQualifiedName, simpleTypeName);
        if (res.isSolved()) {
            return (ResolvedReferenceTypeDeclaration)res.getCorrespondingDeclaration();
        }
        throw new UnsolvedSymbolException("module=" + moduleQualifiedName + " type=" + simpleTypeName);
    }

    public static class ExceptionHandlers {
        public static final Predicate<Exception> IGNORE_NONE = e -> false;
        public static final Predicate<Exception> IGNORE_ALL = e -> true;
        public static final Predicate<Exception> IGNORE_UNSUPPORTED_OPERATION = ExceptionHandlers.getTypeBasedWhitelist(UnsupportedOperationException.class);
        public static final Predicate<Exception> IGNORE_UNSOLVED_SYMBOL = ExceptionHandlers.getTypeBasedWhitelist(UnsolvedSymbolException.class);
        public static final Predicate<Exception> IGNORE_UNSUPPORTED_AND_UNSOLVED = ExceptionHandlers.getTypeBasedWhitelist(UnsupportedOperationException.class, UnsolvedSymbolException.class);

        public static Predicate<Exception> getTypeBasedBlacklist(Class<? extends Exception> ... blacklist) {
            return e -> {
                for (Class clazz : blacklist) {
                    if (!clazz.isAssignableFrom(e.getClass())) continue;
                    return false;
                }
                return true;
            };
        }

        public static Predicate<Exception> getTypeBasedWhitelist(Class<? extends Exception> ... whitelist) {
            return e -> {
                for (Class clazz : whitelist) {
                    if (!clazz.isAssignableFrom(e.getClass())) continue;
                    return true;
                }
                return false;
            };
        }
    }
}

