/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.reflectionmodel;

import com.github.javaparser.resolution.TypeSolver;
import com.github.javaparser.resolution.declarations.ResolvedMethodLikeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParametrizable;
import com.github.javaparser.resolution.model.typesystem.ReferenceTypeImpl;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionConstructorDeclaration;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionFactory;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionMethodDeclaration;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ReflectionTypeParameter
implements ResolvedTypeParameterDeclaration {
    private TypeVariable typeVariable;
    private TypeSolver typeSolver;
    private ResolvedTypeParametrizable container;

    public ReflectionTypeParameter(TypeVariable typeVariable, boolean declaredOnClass, TypeSolver typeSolver) {
        Object genericDeclaration = typeVariable.getGenericDeclaration();
        if (genericDeclaration instanceof Class) {
            this.container = ReflectionFactory.typeDeclarationFor((Class)genericDeclaration, typeSolver);
        } else if (genericDeclaration instanceof Method) {
            this.container = new ReflectionMethodDeclaration((Method)genericDeclaration, typeSolver);
        } else if (genericDeclaration instanceof Constructor) {
            this.container = new ReflectionConstructorDeclaration((Constructor)genericDeclaration, typeSolver);
        }
        this.typeVariable = typeVariable;
        this.typeSolver = typeSolver;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResolvedTypeParameterDeclaration)) {
            return false;
        }
        ResolvedTypeParameterDeclaration that = (ResolvedTypeParameterDeclaration)o;
        if (!this.getQualifiedName().equals(that.getQualifiedName())) {
            return false;
        }
        if (this.declaredOnType() == that.declaredOnType()) {
            return true;
        }
        return this.declaredOnMethod() == that.declaredOnMethod();
    }

    public int hashCode() {
        int result = this.typeVariable.hashCode();
        result = 31 * result + this.container.hashCode();
        return result;
    }

    public String getName() {
        return this.typeVariable.getName();
    }

    public String getContainerQualifiedName() {
        if (this.container instanceof ResolvedReferenceTypeDeclaration) {
            return ((ResolvedReferenceTypeDeclaration)this.container).getQualifiedName();
        }
        return ((ResolvedMethodLikeDeclaration)this.container).getQualifiedSignature();
    }

    public String getContainerId() {
        if (this.container instanceof ResolvedReferenceTypeDeclaration) {
            return ((ResolvedReferenceTypeDeclaration)this.container).getId();
        }
        return ((ResolvedMethodLikeDeclaration)this.container).getQualifiedSignature();
    }

    public ResolvedTypeParametrizable getContainer() {
        return this.container;
    }

    public List<ResolvedTypeParameterDeclaration.Bound> getBounds() {
        return Arrays.stream(this.typeVariable.getBounds()).map(refB -> ResolvedTypeParameterDeclaration.Bound.extendsBound((ResolvedType)ReflectionFactory.typeUsageFor(refB, this.typeSolver))).collect(Collectors.toList());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{typeVariable=" + this.typeVariable + '}';
    }

    public Optional<ResolvedReferenceTypeDeclaration> containerType() {
        if (this.container instanceof ResolvedReferenceTypeDeclaration) {
            return Optional.of((ResolvedReferenceTypeDeclaration)this.container);
        }
        return Optional.empty();
    }

    public ResolvedReferenceType object() {
        return new ReferenceTypeImpl(this.typeSolver.getSolvedJavaLangObject());
    }
}

