/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.resolution;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.resolution.Context;
import com.github.javaparser.resolution.MethodUsage;
import com.github.javaparser.resolution.Solver;
import com.github.javaparser.resolution.TypeSolver;
import com.github.javaparser.resolution.UnsolvedSymbolException;
import com.github.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedValueDeclaration;
import com.github.javaparser.resolution.model.SymbolReference;
import com.github.javaparser.resolution.model.Value;
import com.github.javaparser.resolution.model.typesystem.ReferenceTypeImpl;
import com.github.javaparser.resolution.types.ResolvedPrimitiveType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.core.resolution.SymbolResolutionCapability;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFactory;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserClassDeclaration;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserInterfaceDeclaration;
import com.github.javaparser.symbolsolver.logic.AbstractTypeDeclaration;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionAnnotationDeclaration;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionClassDeclaration;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionEnumDeclaration;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionInterfaceDeclaration;
import java.util.List;
import java.util.Optional;

public class SymbolSolver
implements Solver {
    private final TypeSolver typeSolver;

    public SymbolSolver(TypeSolver typeSolver) {
        if (typeSolver == null) {
            throw new IllegalArgumentException("Missing Parameter - Cannot initialise a SymbolSolver, without a way to solve types.");
        }
        this.typeSolver = typeSolver;
    }

    public SymbolReference<? extends ResolvedValueDeclaration> solveSymbol(String name, Context context) {
        return context.solveSymbol(name);
    }

    public SymbolReference<? extends ResolvedValueDeclaration> solveSymbol(String name, Node node) {
        return this.solveSymbol(name, JavaParserFactory.getContext(node, this.typeSolver));
    }

    public Optional<Value> solveSymbolAsValue(String name, Context context) {
        return context.solveSymbolAsValue(name);
    }

    public Optional<Value> solveSymbolAsValue(String name, Node node) {
        Context context = JavaParserFactory.getContext(node, this.typeSolver);
        return this.solveSymbolAsValue(name, context);
    }

    public SymbolReference<? extends ResolvedTypeDeclaration> solveType(String name, Context context) {
        return context.solveType(name);
    }

    public SymbolReference<? extends ResolvedTypeDeclaration> solveType(String name, Node node) {
        return this.solveType(name, JavaParserFactory.getContext(node, this.typeSolver));
    }

    public MethodUsage solveMethod(String methodName, List<ResolvedType> argumentsTypes, Context context) {
        SymbolReference decl = context.solveMethod(methodName, argumentsTypes, false);
        if (!decl.isSolved()) {
            throw new UnsolvedSymbolException(context.toString(), methodName);
        }
        return new MethodUsage((ResolvedMethodDeclaration)decl.getCorrespondingDeclaration());
    }

    public MethodUsage solveMethod(String methodName, List<ResolvedType> argumentsTypes, Node node) {
        return this.solveMethod(methodName, argumentsTypes, JavaParserFactory.getContext(node, this.typeSolver));
    }

    public ResolvedTypeDeclaration solveType(Type type) {
        if (type instanceof ClassOrInterfaceType) {
            String name = ((ClassOrInterfaceType)type).getNameWithScope();
            SymbolReference ref = JavaParserFactory.getContext((Node)type, this.typeSolver).solveType(name);
            if (!ref.isSolved()) {
                throw new UnsolvedSymbolException(JavaParserFactory.getContext((Node)type, this.typeSolver).toString(), name);
            }
            return (ResolvedTypeDeclaration)ref.getCorrespondingDeclaration();
        }
        throw new UnsupportedOperationException(type.getClass().getCanonicalName());
    }

    public ResolvedType solveTypeUsage(String name, Context context) {
        Optional genericType = context.solveGenericType(name);
        if (genericType.isPresent()) {
            return (ResolvedType)genericType.get();
        }
        ResolvedReferenceTypeDeclaration typeDeclaration = this.typeSolver.solveType(name);
        return new ReferenceTypeImpl(typeDeclaration);
    }

    public SymbolReference<? extends ResolvedValueDeclaration> solveSymbolInType(ResolvedTypeDeclaration typeDeclaration, String name) {
        if (typeDeclaration instanceof SymbolResolutionCapability) {
            return ((SymbolResolutionCapability)typeDeclaration).solveSymbol(name, this.typeSolver);
        }
        return SymbolReference.unsolved();
    }

    @Deprecated
    public SymbolReference<ResolvedTypeDeclaration> solveTypeInType(ResolvedTypeDeclaration typeDeclaration, String name) {
        if (typeDeclaration instanceof JavaParserClassDeclaration) {
            return ((JavaParserClassDeclaration)typeDeclaration).solveType(name);
        }
        if (typeDeclaration instanceof JavaParserInterfaceDeclaration) {
            return ((JavaParserInterfaceDeclaration)typeDeclaration).solveType(name);
        }
        return SymbolReference.unsolved();
    }

    public ResolvedType classToResolvedType(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return ResolvedPrimitiveType.byName((String)clazz.getName());
        }
        AbstractTypeDeclaration declaration = clazz.isAnnotation() ? new ReflectionAnnotationDeclaration(clazz, this.typeSolver) : (clazz.isEnum() ? new ReflectionEnumDeclaration(clazz, this.typeSolver) : (clazz.isInterface() ? new ReflectionInterfaceDeclaration(clazz, this.typeSolver) : new ReflectionClassDeclaration(clazz, this.typeSolver)));
        return new ReferenceTypeImpl((ResolvedReferenceTypeDeclaration)declaration);
    }
}

