/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.resolution.typeinference;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.ConditionalExpr;
import com.github.javaparser.ast.expr.EnclosedExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.MethodReferenceExpr;
import com.github.javaparser.ast.type.UnknownType;
import com.github.javaparser.resolution.MethodUsage;
import com.github.javaparser.resolution.TypeSolver;
import com.github.javaparser.resolution.declarations.ResolvedInterfaceDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import com.github.javaparser.resolution.model.typesystem.ReferenceTypeImpl;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFacade;
import com.github.javaparser.symbolsolver.resolution.typeinference.BoundSet;
import com.github.javaparser.symbolsolver.resolution.typeinference.ConstraintFormulaSet;
import com.github.javaparser.symbolsolver.resolution.typeinference.InferenceVariable;
import com.github.javaparser.symbolsolver.resolution.typeinference.InstantiationSet;
import com.github.javaparser.symbolsolver.resolution.typeinference.Substitution;
import com.github.javaparser.symbolsolver.resolution.typeinference.TypeInferenceCache;
import com.github.javaparser.symbolsolver.resolution.typeinference.bounds.SubtypeOfBound;
import com.github.javaparser.symbolsolver.resolution.typeinference.bounds.ThrowsBound;
import com.github.javaparser.symbolsolver.resolution.typeinference.constraintformulas.ExpressionCompatibleWithType;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public class TypeInference {
    private final ResolvedType object;
    private TypeSolver typeSolver;

    public TypeInference(TypeSolver typeSolver) {
        if (typeSolver == null) {
            throw new NullPointerException();
        }
        this.typeSolver = typeSolver;
        this.object = new ReferenceTypeImpl(typeSolver.getSolvedJavaLangObject());
    }

    public static MethodUsage toMethodUsage(MethodCallExpr call, ResolvedMethodDeclaration methodDeclaration, TypeSolver typeSolver) {
        TypeInference typeInference = new TypeInference(typeSolver);
        Optional<InstantiationSet> instantiationSetOpt = typeInference.instantiationInference(call, methodDeclaration);
        if (instantiationSetOpt.isPresent()) {
            return TypeInference.instantiationSetToMethodUsage(methodDeclaration, instantiationSetOpt.get());
        }
        throw new IllegalArgumentException();
    }

    public Optional<InstantiationSet> instantiationInference(MethodCallExpr methodCallExpr, ResolvedMethodDeclaration methodDeclaration) {
        return this.instantiationInference((List<Expression>)methodCallExpr.getArguments(), methodDeclaration);
    }

    public Optional<InstantiationSet> instantiationInference(List<Expression> argumentExpressions, ResolvedMethodDeclaration methodDeclaration) {
        BoundSet B0;
        List Ps = methodDeclaration.getTypeParameters();
        List<InferenceVariable> alphas = InferenceVariable.instantiate(Ps);
        Substitution theta = Substitution.empty();
        for (int i = 0; i < Ps.size(); ++i) {
            theta = theta.withPair((ResolvedTypeParameterDeclaration)Ps.get(0), alphas.get(0));
        }
        BoundSet B1 = B0 = this.boundSetup(Ps, alphas);
        for (int i = 0; i < Ps.size(); ++i) {
            ResolvedTypeParameterDeclaration Pi = (ResolvedTypeParameterDeclaration)Ps.get(i);
            if (!this.appearInThrowsClause(Pi, methodDeclaration)) continue;
            B1 = B1.withBound(new ThrowsBound(alphas.get(i)));
        }
        List<ResolvedType> Fs = this.formalParameterTypes(methodDeclaration);
        List<Expression> es = argumentExpressions;
        Optional<Object> C = Optional.empty();
        if (!C.isPresent()) {
            C = this.testForApplicabilityByStrictInvocation(Fs, es, theta);
        }
        if (!C.isPresent()) {
            C = this.testForApplicabilityByLooseInvocation(Fs, es, theta);
        }
        if (!C.isPresent()) {
            C = this.testForApplicabilityByVariableArityInvocation(Fs, es, theta);
        }
        if (!C.isPresent()) {
            return Optional.empty();
        }
        BoundSet resultingBounds = ((ConstraintFormulaSet)C.get()).reduce(this.typeSolver);
        BoundSet B2 = B1.incorporate(resultingBounds, this.typeSolver);
        if (B2.containsFalse()) {
            return Optional.empty();
        }
        Optional<InstantiationSet> instantiation = B2.performResolution(alphas, this.typeSolver);
        return instantiation;
    }

    public boolean invocationApplicabilityInference(MethodCallExpr methodCallExpr, ResolvedMethodDeclaration methodDeclaration) {
        int nFormalParams;
        if (!methodCallExpr.getNameAsString().equals(methodDeclaration.getName())) {
            throw new IllegalArgumentException();
        }
        Optional<InstantiationSet> partial = this.instantiationInference(methodCallExpr, methodDeclaration);
        if (!partial.isPresent()) {
            return false;
        }
        int nActualParams = methodCallExpr.getArguments().size();
        if (nActualParams != (nFormalParams = methodDeclaration.getNumberOfParams())) {
            if (methodDeclaration.hasVariadicParameter()) {
                if (nActualParams < nFormalParams - 1) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public BoundSet invocationTypeInferenceBoundsSetB3() {
        throw new UnsupportedOperationException();
    }

    public void invocationTypeInference() {
        BoundSet B3 = this.invocationTypeInferenceBoundsSetB3();
        throw new UnsupportedOperationException();
    }

    public void functionalInterfaceParameterizationInference(LambdaExpr lambdaExpr, ResolvedInterfaceDeclaration interfaceDeclaration) {
        int n = lambdaExpr.getParameters().size();
        if (interfaceDeclaration.getTypeParameters().isEmpty()) {
            throw new IllegalArgumentException("Functional Interface without type arguments");
        }
        int k = interfaceDeclaration.getTypeParameters().size();
        List<InferenceVariable> alphas = InferenceVariable.instantiate(interfaceDeclaration.getTypeParameters());
        TypeInferenceCache.recordInferenceVariables(this.typeSolver, lambdaExpr, alphas);
        if (n != k) {
            throw new IllegalArgumentException("No valida parameterization can exist has n= and k=" + k);
        }
        ConstraintFormulaSet constraintFormulaSet = ConstraintFormulaSet.empty();
        int i = 0;
        if (i < n) {
            throw new UnsupportedOperationException();
        }
        BoundSet B = constraintFormulaSet.reduce(this.typeSolver);
        throw new UnsupportedOperationException();
    }

    public boolean moreSpecificMethodInference(MethodCallExpr methodCall, ResolvedMethodDeclaration m1, ResolvedMethodDeclaration m2) {
        if (!m2.isGeneric()) {
            throw new IllegalArgumentException("M2 is not generic (m2: " + m2 + ")");
        }
        throw new UnsupportedOperationException();
    }

    private static MethodUsage instantiationSetToMethodUsage(ResolvedMethodDeclaration methodDeclaration, InstantiationSet instantiationSet) {
        if (instantiationSet.isEmpty()) {
            return new MethodUsage(methodDeclaration);
        }
        LinkedList<ResolvedType> paramTypes = new LinkedList<ResolvedType>();
        for (int i = 0; i < methodDeclaration.getNumberOfParams(); ++i) {
            paramTypes.add(instantiationSet.apply(methodDeclaration.getParam(i).getType()));
        }
        ResolvedType returnType = instantiationSet.apply(methodDeclaration.getReturnType());
        return new MethodUsage(methodDeclaration, paramTypes, returnType);
    }

    private BoundSet boundSetup(List<ResolvedTypeParameterDeclaration> typeParameterDeclarations, List<InferenceVariable> inferenceVariables) {
        if (typeParameterDeclarations.size() != inferenceVariables.size()) {
            throw new IllegalArgumentException();
        }
        BoundSet boundSet = BoundSet.empty();
        for (int l = 0; l < typeParameterDeclarations.size(); ++l) {
            ResolvedTypeParameterDeclaration Pl = typeParameterDeclarations.get(l);
            InferenceVariable alphaL = inferenceVariables.get(l);
            if (Pl.getBounds().isEmpty()) {
                boundSet = boundSet.withBound(new SubtypeOfBound(alphaL, this.object));
                continue;
            }
            for (ResolvedTypeParameterDeclaration.Bound bound : Pl.getBounds()) {
                ResolvedType T = bound.getType();
                Substitution substitution = Substitution.empty();
                for (int j = 0; j < typeParameterDeclarations.size(); ++j) {
                    substitution = substitution.withPair(typeParameterDeclarations.get(j), inferenceVariables.get(j));
                }
                ResolvedType TWithSubstitutions = substitution.apply(T);
                if (!(boundSet = boundSet.withBound(new SubtypeOfBound(alphaL, TWithSubstitutions))).getProperUpperBoundsFor(alphaL).isEmpty()) continue;
                boundSet = boundSet.withBound(new SubtypeOfBound(alphaL, this.object));
            }
        }
        return boundSet;
    }

    private boolean appearInThrowsClause(ResolvedTypeParameterDeclaration p, ResolvedMethodDeclaration methodDeclaration) {
        for (ResolvedType thrownType : methodDeclaration.getSpecifiedExceptions()) {
            if (!thrownType.isTypeVariable() || !thrownType.asTypeVariable().asTypeParameter().equals(p)) continue;
            return true;
        }
        return false;
    }

    private List<ResolvedType> formalParameterTypes(ResolvedMethodDeclaration methodDeclaration) {
        LinkedList<ResolvedType> types = new LinkedList<ResolvedType>();
        for (int i = 0; i < methodDeclaration.getNumberOfParams(); ++i) {
            types.add(methodDeclaration.getParam(i).getType());
        }
        return types;
    }

    private boolean isImplicitlyTyped(LambdaExpr lambdaExpr) {
        return lambdaExpr.getParameters().stream().anyMatch(p -> p.getType() instanceof UnknownType);
    }

    private boolean isInexact(MethodReferenceExpr methodReferenceExpr) {
        throw new UnsupportedOperationException();
    }

    private boolean isPertinentToApplicability(Expression argument) {
        MethodReferenceExpr methodReferenceExpr;
        LambdaExpr lambdaExpr;
        if (argument instanceof LambdaExpr && this.isImplicitlyTyped(lambdaExpr = (LambdaExpr)argument)) {
            return false;
        }
        if (argument instanceof MethodReferenceExpr && this.isInexact(methodReferenceExpr = (MethodReferenceExpr)argument)) {
            return false;
        }
        if (argument instanceof LambdaExpr) {
            throw new UnsupportedOperationException();
        }
        if (argument instanceof MethodReferenceExpr) {
            throw new UnsupportedOperationException();
        }
        if (argument instanceof LambdaExpr) {
            throw new UnsupportedOperationException();
        }
        if (argument instanceof LambdaExpr) {
            throw new UnsupportedOperationException();
        }
        if (argument instanceof EnclosedExpr) {
            EnclosedExpr enclosedExpr = (EnclosedExpr)argument;
            return this.isPertinentToApplicability(enclosedExpr.getInner());
        }
        if (argument instanceof ConditionalExpr) {
            ConditionalExpr conditionalExpr = (ConditionalExpr)argument;
            return this.isPertinentToApplicability(conditionalExpr.getThenExpr()) && this.isPertinentToApplicability(conditionalExpr.getElseExpr());
        }
        return true;
    }

    private Optional<ConstraintFormulaSet> testForApplicabilityByStrictInvocation(List<ResolvedType> Fs, List<Expression> es, Substitution theta) {
        int n = Fs.size();
        int k = es.size();
        if (k != n) {
            return Optional.empty();
        }
        for (int i = 0; i < n; ++i) {
            Expression ei = es.get(i);
            ResolvedType fi = Fs.get(i);
            if (!this.isPertinentToApplicability(ei)) continue;
            if (ei.isStandaloneExpression() && JavaParserFacade.get(this.typeSolver).getType((Node)ei).isPrimitive() && fi.isReferenceType()) {
                return Optional.empty();
            }
            if (!fi.isPrimitive() || ei.isStandaloneExpression() && JavaParserFacade.get(this.typeSolver).getType((Node)ei).isPrimitive()) continue;
            return Optional.empty();
        }
        return Optional.of(this.constraintSetFromArgumentsSubstitution(Fs, es, theta, k));
    }

    private ResolvedType typeWithSubstitution(ResolvedType originalType, Substitution substitution) {
        return substitution.apply(originalType);
    }

    private Optional<ConstraintFormulaSet> testForApplicabilityByLooseInvocation(List<ResolvedType> Fs, List<Expression> es, Substitution theta) {
        int n = Fs.size();
        int k = es.size();
        if (k != n) {
            return Optional.empty();
        }
        return Optional.of(this.constraintSetFromArgumentsSubstitution(Fs, es, theta, k));
    }

    private ConstraintFormulaSet constraintSetFromArgumentsSubstitution(List<ResolvedType> Fs, List<Expression> es, Substitution theta, int k) {
        ConstraintFormulaSet constraintFormulaSet = ConstraintFormulaSet.empty();
        for (int i = 0; i < k; ++i) {
            Expression ei = es.get(i);
            ResolvedType fi = Fs.get(i);
            ResolvedType fiTheta = this.typeWithSubstitution(fi, theta);
            constraintFormulaSet = constraintFormulaSet.withConstraint(new ExpressionCompatibleWithType(this.typeSolver, ei, fiTheta));
        }
        return constraintFormulaSet;
    }

    private Optional<ConstraintFormulaSet> testForApplicabilityByVariableArityInvocation(List<ResolvedType> Fs, List<Expression> es, Substitution theta) {
        int k = es.size();
        LinkedList<ResolvedType> FsFirst = new LinkedList<ResolvedType>();
        for (int i = 0; i < k; ++i) {
            ResolvedType FFirstI = i < Fs.size() ? Fs.get(i) : Fs.get(Fs.size() - 1);
            FsFirst.add(FFirstI);
        }
        return Optional.of(this.constraintSetFromArgumentsSubstitution(FsFirst, es, theta, k));
    }
}

