/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.javaparsermodel.contexts;

import com.github.javaparser.ast.AccessSpecifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.nodeTypes.NodeWithExtends;
import com.github.javaparser.ast.nodeTypes.NodeWithImplements;
import com.github.javaparser.ast.nodeTypes.NodeWithTypeArguments;
import com.github.javaparser.ast.nodeTypes.NodeWithTypeParameters;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.type.TypeParameter;
import com.github.javaparser.resolution.Context;
import com.github.javaparser.resolution.TypeSolver;
import com.github.javaparser.resolution.declarations.HasAccessSpecifier;
import com.github.javaparser.resolution.declarations.ResolvedClassDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedConstructorDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeDeclaration;
import com.github.javaparser.resolution.logic.ConstructorResolutionLogic;
import com.github.javaparser.resolution.logic.MethodResolutionLogic;
import com.github.javaparser.resolution.model.SymbolReference;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFacade;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFactory;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserTypeParameter;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class JavaParserTypeDeclarationAdapter {
    private TypeDeclaration<?> wrappedNode;
    private TypeSolver typeSolver;
    private Context context;
    private ResolvedReferenceTypeDeclaration typeDeclaration;

    public JavaParserTypeDeclarationAdapter(TypeDeclaration<?> wrappedNode, TypeSolver typeSolver, ResolvedReferenceTypeDeclaration typeDeclaration, Context context) {
        this.wrappedNode = wrappedNode;
        this.typeSolver = typeSolver;
        this.typeDeclaration = typeDeclaration;
        this.context = context;
    }

    @Deprecated
    public SymbolReference<ResolvedTypeDeclaration> solveType(String name) {
        return this.solveType(name, null);
    }

    public SymbolReference<ResolvedTypeDeclaration> solveType(String name, List<ResolvedType> typeArguments) {
        String typeName;
        ResolvedTypeDeclaration type;
        if (this.wrappedNode.getName().getId().equals(name)) {
            return SymbolReference.solved((ResolvedDeclaration)JavaParserFacade.get(this.typeSolver).getTypeDeclaration(this.wrappedNode));
        }
        for (Object member : this.wrappedNode.getMembers()) {
            if (!member.isTypeDeclaration()) continue;
            TypeDeclaration internalType = member.asTypeDeclaration();
            if (internalType.getName().getId().equals(name) && this.compareTypeParameters(internalType, typeArguments)) {
                return SymbolReference.solved((ResolvedDeclaration)JavaParserFacade.get(this.typeSolver).getTypeDeclaration(internalType));
            }
            if (name.startsWith(this.wrappedNode.getName().getId() + "." + internalType.getName().getId())) {
                return JavaParserFactory.getContext((Node)internalType, this.typeSolver).solveType(name.substring(this.wrappedNode.getName().getId().length() + 1), typeArguments);
            }
            if (!name.startsWith(internalType.getName().getId() + ".")) continue;
            return JavaParserFactory.getContext((Node)internalType, this.typeSolver).solveType(name.substring(internalType.getName().getId().length() + 1), typeArguments);
        }
        if (this.wrappedNode instanceof NodeWithTypeParameters) {
            NodeWithTypeParameters nodeWithTypeParameters = (NodeWithTypeParameters)this.wrappedNode;
            for (TypeParameter astTpRaw : nodeWithTypeParameters.getTypeParameters()) {
                if (!astTpRaw.getName().getId().equals(name)) continue;
                return SymbolReference.solved((ResolvedDeclaration)new JavaParserTypeParameter(astTpRaw, this.typeSolver));
            }
        }
        if (this.wrappedNode instanceof NodeWithImplements) {
            NodeWithImplements nodeWithImplements = (NodeWithImplements)this.wrappedNode;
            for (ClassOrInterfaceType implementedType : nodeWithImplements.getImplementedTypes()) {
                if (!implementedType.getName().getId().equals(name)) continue;
                return ((Context)this.context.getParent().orElseThrow(() -> new RuntimeException("Parent context unexpectedly empty."))).solveType(implementedType.getNameWithScope(), typeArguments);
            }
        }
        if (this.wrappedNode instanceof NodeWithExtends) {
            NodeWithExtends nodeWithExtends = (NodeWithExtends)this.wrappedNode;
            for (ClassOrInterfaceType extendedType : nodeWithExtends.getExtendedTypes()) {
                if (!extendedType.getName().getId().equals(name) || !this.compareTypeArguments(extendedType, typeArguments)) continue;
                return ((Context)this.context.getParent().orElseThrow(() -> new RuntimeException("Parent context unexpectedly empty."))).solveType(extendedType.getNameWithScope(), typeArguments);
            }
        }
        if ((type = this.checkAncestorsForType(typeName = this.isCompositeName(name) ? this.innerMostPartOfName(name) : name, this.typeDeclaration)) != null) {
            return SymbolReference.solved((ResolvedDeclaration)type);
        }
        return ((Context)this.context.getParent().orElseThrow(() -> new RuntimeException("Parent context unexpectedly empty."))).solveType(name, typeArguments);
    }

    private boolean isCompositeName(String name) {
        return name.indexOf(46) > -1;
    }

    private String innerMostPartOfName(String name) {
        return this.isCompositeName(name) ? name.substring(name.lastIndexOf(".") + 1) : name;
    }

    private <T extends NodeWithTypeArguments<?>> boolean compareTypes(List<? extends Type> types, List<ResolvedType> resolvedTypeArguments) {
        if (resolvedTypeArguments == null) {
            return true;
        }
        return types.size() == resolvedTypeArguments.size();
    }

    private <T extends NodeWithTypeArguments<?>> boolean compareTypeArguments(T type, List<ResolvedType> resolvedTypeArguments) {
        return this.compareTypes((List)type.getTypeArguments().orElse(new NodeList()), resolvedTypeArguments);
    }

    private <T extends NodeWithTypeParameters<?>> boolean compareTypeParameters(T type, List<ResolvedType> resolvedTypeArguments) {
        return this.compareTypes((List<? extends Type>)type.getTypeParameters(), resolvedTypeArguments);
    }

    private boolean compareTypeParameters(TypeDeclaration<?> typeDeclaration, List<ResolvedType> resolvedTypeArguments) {
        if (typeDeclaration instanceof NodeWithTypeParameters) {
            return this.compareTypeParameters((NodeWithTypeParameters)typeDeclaration, resolvedTypeArguments);
        }
        return true;
    }

    private ResolvedTypeDeclaration checkAncestorsForType(String name, ResolvedReferenceTypeDeclaration declaration) {
        for (ResolvedReferenceType ancestor : declaration.getAncestors(true)) {
            try {
                ResolvedReferenceTypeDeclaration ancestorReferenceTypeDeclaration = (ResolvedReferenceTypeDeclaration)ancestor.getTypeDeclaration().orElseThrow(() -> new RuntimeException("TypeDeclaration unexpectedly empty."));
                for (ResolvedTypeDeclaration internalTypeDeclaration : ancestorReferenceTypeDeclaration.internalTypes()) {
                    ResolvedReferenceTypeDeclaration resolvedReferenceTypeDeclaration;
                    boolean visible = true;
                    if (internalTypeDeclaration instanceof ResolvedReferenceTypeDeclaration && (resolvedReferenceTypeDeclaration = internalTypeDeclaration.asReferenceType()) instanceof HasAccessSpecifier) {
                        boolean bl = visible = ((HasAccessSpecifier)resolvedReferenceTypeDeclaration).accessSpecifier() != AccessSpecifier.PRIVATE;
                    }
                    if (!internalTypeDeclaration.getName().equals(name)) continue;
                    if (visible) {
                        return internalTypeDeclaration;
                    }
                    return null;
                }
                ResolvedTypeDeclaration ancestorTypeDeclaration = this.checkAncestorsForType(name, ancestorReferenceTypeDeclaration);
                if (ancestorTypeDeclaration == null) continue;
                return ancestorTypeDeclaration;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
        }
        return null;
    }

    public SymbolReference<ResolvedMethodDeclaration> solveMethod(String name, List<ResolvedType> argumentsTypes, boolean staticOnly) {
        SymbolReference res;
        SymbolReference parentSolution;
        List candidateMethods = this.typeDeclaration.getDeclaredMethods().stream().filter(m -> m.getName().equals(name)).filter(m -> !staticOnly || m.isStatic()).collect(Collectors.toList());
        if (!this.typeDeclaration.isJavaLangObject()) {
            for (ResolvedReferenceType ancestor : this.typeDeclaration.getAncestors(true)) {
                Optional ancestorTypeDeclaration = ancestor.getTypeDeclaration();
                if (!ancestor.getTypeDeclaration().isPresent() || this.typeDeclaration == ancestorTypeDeclaration.get()) continue;
                candidateMethods.addAll(ancestor.getAllMethodsVisibleToInheritors().stream().filter(m -> m.getName().equals(name)).collect(Collectors.toList()));
                SymbolReference res2 = MethodResolutionLogic.solveMethodInType((ResolvedTypeDeclaration)((ResolvedTypeDeclaration)ancestorTypeDeclaration.get()), (String)name, argumentsTypes, (boolean)staticOnly);
                if (!res2.isSolved()) continue;
                candidateMethods.add(res2.getCorrespondingDeclaration());
            }
        }
        if (candidateMethods.isEmpty() && (parentSolution = ((Context)this.context.getParent().orElseThrow(() -> new RuntimeException("Parent context unexpectedly empty."))).solveMethod(name, argumentsTypes, staticOnly)).isSolved()) {
            candidateMethods.add(parentSolution.getCorrespondingDeclaration());
        }
        if (candidateMethods.isEmpty() && this.typeDeclaration.isInterface() && (res = MethodResolutionLogic.solveMethodInType((ResolvedTypeDeclaration)this.typeSolver.getSolvedJavaLangObject(), (String)name, argumentsTypes, (boolean)false)).isSolved()) {
            candidateMethods.add(res.getCorrespondingDeclaration());
        }
        return MethodResolutionLogic.findMostApplicable(candidateMethods, (String)name, argumentsTypes, (TypeSolver)this.typeSolver);
    }

    public SymbolReference<ResolvedConstructorDeclaration> solveConstructor(List<ResolvedType> argumentsTypes) {
        if (this.typeDeclaration instanceof ResolvedClassDeclaration) {
            return ConstructorResolutionLogic.findMostApplicable((List)this.typeDeclaration.getConstructors(), argumentsTypes, (TypeSolver)this.typeSolver);
        }
        return SymbolReference.unsolved();
    }
}

