/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.javassistmodel;

import com.github.javaparser.ast.AccessSpecifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.resolution.Context;
import com.github.javaparser.resolution.MethodUsage;
import com.github.javaparser.resolution.TypeSolver;
import com.github.javaparser.resolution.UnsolvedSymbolException;
import com.github.javaparser.resolution.declarations.ResolvedConstructorDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedFieldDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedValueDeclaration;
import com.github.javaparser.resolution.model.LambdaArgumentTypePlaceholder;
import com.github.javaparser.resolution.model.SymbolReference;
import com.github.javaparser.resolution.model.typesystem.ReferenceTypeImpl;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.core.resolution.MethodUsageResolutionCapability;
import com.github.javaparser.symbolsolver.core.resolution.SymbolResolutionCapability;
import com.github.javaparser.symbolsolver.javassistmodel.JavassistFactory;
import com.github.javaparser.symbolsolver.javassistmodel.JavassistFieldDeclaration;
import com.github.javaparser.symbolsolver.javassistmodel.JavassistTypeDeclarationAdapter;
import com.github.javaparser.symbolsolver.javassistmodel.JavassistUtils;
import com.github.javaparser.symbolsolver.logic.AbstractClassDeclaration;
import com.github.javaparser.symbolsolver.resolution.SymbolSolver;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javassist.CtClass;
import javassist.CtField;

public class JavassistClassDeclaration
extends AbstractClassDeclaration
implements MethodUsageResolutionCapability,
SymbolResolutionCapability {
    private CtClass ctClass;
    private TypeSolver typeSolver;
    private JavassistTypeDeclarationAdapter javassistTypeDeclarationAdapter;

    public JavassistClassDeclaration(CtClass ctClass, TypeSolver typeSolver) {
        if (ctClass == null) {
            throw new IllegalArgumentException();
        }
        if (ctClass.isInterface() || ctClass.isAnnotation() || ctClass.isPrimitive() || ctClass.isEnum()) {
            throw new IllegalArgumentException("Trying to instantiate a JavassistClassDeclaration with something which is not a class: " + ctClass.toString());
        }
        this.ctClass = ctClass;
        this.typeSolver = typeSolver;
        this.javassistTypeDeclarationAdapter = new JavassistTypeDeclarationAdapter(ctClass, typeSolver, this);
    }

    @Override
    protected ResolvedReferenceType object() {
        return new ReferenceTypeImpl(this.typeSolver.getSolvedJavaLangObject());
    }

    public boolean hasDirectlyAnnotation(String canonicalName) {
        return this.ctClass.hasAnnotation(canonicalName);
    }

    public Set<ResolvedMethodDeclaration> getDeclaredMethods() {
        return this.javassistTypeDeclarationAdapter.getDeclaredMethods();
    }

    public boolean isAssignableBy(ResolvedReferenceTypeDeclaration other) {
        return this.isAssignableBy((ResolvedType)new ReferenceTypeImpl(other));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavassistClassDeclaration that = (JavassistClassDeclaration)o;
        return this.ctClass.equals(that.ctClass);
    }

    public int hashCode() {
        return this.ctClass.hashCode();
    }

    public String getPackageName() {
        return this.ctClass.getPackageName();
    }

    public String getClassName() {
        String className = this.ctClass.getName().replace('$', '.');
        if (this.getPackageName() != null) {
            return className.substring(this.getPackageName().length() + 1);
        }
        return className;
    }

    public String getQualifiedName() {
        return this.ctClass.getName().replace('$', '.');
    }

    @Override
    @Deprecated
    public Optional<MethodUsage> solveMethodAsUsage(String name, List<ResolvedType> argumentsTypes, Context invokationContext, List<ResolvedType> typeParameterValues) {
        return JavassistUtils.solveMethodAsUsage(name, argumentsTypes, this.typeSolver, invokationContext, typeParameterValues, this, this.ctClass);
    }

    @Override
    public SymbolReference<? extends ResolvedValueDeclaration> solveSymbol(String name, TypeSolver typeSolver) {
        String[] interfaceFQNs;
        for (CtField field : this.ctClass.getDeclaredFields()) {
            if (!field.getName().equals(name)) continue;
            return SymbolReference.solved((ResolvedDeclaration)new JavassistFieldDeclaration(field, typeSolver));
        }
        String superclassFQN = this.getSuperclassFQN();
        SymbolReference<? extends ResolvedValueDeclaration> ref = this.solveSymbolForFQN(name, superclassFQN);
        if (ref.isSolved()) {
            return ref;
        }
        for (String interfaceFQN : interfaceFQNs = this.getInterfaceFQNs()) {
            SymbolReference<? extends ResolvedValueDeclaration> interfaceRef = this.solveSymbolForFQN(name, interfaceFQN);
            if (!interfaceRef.isSolved()) continue;
            return interfaceRef;
        }
        return SymbolReference.unsolved();
    }

    private SymbolReference<? extends ResolvedValueDeclaration> solveSymbolForFQN(String symbolName, String fqn) {
        if (fqn == null) {
            return SymbolReference.unsolved();
        }
        ResolvedReferenceTypeDeclaration fqnTypeDeclaration = this.typeSolver.solveType(fqn);
        return new SymbolSolver(this.typeSolver).solveSymbolInType((ResolvedTypeDeclaration)fqnTypeDeclaration, symbolName);
    }

    private String[] getInterfaceFQNs() {
        return this.ctClass.getClassFile().getInterfaces();
    }

    private String getSuperclassFQN() {
        return this.ctClass.getClassFile().getSuperclass();
    }

    public List<ResolvedReferenceType> getAncestors(boolean acceptIncompleteList) {
        return this.javassistTypeDeclarationAdapter.getAncestors(acceptIncompleteList);
    }

    @Deprecated
    public SymbolReference<ResolvedMethodDeclaration> solveMethod(String name, List<ResolvedType> argumentsTypes, boolean staticOnly) {
        return JavassistUtils.solveMethod(name, argumentsTypes, staticOnly, this.typeSolver, this, this.ctClass);
    }

    public ResolvedType getUsage(Node node) {
        return new ReferenceTypeImpl((ResolvedReferenceTypeDeclaration)this);
    }

    public boolean isAssignableBy(ResolvedType type) {
        ResolvedReferenceType superClass;
        if (type.isNull()) {
            return true;
        }
        if (type instanceof LambdaArgumentTypePlaceholder) {
            return this.isFunctionalInterface();
        }
        if (type.describe().equals(this.getQualifiedName())) {
            return true;
        }
        Optional<ResolvedReferenceType> superClassOpt = this.getSuperClass();
        if (superClassOpt.isPresent() && (superClass = superClassOpt.get()).isAssignableBy(type)) {
            return true;
        }
        for (ResolvedReferenceType interfaceType : this.getInterfaces()) {
            if (!interfaceType.isAssignableBy(type)) continue;
            return true;
        }
        return false;
    }

    public boolean isTypeParameter() {
        return false;
    }

    public List<ResolvedFieldDeclaration> getAllFields() {
        return this.javassistTypeDeclarationAdapter.getDeclaredFields();
    }

    public String getName() {
        String[] nameElements = this.ctClass.getSimpleName().replace('$', '.').split("\\.");
        return nameElements[nameElements.length - 1];
    }

    public boolean isField() {
        return false;
    }

    public boolean isParameter() {
        return false;
    }

    public boolean isType() {
        return true;
    }

    public boolean isClass() {
        return !this.ctClass.isInterface();
    }

    public Optional<ResolvedReferenceType> getSuperClass() {
        return this.javassistTypeDeclarationAdapter.getSuperClass();
    }

    public List<ResolvedReferenceType> getInterfaces() {
        return this.javassistTypeDeclarationAdapter.getInterfaces();
    }

    public boolean isInterface() {
        return this.ctClass.isInterface();
    }

    public String toString() {
        return "JavassistClassDeclaration {" + this.ctClass.getName() + '}';
    }

    public List<ResolvedTypeParameterDeclaration> getTypeParameters() {
        return this.javassistTypeDeclarationAdapter.getTypeParameters();
    }

    public AccessSpecifier accessSpecifier() {
        return JavassistFactory.modifiersToAccessLevel(this.ctClass.getModifiers());
    }

    public List<ResolvedConstructorDeclaration> getConstructors() {
        return this.javassistTypeDeclarationAdapter.getConstructors();
    }

    public Optional<ResolvedReferenceTypeDeclaration> containerType() {
        return this.javassistTypeDeclarationAdapter.containerType();
    }

    public Set<ResolvedReferenceTypeDeclaration> internalTypes() {
        return this.javassistTypeDeclarationAdapter.internalTypes();
    }

    public ResolvedReferenceTypeDeclaration getInternalType(String name) {
        Optional<ResolvedReferenceTypeDeclaration> type = this.internalTypes().stream().filter(f -> f.getName().endsWith(name)).findFirst();
        return type.orElseThrow(() -> new UnsolvedSymbolException("Internal type not found: " + name));
    }

    public boolean hasInternalType(String name) {
        return this.internalTypes().stream().anyMatch(f -> f.getName().endsWith(name));
    }
}

