/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.javaparsermodel.contexts;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.PatternExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithOptionalScope;
import com.github.javaparser.resolution.UnsolvedSymbolException;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedValueDeclaration;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.core.resolution.Context;
import com.github.javaparser.symbolsolver.javaparser.Navigator;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFacade;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFactory;
import com.github.javaparser.symbolsolver.javaparsermodel.contexts.BinaryExprContext;
import com.github.javaparser.symbolsolver.javaparsermodel.contexts.IfStatementContext;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserPatternDeclaration;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserSymbolDeclaration;
import com.github.javaparser.symbolsolver.model.resolution.SymbolReference;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import com.github.javaparser.symbolsolver.model.resolution.Value;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionClassDeclaration;
import com.github.javaparser.symbolsolver.resolution.SymbolDeclarator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public abstract class AbstractJavaParserContext<N extends Node>
implements Context {
    protected N wrappedNode;
    protected TypeSolver typeSolver;

    protected static boolean isQualifiedName(String name) {
        return name.contains(".");
    }

    public static SymbolReference<ResolvedValueDeclaration> solveWith(SymbolDeclarator symbolDeclarator, String name) {
        for (ResolvedValueDeclaration decl : symbolDeclarator.getSymbolDeclarations()) {
            if (!decl.getName().equals(name)) continue;
            return SymbolReference.solved(decl);
        }
        return SymbolReference.unsolved();
    }

    public AbstractJavaParserContext(N wrappedNode, TypeSolver typeSolver) {
        if (wrappedNode == null) {
            throw new NullPointerException();
        }
        this.wrappedNode = wrappedNode;
        this.typeSolver = typeSolver;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractJavaParserContext that = (AbstractJavaParserContext)o;
        return this.wrappedNode != null ? this.wrappedNode.equals(that.wrappedNode) : that.wrappedNode == null;
    }

    public int hashCode() {
        return this.wrappedNode == null ? 0 : this.wrappedNode.hashCode();
    }

    @Override
    public final Optional<Context> getParent() {
        Node parentNode = this.wrappedNode.getParentNode().orElse(null);
        if (parentNode instanceof MethodCallExpr) {
            MethodCallExpr parentCall = (MethodCallExpr)parentNode;
            boolean found = false;
            for (Expression expression : parentCall.getArguments()) {
                if (expression != this.wrappedNode) continue;
                found = true;
                break;
            }
            if (found) {
                Node notMethod = parentNode;
                while (notMethod instanceof MethodCallExpr) {
                    notMethod = Navigator.demandParentNode(notMethod);
                }
                return Optional.of(JavaParserFactory.getContext(notMethod, this.typeSolver));
            }
        }
        Node notMethodNode = parentNode;
        while (notMethodNode instanceof MethodCallExpr || notMethodNode instanceof FieldAccessExpr || notMethodNode != null && notMethodNode.hasScope() && this.getScope(notMethodNode).equals(this.wrappedNode)) {
            notMethodNode = notMethodNode.getParentNode().orElse(null);
        }
        if (notMethodNode == null) {
            return Optional.empty();
        }
        Context parentContext = JavaParserFactory.getContext(notMethodNode, this.typeSolver);
        return Optional.of(parentContext);
    }

    protected Node getScope(Node node) {
        return (Node)((NodeWithOptionalScope)node).getScope().get();
    }

    @Override
    public SymbolReference<? extends ResolvedValueDeclaration> solveSymbolInParentContext(String name) {
        List<PatternExpr> patternExprs;
        Optional<PatternExpr> localResolutionResults;
        Optional<Context> optionalParentContext = this.getParent();
        if (!optionalParentContext.isPresent()) {
            return SymbolReference.unsolved();
        }
        Context parentContext = optionalParentContext.get();
        if ((parentContext instanceof BinaryExprContext || parentContext instanceof IfStatementContext) && (localResolutionResults = (patternExprs = parentContext.patternExprsExposedToChild((Node)this.getWrappedNode())).stream().filter(vd -> vd.getNameAsString().equals(name)).findFirst()).isPresent()) {
            if (patternExprs.size() == 1) {
                JavaParserPatternDeclaration decl = JavaParserSymbolDeclaration.patternVar(localResolutionResults.get(), this.typeSolver);
                return SymbolReference.solved(decl);
            }
            if (patternExprs.size() > 1) {
                throw new IllegalStateException("Unexpectedly more than one reference in scope");
            }
        }
        return parentContext.solveSymbol(name);
    }

    protected Optional<Value> solveWithAsValue(SymbolDeclarator symbolDeclarator, String name) {
        return symbolDeclarator.getSymbolDeclarations().stream().filter(d -> d.getName().equals(name)).map(Value::from).findFirst();
    }

    protected Collection<ResolvedReferenceTypeDeclaration> findTypeDeclarations(Optional<Expression> optScope) {
        if (optScope.isPresent()) {
            ResolvedType typeOfScope;
            NameExpr scopeAsName;
            SymbolReference<ResolvedTypeDeclaration> symbolReference;
            Expression scope = optScope.get();
            if (scope instanceof NameExpr && (symbolReference = this.solveType((scopeAsName = scope.asNameExpr()).getName().getId())).isSolved() && symbolReference.getCorrespondingDeclaration().isType()) {
                return Collections.singletonList(symbolReference.getCorrespondingDeclaration().asReferenceType());
            }
            try {
                typeOfScope = JavaParserFacade.get(this.typeSolver).getType((Node)scope);
            }
            catch (Exception e) {
                FieldAccessExpr scopeName;
                if (scope instanceof FieldAccessExpr && this.solveType((scopeName = (FieldAccessExpr)scope).toString()).isSolved()) {
                    return Collections.emptyList();
                }
                throw new UnsolvedSymbolException(scope.toString(), this.wrappedNode.toString(), (Throwable)e);
            }
            if (typeOfScope.isWildcard()) {
                if (typeOfScope.asWildcard().isExtends() || typeOfScope.asWildcard().isSuper()) {
                    return Collections.singletonList(typeOfScope.asWildcard().getBoundedType().asReferenceType().getTypeDeclaration().orElseThrow(() -> new RuntimeException("TypeDeclaration unexpectedly empty.")));
                }
                return Collections.singletonList(new ReflectionClassDeclaration(Object.class, this.typeSolver).asReferenceType());
            }
            if (typeOfScope.isArray()) {
                return Collections.singletonList(new ReflectionClassDeclaration(Object.class, this.typeSolver).asReferenceType());
            }
            if (typeOfScope.isTypeVariable()) {
                ArrayList<ResolvedReferenceTypeDeclaration> result = new ArrayList<ResolvedReferenceTypeDeclaration>();
                for (ResolvedTypeParameterDeclaration.Bound bound : typeOfScope.asTypeParameter().getBounds()) {
                    result.add((ResolvedReferenceTypeDeclaration)bound.getType().asReferenceType().getTypeDeclaration().orElseThrow(() -> new RuntimeException("TypeDeclaration unexpectedly empty.")));
                }
                return result;
            }
            if (typeOfScope.isConstraint()) {
                return Collections.singletonList(typeOfScope.asConstraintType().getBound().asReferenceType().getTypeDeclaration().orElseThrow(() -> new RuntimeException("TypeDeclaration unexpectedly empty.")));
            }
            if (typeOfScope.isUnionType()) {
                return typeOfScope.asUnionType().getCommonAncestor().flatMap(ResolvedReferenceType::getTypeDeclaration).map(Collections::singletonList).orElseThrow(() -> new UnsolvedSymbolException("No common ancestor available for UnionType" + typeOfScope.describe()));
            }
            return Collections.singletonList(typeOfScope.asReferenceType().getTypeDeclaration().orElseThrow(() -> new RuntimeException("TypeDeclaration unexpectedly empty.")));
        }
        ResolvedType typeOfScope = JavaParserFacade.get(this.typeSolver).getTypeOfThisIn((Node)this.wrappedNode);
        return Collections.singletonList(typeOfScope.asReferenceType().getTypeDeclaration().orElseThrow(() -> new RuntimeException("TypeDeclaration unexpectedly empty.")));
    }

    public N getWrappedNode() {
        return this.wrappedNode;
    }
}

