/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.javassistmodel;

import com.github.javaparser.resolution.UnsolvedSymbolException;
import com.github.javaparser.resolution.declarations.ResolvedConstructorDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedFieldDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParametrizable;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.javaparsermodel.LambdaArgumentTypePlaceholder;
import com.github.javaparser.symbolsolver.javassistmodel.JavassistConstructorDeclaration;
import com.github.javaparser.symbolsolver.javassistmodel.JavassistFactory;
import com.github.javaparser.symbolsolver.javassistmodel.JavassistFieldDeclaration;
import com.github.javaparser.symbolsolver.javassistmodel.JavassistMethodDeclaration;
import com.github.javaparser.symbolsolver.javassistmodel.JavassistTypeParameter;
import com.github.javaparser.symbolsolver.javassistmodel.JavassistUtils;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import com.github.javaparser.symbolsolver.model.typesystem.ReferenceTypeImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.SignatureAttribute;

public class JavassistTypeDeclarationAdapter {
    private CtClass ctClass;
    private TypeSolver typeSolver;
    private ResolvedReferenceTypeDeclaration typeDeclaration;

    public JavassistTypeDeclarationAdapter(CtClass ctClass, TypeSolver typeSolver, ResolvedReferenceTypeDeclaration typeDeclaration) {
        this.ctClass = ctClass;
        this.typeSolver = typeSolver;
        this.typeDeclaration = typeDeclaration;
    }

    public Optional<ResolvedReferenceType> getSuperClass() {
        try {
            if ("java.lang.Object".equals(this.ctClass.getClassFile().getName())) {
                return Optional.empty();
            }
            if (this.ctClass.getGenericSignature() == null) {
                return Optional.of(new ReferenceTypeImpl(this.typeSolver.solveType(JavassistUtils.internalNameToCanonicalName(this.ctClass.getClassFile().getSuperclass())), this.typeSolver));
            }
            SignatureAttribute.ClassSignature classSignature = SignatureAttribute.toClassSignature((String)this.ctClass.getGenericSignature());
            return Optional.ofNullable(JavassistUtils.signatureTypeToType((SignatureAttribute.Type)classSignature.getSuperClass(), this.typeSolver, (ResolvedTypeParametrizable)this.typeDeclaration).asReferenceType());
        }
        catch (BadBytecode e) {
            throw new RuntimeException(e);
        }
    }

    public List<ResolvedReferenceType> getInterfaces() {
        return this.getInterfaces(false);
    }

    private List<ResolvedReferenceType> getInterfaces(boolean acceptIncompleteList) {
        ArrayList<ResolvedReferenceType> interfaces = new ArrayList<ResolvedReferenceType>();
        try {
            if (this.ctClass.getGenericSignature() == null) {
                for (String interfaceType : this.ctClass.getClassFile().getInterfaces()) {
                    try {
                        ResolvedReferenceTypeDeclaration declaration = this.typeSolver.solveType(JavassistUtils.internalNameToCanonicalName(interfaceType));
                        interfaces.add(new ReferenceTypeImpl(declaration, this.typeSolver));
                    }
                    catch (UnsolvedSymbolException e) {
                        if (acceptIncompleteList) continue;
                        throw e;
                    }
                }
            } else {
                SignatureAttribute.ClassSignature classSignature = SignatureAttribute.toClassSignature((String)this.ctClass.getGenericSignature());
                for (SignatureAttribute.ClassType interfaceType : classSignature.getInterfaces()) {
                    try {
                        interfaces.add(JavassistUtils.signatureTypeToType((SignatureAttribute.Type)interfaceType, this.typeSolver, (ResolvedTypeParametrizable)this.typeDeclaration).asReferenceType());
                    }
                    catch (UnsolvedSymbolException e) {
                        if (acceptIncompleteList) continue;
                        throw e;
                    }
                }
            }
        }
        catch (BadBytecode e) {
            throw new RuntimeException(e);
        }
        return interfaces;
    }

    public List<ResolvedReferenceType> getAncestors(boolean acceptIncompleteList) {
        ArrayList<ResolvedReferenceType> ancestors;
        block2: {
            ancestors = new ArrayList<ResolvedReferenceType>();
            try {
                this.getSuperClass().ifPresent(superClass -> ancestors.add((ResolvedReferenceType)superClass));
            }
            catch (UnsolvedSymbolException e) {
                if (acceptIncompleteList) break block2;
                throw e;
            }
        }
        ancestors.addAll(this.getInterfaces(acceptIncompleteList));
        return ancestors;
    }

    public Set<ResolvedMethodDeclaration> getDeclaredMethods() {
        return Arrays.stream(this.ctClass.getDeclaredMethods()).filter(m -> (m.getMethodInfo().getAccessFlags() & 0x40) == 0 && (m.getMethodInfo().getAccessFlags() & 0x1000) == 0).map(m -> new JavassistMethodDeclaration((CtMethod)m, this.typeSolver)).collect(Collectors.toSet());
    }

    public List<ResolvedConstructorDeclaration> getConstructors() {
        return Arrays.stream(this.ctClass.getConstructors()).filter(m -> (m.getMethodInfo().getAccessFlags() & 0x1000) == 0).map(m -> new JavassistConstructorDeclaration((CtConstructor)m, this.typeSolver)).collect(Collectors.toList());
    }

    public List<ResolvedFieldDeclaration> getDeclaredFields() {
        ArrayList<ResolvedFieldDeclaration> fields = new ArrayList<ResolvedFieldDeclaration>();
        for (CtField field : this.ctClass.getDeclaredFields()) {
            fields.add(new JavassistFieldDeclaration(field, this.typeSolver));
        }
        for (ResolvedReferenceType ancestor : this.typeDeclaration.getAllAncestors()) {
            ancestor.getTypeDeclaration().ifPresent(ancestorTypeDeclaration -> fields.addAll(ancestorTypeDeclaration.getAllFields()));
        }
        return fields;
    }

    public List<ResolvedTypeParameterDeclaration> getTypeParameters() {
        if (null == this.ctClass.getGenericSignature()) {
            return Collections.emptyList();
        }
        try {
            SignatureAttribute.ClassSignature classSignature = SignatureAttribute.toClassSignature((String)this.ctClass.getGenericSignature());
            return Arrays.stream(classSignature.getParameters()).map(tp -> new JavassistTypeParameter((SignatureAttribute.TypeParameter)tp, (ResolvedTypeParametrizable)JavassistFactory.toTypeDeclaration(this.ctClass, this.typeSolver), this.typeSolver)).collect(Collectors.toList());
        }
        catch (BadBytecode badBytecode) {
            throw new RuntimeException(badBytecode);
        }
    }

    public Optional<ResolvedReferenceTypeDeclaration> containerType() {
        try {
            return this.ctClass.getDeclaringClass() == null ? Optional.empty() : Optional.of(JavassistFactory.toTypeDeclaration(this.ctClass.getDeclaringClass(), this.typeSolver));
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isAssignableBy(ResolvedType other) {
        if (other.isNull()) {
            return true;
        }
        if (other instanceof LambdaArgumentTypePlaceholder) {
            return this.typeDeclaration.isFunctionalInterface();
        }
        return other.isAssignableBy((ResolvedType)new ReferenceTypeImpl(this.typeDeclaration, this.typeSolver));
    }

    public boolean isAssignableBy(ResolvedReferenceTypeDeclaration other) {
        return this.isAssignableBy((ResolvedType)new ReferenceTypeImpl(other, this.typeSolver));
    }
}

