/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.resolution;

import com.github.javaparser.resolution.MethodAmbiguityException;
import com.github.javaparser.resolution.MethodUsage;
import com.github.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedMethodLikeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedParameterDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import com.github.javaparser.resolution.types.ResolvedArrayType;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.resolution.types.ResolvedTypeVariable;
import com.github.javaparser.resolution.types.ResolvedWildcard;
import com.github.javaparser.symbolsolver.logic.MethodResolutionCapability;
import com.github.javaparser.symbolsolver.model.resolution.SymbolReference;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import com.github.javaparser.symbolsolver.model.typesystem.ReferenceTypeImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class MethodResolutionLogic {
    private static List<ResolvedType> groupVariadicParamValues(List<ResolvedType> argumentsTypes, int startVariadic, ResolvedType variadicType) {
        ArrayList<ResolvedType> res = new ArrayList<ResolvedType>(argumentsTypes.subList(0, startVariadic));
        List<ResolvedType> variadicValues = argumentsTypes.subList(startVariadic, argumentsTypes.size());
        if (variadicValues.isEmpty()) {
            res.add(variadicType);
        } else {
            ResolvedType componentType = MethodResolutionLogic.findCommonType(variadicValues);
            res.add((ResolvedType)new ResolvedArrayType(componentType));
        }
        return res;
    }

    private static ResolvedType findCommonType(List<ResolvedType> variadicValues) {
        if (variadicValues.isEmpty()) {
            throw new IllegalArgumentException();
        }
        return variadicValues.get(0);
    }

    public static boolean isApplicable(ResolvedMethodDeclaration method, String name, List<ResolvedType> argumentsTypes, TypeSolver typeSolver) {
        return MethodResolutionLogic.isApplicable(method, name, argumentsTypes, typeSolver, false);
    }

    private static boolean isApplicable(ResolvedMethodDeclaration method, String name, List<ResolvedType> argumentsTypes, TypeSolver typeSolver, boolean withWildcardTolerance) {
        if (!method.getName().equals(name)) {
            return false;
        }
        if (method.hasVariadicParameter()) {
            int pos = method.getNumberOfParams() - 1;
            if (method.getNumberOfParams() == argumentsTypes.size()) {
                ResolvedType actualType;
                ResolvedType expectedType = method.getLastParam().getType();
                if (!expectedType.isAssignableBy(actualType = argumentsTypes.get(pos))) {
                    for (ResolvedTypeParameterDeclaration tp : method.getTypeParameters()) {
                        expectedType = MethodResolutionLogic.replaceTypeParam(expectedType, tp, typeSolver);
                    }
                    if (!expectedType.isAssignableBy(actualType)) {
                        if (actualType.isArray() && expectedType.isAssignableBy(actualType.asArrayType().getComponentType())) {
                            argumentsTypes.set(pos, actualType.asArrayType().getComponentType());
                        } else {
                            argumentsTypes = MethodResolutionLogic.groupVariadicParamValues(argumentsTypes, pos, method.getLastParam().getType());
                        }
                    }
                }
            } else {
                if (pos > argumentsTypes.size()) {
                    return false;
                }
                argumentsTypes = MethodResolutionLogic.groupVariadicParamValues(argumentsTypes, pos, method.getLastParam().getType());
            }
        }
        if (method.getNumberOfParams() != argumentsTypes.size()) {
            return false;
        }
        HashMap<String, ResolvedType> matchedParameters = new HashMap<String, ResolvedType>();
        boolean needForWildCardTolerance = false;
        for (int i = 0; i < method.getNumberOfParams(); ++i) {
            boolean isAssignableWithoutSubstitution;
            ResolvedType expectedType = method.getParam(i).getType();
            ResolvedType actualType = argumentsTypes.get(i);
            if (expectedType.isTypeVariable() && !expectedType.isWildcard() && expectedType.asTypeParameter().declaredOnMethod()) {
                matchedParameters.put(expectedType.asTypeParameter().getName(), actualType);
                continue;
            }
            boolean bl = isAssignableWithoutSubstitution = expectedType.isAssignableBy(actualType) || method.getParam(i).isVariadic() && new ResolvedArrayType(expectedType).isAssignableBy(actualType);
            if (!isAssignableWithoutSubstitution && expectedType.isReferenceType() && actualType.isReferenceType()) {
                isAssignableWithoutSubstitution = MethodResolutionLogic.isAssignableMatchTypeParameters(expectedType.asReferenceType(), actualType.asReferenceType(), matchedParameters);
            }
            if (isAssignableWithoutSubstitution) continue;
            List typeParameters = method.getTypeParameters();
            typeParameters.addAll(method.declaringType().getTypeParameters());
            for (ResolvedTypeParameterDeclaration tp : typeParameters) {
                expectedType = MethodResolutionLogic.replaceTypeParam(expectedType, tp, typeSolver);
            }
            if (expectedType.isAssignableBy(actualType)) continue;
            if (actualType.isWildcard() && withWildcardTolerance && !expectedType.isPrimitive()) {
                needForWildCardTolerance = true;
                continue;
            }
            if (method.hasVariadicParameter() && i == method.getNumberOfParams() - 1 && new ResolvedArrayType(expectedType).isAssignableBy(actualType)) continue;
            return false;
        }
        return !withWildcardTolerance || needForWildCardTolerance;
    }

    public static boolean isAssignableMatchTypeParameters(ResolvedType expected, ResolvedType actual, Map<String, ResolvedType> matchedParameters) {
        if (expected.isReferenceType() && actual.isReferenceType()) {
            return MethodResolutionLogic.isAssignableMatchTypeParameters(expected.asReferenceType(), actual.asReferenceType(), matchedParameters);
        }
        if (expected.isTypeVariable()) {
            matchedParameters.put(expected.asTypeParameter().getName(), actual);
            return true;
        }
        throw new UnsupportedOperationException(expected.getClass().getCanonicalName() + " " + actual.getClass().getCanonicalName());
    }

    public static boolean isAssignableMatchTypeParameters(ResolvedReferenceType expected, ResolvedReferenceType actual, Map<String, ResolvedType> matchedParameters) {
        if (actual.getQualifiedName().equals(expected.getQualifiedName())) {
            return MethodResolutionLogic.isAssignableMatchTypeParametersMatchingQName(expected, actual, matchedParameters);
        }
        List ancestors = actual.getAllAncestors();
        for (ResolvedReferenceType ancestor : ancestors) {
            if (!MethodResolutionLogic.isAssignableMatchTypeParametersMatchingQName(expected, ancestor, matchedParameters)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAssignableMatchTypeParametersMatchingQName(ResolvedReferenceType expected, ResolvedReferenceType actual, Map<String, ResolvedType> matchedParameters) {
        if (!expected.getQualifiedName().equals(actual.getQualifiedName())) {
            return false;
        }
        if (expected.typeParametersValues().size() != actual.typeParametersValues().size()) {
            throw new UnsupportedOperationException();
        }
        for (int i = 0; i < expected.typeParametersValues().size(); ++i) {
            ResolvedType expectedParam = (ResolvedType)expected.typeParametersValues().get(i);
            ResolvedType actualParam = (ResolvedType)actual.typeParametersValues().get(i);
            if (expectedParam.isReferenceType() && actualParam.isReferenceType()) {
                ResolvedReferenceType r1 = expectedParam.asReferenceType();
                ResolvedReferenceType r2 = actualParam.asReferenceType();
                return MethodResolutionLogic.isAssignableMatchTypeParametersMatchingQName(r1, r2, matchedParameters);
            }
            if (expectedParam.isTypeVariable()) {
                String expectedParamName = expectedParam.asTypeParameter().getName();
                if (actualParam.isTypeVariable() && actualParam.asTypeParameter().getName().equals(expectedParamName)) continue;
                return MethodResolutionLogic.matchTypeVariable(expectedParam.asTypeVariable(), actualParam, matchedParameters);
            }
            if (expectedParam.isReferenceType()) {
                if (actualParam.isTypeVariable()) {
                    return MethodResolutionLogic.matchTypeVariable(actualParam.asTypeVariable(), expectedParam, matchedParameters);
                }
                if (expectedParam.equals(actualParam)) continue;
                return false;
            }
            if (expectedParam.isWildcard()) {
                if (expectedParam.asWildcard().isExtends()) {
                    return MethodResolutionLogic.isAssignableMatchTypeParameters(expectedParam.asWildcard().getBoundedType(), (ResolvedType)actual, matchedParameters);
                }
                return true;
            }
            throw new UnsupportedOperationException(expectedParam.describe());
        }
        return true;
    }

    private static boolean matchTypeVariable(ResolvedTypeVariable typeVariable, ResolvedType type, Map<String, ResolvedType> matchedParameters) {
        String typeParameterName = typeVariable.asTypeParameter().getName();
        if (matchedParameters.containsKey(typeParameterName)) {
            ResolvedType matchedParameter = matchedParameters.get(typeParameterName);
            if (matchedParameter.isAssignableBy(type)) {
                return true;
            }
            if (type.isAssignableBy(matchedParameter)) {
                matchedParameters.put(typeParameterName, type);
                return true;
            }
            return false;
        }
        matchedParameters.put(typeParameterName, type);
        return true;
    }

    public static ResolvedType replaceTypeParam(ResolvedType type, ResolvedTypeParameterDeclaration tp, TypeSolver typeSolver) {
        if (type.isTypeVariable() || type.isWildcard()) {
            if (type.describe().equals(tp.getName())) {
                List bounds = tp.getBounds();
                if (bounds.size() > 1) {
                    throw new UnsupportedOperationException();
                }
                if (bounds.size() == 1) {
                    return ((ResolvedTypeParameterDeclaration.Bound)bounds.get(0)).getType();
                }
                return new ReferenceTypeImpl(typeSolver.solveType(Object.class.getCanonicalName()), typeSolver);
            }
            return type;
        }
        if (type.isPrimitive()) {
            return type;
        }
        if (type.isArray()) {
            return new ResolvedArrayType(MethodResolutionLogic.replaceTypeParam(type.asArrayType().getComponentType(), tp, typeSolver));
        }
        if (type.isReferenceType()) {
            ResolvedReferenceType result = type.asReferenceType();
            result = result.transformTypeParameters(typeParam -> MethodResolutionLogic.replaceTypeParam(typeParam, tp, typeSolver)).asReferenceType();
            return result;
        }
        throw new UnsupportedOperationException("Replacing " + type + ", param " + tp + " with " + type.getClass().getCanonicalName());
    }

    public static boolean isApplicable(MethodUsage method, String name, List<ResolvedType> argumentsTypes, TypeSolver typeSolver) {
        if (!method.getName().equals(name)) {
            return false;
        }
        if (method.getNoParams() != argumentsTypes.size()) {
            return false;
        }
        for (int i = 0; i < method.getNoParams(); ++i) {
            ResolvedType expectedType;
            ResolvedType expectedTypeWithoutSubstitutions = expectedType = method.getParamType(i);
            ResolvedType expectedTypeWithInference = method.getParamType(i);
            ResolvedType actualType = argumentsTypes.get(i);
            List typeParameters = method.getDeclaration().getTypeParameters();
            typeParameters.addAll(method.declaringType().getTypeParameters());
            if (expectedType.describe().equals(actualType.describe())) {
                return true;
            }
            HashMap<ResolvedTypeParameterDeclaration, ResolvedType> derivedValues = new HashMap<ResolvedTypeParameterDeclaration, ResolvedType>();
            for (int j = 0; j < method.getParamTypes().size(); ++j) {
                ResolvedParameterDeclaration parameter = method.getDeclaration().getParam(i);
                ResolvedType parameterType = parameter.getType();
                if (parameter.isVariadic()) {
                    parameterType = parameterType.asArrayType().getComponentType();
                }
                MethodResolutionLogic.inferTypes(argumentsTypes.get(j), parameterType, derivedValues);
            }
            for (Map.Entry entry : derivedValues.entrySet()) {
                ResolvedTypeParameterDeclaration tp = (ResolvedTypeParameterDeclaration)entry.getKey();
                expectedTypeWithInference = expectedTypeWithInference.replaceTypeVariables(tp, (ResolvedType)entry.getValue());
            }
            for (ResolvedTypeParameterDeclaration tp : typeParameters) {
                if (tp.getBounds().isEmpty()) {
                    expectedType = expectedType.replaceTypeVariables(tp, (ResolvedType)ResolvedWildcard.extendsBound((ResolvedType)new ReferenceTypeImpl(typeSolver.solveType(Object.class.getCanonicalName()), typeSolver)));
                    continue;
                }
                if (tp.getBounds().size() == 1) {
                    ResolvedTypeParameterDeclaration.Bound bound = (ResolvedTypeParameterDeclaration.Bound)tp.getBounds().get(0);
                    if (bound.isExtends()) {
                        expectedType = expectedType.replaceTypeVariables(tp, (ResolvedType)ResolvedWildcard.extendsBound((ResolvedType)bound.getType()));
                        continue;
                    }
                    expectedType = expectedType.replaceTypeVariables(tp, (ResolvedType)ResolvedWildcard.superBound((ResolvedType)bound.getType()));
                    continue;
                }
                throw new UnsupportedOperationException();
            }
            ResolvedType expectedType2 = expectedTypeWithoutSubstitutions;
            for (ResolvedTypeParameterDeclaration tp : typeParameters) {
                if (tp.getBounds().isEmpty()) {
                    expectedType2 = expectedType2.replaceTypeVariables(tp, (ResolvedType)new ReferenceTypeImpl(typeSolver.solveType(Object.class.getCanonicalName()), typeSolver));
                    continue;
                }
                if (tp.getBounds().size() == 1) {
                    ResolvedTypeParameterDeclaration.Bound bound = (ResolvedTypeParameterDeclaration.Bound)tp.getBounds().get(0);
                    if (bound.isExtends()) {
                        expectedType2 = expectedType2.replaceTypeVariables(tp, bound.getType());
                        continue;
                    }
                    expectedType2 = expectedType2.replaceTypeVariables(tp, (ResolvedType)new ReferenceTypeImpl(typeSolver.solveType(Object.class.getCanonicalName()), typeSolver));
                    continue;
                }
                throw new UnsupportedOperationException();
            }
            if (expectedType.isAssignableBy(actualType) || expectedType2.isAssignableBy(actualType) || expectedTypeWithInference.isAssignableBy(actualType) || expectedTypeWithoutSubstitutions.isAssignableBy(actualType)) continue;
            return false;
        }
        return true;
    }

    private static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        return t -> seen.add(keyExtractor.apply(t));
    }

    public static SymbolReference<ResolvedMethodDeclaration> findMostApplicable(List<ResolvedMethodDeclaration> methods, String name, List<ResolvedType> argumentsTypes, TypeSolver typeSolver) {
        SymbolReference<ResolvedMethodDeclaration> res = MethodResolutionLogic.findMostApplicable(methods, name, argumentsTypes, typeSolver, false);
        if (res.isSolved()) {
            return res;
        }
        return MethodResolutionLogic.findMostApplicable(methods, name, argumentsTypes, typeSolver, true);
    }

    public static SymbolReference<ResolvedMethodDeclaration> findMostApplicable(List<ResolvedMethodDeclaration> methods, String name, List<ResolvedType> argumentsTypes, TypeSolver typeSolver, boolean wildcardTolerance) {
        List methodsWithMatchingName = methods.stream().filter(m -> m.getName().equals(name)).collect(Collectors.toList());
        List applicableMethods = methodsWithMatchingName.stream().filter(MethodResolutionLogic.distinctByKey(ResolvedMethodLikeDeclaration::getQualifiedSignature)).filter(m -> MethodResolutionLogic.isApplicable(m, name, argumentsTypes, typeSolver, wildcardTolerance)).collect(Collectors.toList());
        if (applicableMethods.isEmpty()) {
            return SymbolReference.unsolved(ResolvedMethodDeclaration.class);
        }
        if (applicableMethods.size() > 1) {
            ArrayList<Integer> nullParamIndexes = new ArrayList<Integer>();
            for (int i = 0; i < argumentsTypes.size(); ++i) {
                if (!argumentsTypes.get(i).isNull()) continue;
                nullParamIndexes.add(i);
            }
            if (!nullParamIndexes.isEmpty()) {
                HashSet<ResolvedMethodDeclaration> removeCandidates = new HashSet<ResolvedMethodDeclaration>();
                for (Integer nullParamIndex : nullParamIndexes) {
                    for (ResolvedMethodDeclaration methDecl : applicableMethods) {
                        if (!methDecl.getParam(nullParamIndex.intValue()).getType().isArray()) continue;
                        removeCandidates.add(methDecl);
                    }
                }
                if (!removeCandidates.isEmpty() && removeCandidates.size() < applicableMethods.size()) {
                    applicableMethods.removeAll(removeCandidates);
                }
            }
        }
        if (applicableMethods.size() == 1) {
            return SymbolReference.solved((ResolvedMethodDeclaration)applicableMethods.get(0));
        }
        ResolvedMethodDeclaration winningCandidate = (ResolvedMethodDeclaration)applicableMethods.get(0);
        ResolvedMethodDeclaration other = null;
        boolean possibleAmbiguity = false;
        for (int i = 1; i < applicableMethods.size(); ++i) {
            other = (ResolvedMethodDeclaration)applicableMethods.get(i);
            if (MethodResolutionLogic.isMoreSpecific(winningCandidate, other, argumentsTypes)) {
                possibleAmbiguity = false;
                continue;
            }
            if (MethodResolutionLogic.isMoreSpecific(other, winningCandidate, argumentsTypes)) {
                possibleAmbiguity = false;
                winningCandidate = other;
                continue;
            }
            if (!winningCandidate.declaringType().getQualifiedName().equals(other.declaringType().getQualifiedName())) continue;
            possibleAmbiguity = true;
        }
        if (possibleAmbiguity && !MethodResolutionLogic.isExactMatch((ResolvedMethodLikeDeclaration)winningCandidate, argumentsTypes)) {
            if (MethodResolutionLogic.isExactMatch((ResolvedMethodLikeDeclaration)other, argumentsTypes)) {
                winningCandidate = other;
            } else {
                throw new MethodAmbiguityException("Ambiguous method call: cannot find a most applicable method: " + winningCandidate + ", " + other);
            }
        }
        return SymbolReference.solved(winningCandidate);
    }

    protected static boolean isExactMatch(ResolvedMethodLikeDeclaration method, List<ResolvedType> argumentsTypes) {
        for (int i = 0; i < method.getNumberOfParams(); ++i) {
            if (method.getParam(i).getType().equals(argumentsTypes.get(i))) continue;
            return false;
        }
        return true;
    }

    private static ResolvedType getMethodsExplicitAndVariadicParameterType(ResolvedMethodDeclaration method, int i) {
        int numberOfParams = method.getNumberOfParams();
        if (i < numberOfParams) {
            return method.getParam(i).getType();
        }
        if (method.hasVariadicParameter()) {
            return method.getParam(numberOfParams - 1).getType();
        }
        return null;
    }

    private static boolean isMoreSpecific(ResolvedMethodDeclaration methodA, ResolvedMethodDeclaration methodB, List<ResolvedType> argumentTypes) {
        boolean isLastArgArray;
        boolean aVariadic = methodA.hasVariadicParameter();
        boolean bVariadic = methodB.hasVariadicParameter();
        int aNumberOfParams = methodA.getNumberOfParams();
        int bNumberOfParams = methodB.getNumberOfParams();
        int numberOfArgs = argumentTypes.size();
        ResolvedType lastArgType = numberOfArgs > 0 ? argumentTypes.get(numberOfArgs - 1) : null;
        boolean bl = isLastArgArray = lastArgType != null && lastArgType.isArray();
        if (!(aVariadic || aNumberOfParams != numberOfArgs || !bVariadic || bNumberOfParams == numberOfArgs && isLastArgArray)) {
            return true;
        }
        if (!(bVariadic || bNumberOfParams != numberOfArgs || !aVariadic || aNumberOfParams == numberOfArgs && isLastArgArray)) {
            return false;
        }
        for (int i = 0; i < numberOfArgs; ++i) {
            ResolvedType paramTypeA = MethodResolutionLogic.getMethodsExplicitAndVariadicParameterType(methodA, i);
            ResolvedType paramTypeB = MethodResolutionLogic.getMethodsExplicitAndVariadicParameterType(methodB, i);
            ResolvedType argType = argumentTypes.get(i);
            if (paramTypeA == null) {
                return false;
            }
            if (paramTypeB == null) {
                return true;
            }
            if (paramTypeA.isPrimitive() == argType.isPrimitive() && paramTypeB.isPrimitive() != argType.isPrimitive() && paramTypeA.isAssignableBy(argType)) {
                return true;
            }
            if (paramTypeB.isPrimitive() == argType.isPrimitive() && paramTypeA.isPrimitive() != argType.isPrimitive() && paramTypeB.isAssignableBy(argType)) {
                return false;
            }
            boolean aAssignableFromB = paramTypeA.isAssignableBy(paramTypeB);
            boolean bAssignableFromA = paramTypeB.isAssignableBy(paramTypeA);
            if (bAssignableFromA && !aAssignableFromB) {
                return true;
            }
            if (!aAssignableFromB || bAssignableFromA) continue;
            return false;
        }
        if (aVariadic && !bVariadic) {
            return isLastArgArray;
        }
        if (!aVariadic && bVariadic) {
            return !isLastArgArray;
        }
        return false;
    }

    private static boolean isMoreSpecific(MethodUsage methodA, MethodUsage methodB) {
        boolean oneMoreSpecificFound = false;
        for (int i = 0; i < methodA.getNoParams(); ++i) {
            ResolvedType tdA = methodA.getParamType(i);
            ResolvedType tdB = methodB.getParamType(i);
            boolean aIsAssignableByB = tdA.isAssignableBy(tdB);
            boolean bIsAssignableByA = tdB.isAssignableBy(tdA);
            if (bIsAssignableByA && !aIsAssignableByB) {
                oneMoreSpecificFound = true;
            }
            if (!aIsAssignableByB || bIsAssignableByA) continue;
            return false;
        }
        return oneMoreSpecificFound;
    }

    public static Optional<MethodUsage> findMostApplicableUsage(List<MethodUsage> methods, String name, List<ResolvedType> argumentsTypes, TypeSolver typeSolver) {
        List applicableMethods = methods.stream().filter(m -> MethodResolutionLogic.isApplicable(m, name, argumentsTypes, typeSolver)).collect(Collectors.toList());
        if (applicableMethods.isEmpty()) {
            return Optional.empty();
        }
        if (applicableMethods.size() == 1) {
            return Optional.of((MethodUsage)applicableMethods.get(0));
        }
        MethodUsage winningCandidate = (MethodUsage)applicableMethods.get(0);
        for (int i = 1; i < applicableMethods.size(); ++i) {
            MethodUsage other = (MethodUsage)applicableMethods.get(i);
            if (MethodResolutionLogic.isMoreSpecific(winningCandidate, other)) continue;
            if (MethodResolutionLogic.isMoreSpecific(other, winningCandidate)) {
                winningCandidate = other;
                continue;
            }
            if (!winningCandidate.declaringType().getQualifiedName().equals(other.declaringType().getQualifiedName()) || MethodResolutionLogic.areOverride(winningCandidate, other)) continue;
            throw new MethodAmbiguityException("Ambiguous method call: cannot find a most applicable method: " + winningCandidate + ", " + other + ". First declared in " + winningCandidate.declaringType().getQualifiedName());
        }
        return Optional.of(winningCandidate);
    }

    private static boolean areOverride(MethodUsage winningCandidate, MethodUsage other) {
        if (!winningCandidate.getName().equals(other.getName())) {
            return false;
        }
        if (winningCandidate.getNoParams() != other.getNoParams()) {
            return false;
        }
        for (int i = 0; i < winningCandidate.getNoParams(); ++i) {
            if (((ResolvedType)winningCandidate.getParamTypes().get(i)).equals(other.getParamTypes().get(i))) continue;
            return false;
        }
        return true;
    }

    public static SymbolReference<ResolvedMethodDeclaration> solveMethodInType(ResolvedTypeDeclaration typeDeclaration, String name, List<ResolvedType> argumentsTypes) {
        return MethodResolutionLogic.solveMethodInType(typeDeclaration, name, argumentsTypes, false);
    }

    public static SymbolReference<ResolvedMethodDeclaration> solveMethodInType(ResolvedTypeDeclaration typeDeclaration, String name, List<ResolvedType> argumentsTypes, boolean staticOnly) {
        if (typeDeclaration instanceof MethodResolutionCapability) {
            return ((MethodResolutionCapability)typeDeclaration).solveMethod(name, argumentsTypes, staticOnly);
        }
        throw new UnsupportedOperationException(typeDeclaration.getClass().getCanonicalName());
    }

    private static void inferTypes(ResolvedType source, ResolvedType target, Map<ResolvedTypeParameterDeclaration, ResolvedType> mappings) {
        if (source.equals(target)) {
            return;
        }
        if (source.isReferenceType() && target.isReferenceType()) {
            ResolvedReferenceType sourceRefType = source.asReferenceType();
            ResolvedReferenceType targetRefType = target.asReferenceType();
            if (sourceRefType.getQualifiedName().equals(targetRefType.getQualifiedName()) && !sourceRefType.isRawType() && !targetRefType.isRawType()) {
                for (int i = 0; i < sourceRefType.typeParametersValues().size(); ++i) {
                    MethodResolutionLogic.inferTypes((ResolvedType)sourceRefType.typeParametersValues().get(i), (ResolvedType)targetRefType.typeParametersValues().get(i), mappings);
                }
            }
            return;
        }
        if (source.isReferenceType() && target.isWildcard()) {
            if (target.asWildcard().isBounded()) {
                MethodResolutionLogic.inferTypes(source, target.asWildcard().getBoundedType(), mappings);
                return;
            }
            return;
        }
        if (source.isWildcard() && target.isWildcard()) {
            return;
        }
        if (source.isReferenceType() && target.isTypeVariable()) {
            mappings.put(target.asTypeParameter(), source);
            return;
        }
        if (source.isWildcard() && target.isReferenceType()) {
            if (source.asWildcard().isBounded()) {
                MethodResolutionLogic.inferTypes(source.asWildcard().getBoundedType(), target, mappings);
            }
            return;
        }
        if (source.isWildcard() && target.isTypeVariable()) {
            mappings.put(target.asTypeParameter(), source);
            return;
        }
        if (source.isTypeVariable() && target.isTypeVariable()) {
            mappings.put(target.asTypeParameter(), source);
            return;
        }
        if (source.isPrimitive() || target.isPrimitive()) {
            return;
        }
        if (source.isNull()) {
            return;
        }
    }
}

