/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.javaparsermodel;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.ArrayAccessExpr;
import com.github.javaparser.ast.expr.ArrayCreationExpr;
import com.github.javaparser.ast.expr.ArrayInitializerExpr;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.CastExpr;
import com.github.javaparser.ast.expr.CharLiteralExpr;
import com.github.javaparser.ast.expr.ClassExpr;
import com.github.javaparser.ast.expr.ConditionalExpr;
import com.github.javaparser.ast.expr.DoubleLiteralExpr;
import com.github.javaparser.ast.expr.EnclosedExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.InstanceOfExpr;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.LongLiteralExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.MethodReferenceExpr;
import com.github.javaparser.ast.expr.Name;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.expr.SuperExpr;
import com.github.javaparser.ast.expr.ThisExpr;
import com.github.javaparser.ast.expr.TypeExpr;
import com.github.javaparser.ast.expr.UnaryExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.type.UnknownType;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.resolution.MethodUsage;
import com.github.javaparser.resolution.UnsolvedSymbolException;
import com.github.javaparser.resolution.declarations.ResolvedClassDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeDeclaration;
import com.github.javaparser.resolution.types.ResolvedArrayType;
import com.github.javaparser.resolution.types.ResolvedPrimitiveType;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.resolution.types.ResolvedVoidType;
import com.github.javaparser.symbolsolver.core.resolution.Context;
import com.github.javaparser.symbolsolver.javaparser.Navigator;
import com.github.javaparser.symbolsolver.javaparsermodel.DefaultVisitorAdapter;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFacade;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFactory;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserSymbolDeclaration;
import com.github.javaparser.symbolsolver.logic.FunctionalInterfaceLogic;
import com.github.javaparser.symbolsolver.logic.InferenceContext;
import com.github.javaparser.symbolsolver.model.resolution.SymbolReference;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import com.github.javaparser.symbolsolver.model.resolution.Value;
import com.github.javaparser.symbolsolver.model.typesystem.NullType;
import com.github.javaparser.symbolsolver.model.typesystem.ReferenceTypeImpl;
import com.github.javaparser.symbolsolver.reflectionmodel.MyObjectProvider;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionClassDeclaration;
import com.github.javaparser.symbolsolver.resolution.SymbolSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.ReflectionTypeSolver;
import com.github.javaparser.utils.Log;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;

public class TypeExtractor
extends DefaultVisitorAdapter {
    private TypeSolver typeSolver;
    private JavaParserFacade facade;

    public TypeExtractor(TypeSolver typeSolver, JavaParserFacade facade) {
        this.typeSolver = typeSolver;
        this.facade = facade;
    }

    @Override
    public ResolvedType visit(VariableDeclarator node, Boolean solveLambdas) {
        if (Navigator.demandParentNode((Node)node) instanceof FieldDeclaration) {
            return this.facade.convertToUsageVariableType(node);
        }
        if (Navigator.demandParentNode((Node)node) instanceof VariableDeclarationExpr) {
            return this.facade.convertToUsageVariableType(node);
        }
        throw new UnsupportedOperationException(Navigator.demandParentNode((Node)node).getClass().getCanonicalName());
    }

    @Override
    public ResolvedType visit(Parameter node, Boolean solveLambdas) {
        if (node.getType() instanceof UnknownType) {
            throw new IllegalStateException("Parameter has unknown type: " + node);
        }
        return this.facade.convertToUsage(node.getType(), (Node)node);
    }

    @Override
    public ResolvedType visit(ArrayAccessExpr node, Boolean solveLambdas) {
        ResolvedType arrayUsageType = (ResolvedType)node.getName().accept((GenericVisitor)this, (Object)solveLambdas);
        if (arrayUsageType.isArray()) {
            return ((ResolvedArrayType)arrayUsageType).getComponentType();
        }
        return arrayUsageType;
    }

    @Override
    public ResolvedType visit(ArrayCreationExpr node, Boolean solveLambdas) {
        ResolvedType res = this.facade.convertToUsage(node.getElementType(), JavaParserFactory.getContext((Node)node, this.typeSolver));
        for (int i = 0; i < node.getLevels().size(); ++i) {
            res = new ResolvedArrayType(res);
        }
        return res;
    }

    @Override
    public ResolvedType visit(ArrayInitializerExpr node, Boolean solveLambdas) {
        throw new UnsupportedOperationException(node.getClass().getCanonicalName());
    }

    @Override
    public ResolvedType visit(AssignExpr node, Boolean solveLambdas) {
        return (ResolvedType)node.getTarget().accept((GenericVisitor)this, (Object)solveLambdas);
    }

    @Override
    public ResolvedType visit(BinaryExpr node, Boolean solveLambdas) {
        switch (node.getOperator()) {
            case PLUS: 
            case MINUS: 
            case DIVIDE: 
            case MULTIPLY: {
                return this.facade.getBinaryTypeConcrete((Node)node.getLeft(), (Node)node.getRight(), solveLambdas, node.getOperator());
            }
            case LESS_EQUALS: 
            case LESS: 
            case GREATER: 
            case GREATER_EQUALS: 
            case EQUALS: 
            case NOT_EQUALS: 
            case OR: 
            case AND: {
                return ResolvedPrimitiveType.BOOLEAN;
            }
            case BINARY_AND: 
            case BINARY_OR: 
            case SIGNED_RIGHT_SHIFT: 
            case UNSIGNED_RIGHT_SHIFT: 
            case LEFT_SHIFT: 
            case REMAINDER: 
            case XOR: {
                return (ResolvedType)node.getLeft().accept((GenericVisitor)this, (Object)solveLambdas);
            }
        }
        throw new UnsupportedOperationException("Operator " + node.getOperator().name());
    }

    @Override
    public ResolvedType visit(CastExpr node, Boolean solveLambdas) {
        return this.facade.convertToUsage(node.getType(), JavaParserFactory.getContext((Node)node, this.typeSolver));
    }

    @Override
    public ResolvedType visit(ClassExpr node, Boolean solveLambdas) {
        Type astType = node.getType();
        ResolvedType jssType = this.facade.convertToUsage(astType, (Node)node.getType());
        return new ReferenceTypeImpl(new ReflectionClassDeclaration(Class.class, this.typeSolver), (List<ResolvedType>)ImmutableList.of((Object)jssType), this.typeSolver);
    }

    @Override
    public ResolvedType visit(ConditionalExpr node, Boolean solveLambdas) {
        return (ResolvedType)node.getThenExpr().accept((GenericVisitor)this, (Object)solveLambdas);
    }

    @Override
    public ResolvedType visit(EnclosedExpr node, Boolean solveLambdas) {
        return (ResolvedType)node.getInner().accept((GenericVisitor)this, (Object)solveLambdas);
    }

    private ResolvedType solveDotExpressionType(ResolvedReferenceTypeDeclaration parentType, FieldAccessExpr node) {
        if (parentType.isEnum() && parentType.asEnum().hasEnumConstant(node.getName().getId())) {
            return parentType.asEnum().getEnumConstant(node.getName().getId()).getType();
        }
        if (parentType.hasField(node.getName().getId())) {
            return parentType.getField(node.getName().getId()).getType();
        }
        if (parentType.hasInternalType(node.getName().getId())) {
            return new ReferenceTypeImpl(parentType.getInternalType(node.getName().getId()), this.typeSolver);
        }
        throw new UnsolvedSymbolException(node.getName().getId());
    }

    @Override
    public ResolvedType visit(FieldAccessExpr node, Boolean solveLambdas) {
        Optional<Object> value;
        block10: {
            SymbolReference<ResolvedReferenceTypeDeclaration> sr;
            if (node.getScope() instanceof NameExpr || node.getScope() instanceof FieldAccessExpr) {
                Expression staticValue = node.getScope();
                SymbolReference<ResolvedTypeDeclaration> typeAccessedStatically = JavaParserFactory.getContext((Node)node, this.typeSolver).solveType(staticValue.toString());
                if (typeAccessedStatically.isSolved()) {
                    return this.solveDotExpressionType(typeAccessedStatically.getCorrespondingDeclaration().asReferenceType(), node);
                }
            } else if (node.getScope() instanceof ThisExpr) {
                ResolvedTypeDeclaration correspondingDeclaration;
                SymbolReference<ResolvedTypeDeclaration> solve = this.facade.solve((ThisExpr)node.getScope());
                if (solve.isSolved() && (correspondingDeclaration = solve.getCorrespondingDeclaration()) instanceof ResolvedReferenceTypeDeclaration) {
                    return this.solveDotExpressionType(correspondingDeclaration.asReferenceType(), node);
                }
            } else if (node.getScope().toString().indexOf(46) > 0 && (sr = this.typeSolver.tryToSolveType(node.getScope().toString())).isSolved()) {
                return this.solveDotExpressionType(sr.getCorrespondingDeclaration(), node);
            }
            value = Optional.empty();
            try {
                value = new SymbolSolver(this.typeSolver).solveSymbolAsValue(node.getName().getId(), (Node)node);
            }
            catch (UnsolvedSymbolException use) {
                SymbolReference<ResolvedReferenceTypeDeclaration> sref = this.typeSolver.tryToSolveType(node.toString());
                if (!sref.isSolved()) break block10;
                return new ReferenceTypeImpl(sref.getCorrespondingDeclaration(), this.typeSolver);
            }
        }
        if (value.isPresent()) {
            return ((Value)value.get()).getType();
        }
        throw new UnsolvedSymbolException(node.getName().getId());
    }

    @Override
    public ResolvedType visit(InstanceOfExpr node, Boolean solveLambdas) {
        return ResolvedPrimitiveType.BOOLEAN;
    }

    @Override
    public ResolvedType visit(StringLiteralExpr node, Boolean solveLambdas) {
        return new ReferenceTypeImpl(new ReflectionTypeSolver().solveType(String.class.getCanonicalName()), this.typeSolver);
    }

    @Override
    public ResolvedType visit(IntegerLiteralExpr node, Boolean solveLambdas) {
        return ResolvedPrimitiveType.INT;
    }

    @Override
    public ResolvedType visit(LongLiteralExpr node, Boolean solveLambdas) {
        return ResolvedPrimitiveType.LONG;
    }

    @Override
    public ResolvedType visit(CharLiteralExpr node, Boolean solveLambdas) {
        return ResolvedPrimitiveType.CHAR;
    }

    @Override
    public ResolvedType visit(DoubleLiteralExpr node, Boolean solveLambdas) {
        if (node.getValue().toLowerCase().endsWith("f")) {
            return ResolvedPrimitiveType.FLOAT;
        }
        return ResolvedPrimitiveType.DOUBLE;
    }

    @Override
    public ResolvedType visit(BooleanLiteralExpr node, Boolean solveLambdas) {
        return ResolvedPrimitiveType.BOOLEAN;
    }

    @Override
    public ResolvedType visit(NullLiteralExpr node, Boolean solveLambdas) {
        return NullType.INSTANCE;
    }

    @Override
    public ResolvedType visit(MethodCallExpr node, Boolean solveLambdas) {
        Log.trace((String)"getType on method call %s", (Supplier[])new Supplier[]{() -> node});
        MethodUsage ref = this.facade.solveMethodAsUsage(node);
        Log.trace((String)"getType on method call %s resolved to %s", (Supplier[])new Supplier[]{() -> node, () -> ref});
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = () -> node;
        supplierArray[1] = () -> ((MethodUsage)ref).returnType();
        Log.trace((String)"getType on method call %s return type is %s", (Supplier[])supplierArray);
        return ref.returnType();
    }

    @Override
    public ResolvedType visit(NameExpr node, Boolean solveLambdas) {
        Log.trace((String)"getType on name expr %s", (Supplier[])new Supplier[]{() -> node});
        Optional<Value> value = new SymbolSolver(this.typeSolver).solveSymbolAsValue(node.getName().getId(), (Node)node);
        if (!value.isPresent()) {
            throw new UnsolvedSymbolException("Solving " + node, node.getName().getId());
        }
        return value.get().getType();
    }

    @Override
    public ResolvedType visit(TypeExpr node, Boolean solveLambdas) {
        Log.trace((String)"getType on type expr %s", (Supplier[])new Supplier[]{() -> node});
        if (!(node.getType() instanceof ClassOrInterfaceType)) {
            throw new UnsupportedOperationException(node.getType().getClass().getCanonicalName());
        }
        ClassOrInterfaceType classOrInterfaceType = (ClassOrInterfaceType)node.getType();
        SymbolReference<ResolvedTypeDeclaration> typeDeclarationSymbolReference = JavaParserFactory.getContext((Node)classOrInterfaceType, this.typeSolver).solveType(classOrInterfaceType.getName().getId());
        if (!typeDeclarationSymbolReference.isSolved()) {
            throw new UnsolvedSymbolException("Solving " + node, classOrInterfaceType.getName().getId());
        }
        return new ReferenceTypeImpl(typeDeclarationSymbolReference.getCorrespondingDeclaration().asReferenceType(), this.typeSolver);
    }

    @Override
    public ResolvedType visit(ObjectCreationExpr node, Boolean solveLambdas) {
        return this.facade.convertToUsage((Type)node.getType(), (Node)node);
    }

    @Override
    public ResolvedType visit(ThisExpr node, Boolean solveLambdas) {
        if (node.getTypeName().isPresent()) {
            Optional classByName;
            String className = ((Name)node.getTypeName().get()).asString();
            SymbolReference<ResolvedReferenceTypeDeclaration> clazz = this.typeSolver.tryToSolveType(className);
            if (clazz.isSolved()) {
                return new ReferenceTypeImpl(clazz.getCorrespondingDeclaration(), this.typeSolver);
            }
            Optional cu = node.findAncestor(CompilationUnit.class);
            if (cu.isPresent() && (classByName = ((CompilationUnit)cu.get()).getClassByName(className)).isPresent()) {
                return new ReferenceTypeImpl(this.facade.getTypeDeclaration((ClassOrInterfaceDeclaration)classByName.get()), this.typeSolver);
            }
        }
        return new ReferenceTypeImpl(this.facade.getTypeDeclaration(this.facade.findContainingTypeDeclOrObjectCreationExpr((Node)node)), this.typeSolver);
    }

    @Override
    public ResolvedType visit(SuperExpr node, Boolean solveLambdas) {
        ResolvedReferenceTypeDeclaration typeOfNode = this.facade.getTypeDeclaration(this.facade.findContainingTypeDeclOrObjectCreationExpr((Node)node));
        if (typeOfNode instanceof ResolvedClassDeclaration) {
            return ((ResolvedClassDeclaration)typeOfNode).getSuperClass();
        }
        throw new UnsupportedOperationException(node.getClass().getCanonicalName());
    }

    @Override
    public ResolvedType visit(UnaryExpr node, Boolean solveLambdas) {
        switch (node.getOperator()) {
            case MINUS: 
            case PLUS: {
                return (ResolvedType)node.getExpression().accept((GenericVisitor)this, (Object)solveLambdas);
            }
            case LOGICAL_COMPLEMENT: {
                return ResolvedPrimitiveType.BOOLEAN;
            }
            case POSTFIX_DECREMENT: 
            case PREFIX_DECREMENT: 
            case POSTFIX_INCREMENT: 
            case PREFIX_INCREMENT: 
            case BITWISE_COMPLEMENT: {
                return (ResolvedType)node.getExpression().accept((GenericVisitor)this, (Object)solveLambdas);
            }
        }
        throw new UnsupportedOperationException(node.getOperator().name());
    }

    @Override
    public ResolvedType visit(VariableDeclarationExpr node, Boolean solveLambdas) {
        if (node.getVariables().size() != 1) {
            throw new UnsupportedOperationException();
        }
        return this.facade.convertToUsageVariableType((VariableDeclarator)node.getVariables().get(0));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ResolvedType visit(LambdaExpr node, Boolean solveLambdas) {
        ResolvedType actualType;
        Context ctx;
        Optional<MethodUsage> functionalMethod;
        if (!(Navigator.demandParentNode((Node)node) instanceof MethodCallExpr)) throw new UnsupportedOperationException("The type of a lambda expr depends on the position and its return value");
        MethodCallExpr callExpr = (MethodCallExpr)Navigator.demandParentNode((Node)node);
        int pos = JavaParserSymbolDeclaration.getParamPos((Node)node);
        SymbolReference<ResolvedMethodDeclaration> refMethod = this.facade.solve(callExpr);
        if (!refMethod.isSolved()) {
            throw new UnsolvedSymbolException(Navigator.demandParentNode((Node)node).toString(), callExpr.getName().getId());
        }
        Log.trace((String)"getType on lambda expr %s", (Supplier[])new Supplier[]{() -> ((ResolvedMethodDeclaration)refMethod.getCorrespondingDeclaration()).getName()});
        if (solveLambdas == false) return refMethod.getCorrespondingDeclaration().getParam(pos).getType();
        ResolvedType result = refMethod.getCorrespondingDeclaration().getParam(pos).getType();
        if (callExpr.getScope().isPresent()) {
            ResolvedType scopeType;
            Expression scope = (Expression)callExpr.getScope().get();
            boolean staticCall = false;
            if (scope instanceof NameExpr) {
                NameExpr nameExpr = (NameExpr)scope;
                try {
                    SymbolReference<ResolvedTypeDeclaration> type = JavaParserFactory.getContext((Node)nameExpr, this.typeSolver).solveType(nameExpr.getName().getId());
                    if (type.isSolved()) {
                        staticCall = true;
                    }
                }
                catch (Exception type) {
                    // empty catch block
                }
            }
            if (!staticCall && (scopeType = this.facade.getType((Node)scope)).isReferenceType()) {
                result = scopeType.asReferenceType().useThisTypeParametersOnTheGivenType(result);
            }
        }
        if (!(functionalMethod = FunctionalInterfaceLogic.getFunctionalMethod(result = JavaParserFacade.solveGenericTypes(result, ctx = JavaParserFactory.getContext((Node)node, this.typeSolver)))).isPresent()) return result;
        LambdaExpr lambdaExpr = node;
        InferenceContext lambdaCtx = new InferenceContext(MyObjectProvider.INSTANCE);
        InferenceContext funcInterfaceCtx = new InferenceContext(MyObjectProvider.INSTANCE);
        ResolvedReferenceType functionalInterfaceType = ReferenceTypeImpl.undeterminedParameters(functionalMethod.get().getDeclaration().declaringType(), this.typeSolver);
        lambdaCtx.addPair(result, (ResolvedType)functionalInterfaceType);
        if (lambdaExpr.getBody() instanceof ExpressionStmt) {
            actualType = this.facade.getType((Node)((ExpressionStmt)lambdaExpr.getBody()).getExpression());
        } else {
            if (!(lambdaExpr.getBody() instanceof BlockStmt)) throw new UnsupportedOperationException();
            BlockStmt blockStmt = (BlockStmt)lambdaExpr.getBody();
            List returnStmts = blockStmt.findAll(ReturnStmt.class);
            if (returnStmts.size() <= 0) return ResolvedVoidType.INSTANCE;
            actualType = returnStmts.stream().map(returnStmt -> returnStmt.getExpression().map(e -> this.facade.getType((Node)e)).orElse(ResolvedVoidType.INSTANCE)).filter(x -> x != null && !x.isVoid() && !x.isNull()).findFirst().orElse(ResolvedVoidType.INSTANCE);
        }
        ResolvedType formalType = functionalMethod.get().returnType();
        funcInterfaceCtx.addPair(formalType, actualType);
        ResolvedType functionalTypeWithReturn = funcInterfaceCtx.resolve(funcInterfaceCtx.addSingle((ResolvedType)functionalInterfaceType));
        if (formalType instanceof ResolvedVoidType) return result;
        lambdaCtx.addPair(result, functionalTypeWithReturn);
        return lambdaCtx.resolve(lambdaCtx.addSingle(result));
    }

    @Override
    public ResolvedType visit(MethodReferenceExpr node, Boolean solveLambdas) {
        if (Navigator.demandParentNode((Node)node) instanceof MethodCallExpr) {
            MethodCallExpr callExpr = (MethodCallExpr)Navigator.demandParentNode((Node)node);
            int pos = JavaParserSymbolDeclaration.getParamPos((Node)node);
            SymbolReference<ResolvedMethodDeclaration> refMethod = this.facade.solve(callExpr, false);
            if (!refMethod.isSolved()) {
                throw new UnsolvedSymbolException(Navigator.demandParentNode((Node)node).toString(), callExpr.getName().getId());
            }
            Log.trace((String)"getType on method reference expr %s", (Supplier[])new Supplier[]{() -> ((ResolvedMethodDeclaration)refMethod.getCorrespondingDeclaration()).getName()});
            if (solveLambdas.booleanValue()) {
                MethodUsage usage = this.facade.solveMethodAsUsage(callExpr);
                ResolvedType result = usage.getParamType(pos);
                Context ctx = JavaParserFactory.getContext((Node)node, this.typeSolver);
                if (FunctionalInterfaceLogic.getFunctionalMethod(result = JavaParserFacade.solveGenericTypes(result, ctx)).isPresent()) {
                    MethodReferenceExpr methodReferenceExpr = node;
                    ResolvedType actualType = this.facade.toMethodUsage(methodReferenceExpr).returnType();
                    ResolvedType formalType = FunctionalInterfaceLogic.getFunctionalMethod(result).get().returnType();
                    InferenceContext inferenceContext = new InferenceContext(MyObjectProvider.INSTANCE);
                    inferenceContext.addPair(formalType, actualType);
                    result = inferenceContext.resolve(inferenceContext.addSingle(result));
                }
                return result;
            }
            return refMethod.getCorrespondingDeclaration().getParam(pos).getType();
        }
        throw new UnsupportedOperationException("The type of a method reference expr depends on the position and its return value");
    }

    @Override
    public ResolvedType visit(FieldDeclaration node, Boolean solveLambdas) {
        if (node.getVariables().size() == 1) {
            return (ResolvedType)((VariableDeclarator)node.getVariables().get(0)).accept((GenericVisitor)this, (Object)solveLambdas);
        }
        throw new IllegalArgumentException("Cannot resolve the type of a field with multiple variable declarations. Pick one");
    }
}

