/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.javassistmodel;

import com.github.javaparser.ast.AccessSpecifier;
import com.github.javaparser.resolution.declarations.ResolvedFieldDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParametrizable;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.javassistmodel.JavassistFactory;
import com.github.javaparser.symbolsolver.javassistmodel.JavassistUtils;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import java.lang.reflect.Modifier;
import javassist.CtField;
import javassist.NotFoundException;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.SignatureAttribute;

public class JavassistFieldDeclaration
implements ResolvedFieldDeclaration {
    private CtField ctField;
    private TypeSolver typeSolver;

    public JavassistFieldDeclaration(CtField ctField, TypeSolver typeSolver) {
        this.ctField = ctField;
        this.typeSolver = typeSolver;
    }

    public ResolvedType getType() {
        try {
            if (this.ctField.getGenericSignature() != null && this.declaringType() instanceof ResolvedTypeParametrizable) {
                SignatureAttribute.ObjectType genericSignatureType = SignatureAttribute.toFieldSignature((String)this.ctField.getGenericSignature());
                return JavassistUtils.signatureTypeToType((SignatureAttribute.Type)genericSignatureType, this.typeSolver, (ResolvedTypeParametrizable)this.declaringType());
            }
            return JavassistFactory.typeUsageFor(this.ctField.getType(), this.typeSolver);
        }
        catch (NotFoundException | BadBytecode e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.ctField.getModifiers());
    }

    public String getName() {
        return this.ctField.getName();
    }

    public boolean isField() {
        return true;
    }

    public boolean isParameter() {
        return false;
    }

    public boolean isType() {
        return false;
    }

    public AccessSpecifier accessSpecifier() {
        return JavassistFactory.modifiersToAccessLevel(this.ctField.getModifiers());
    }

    public ResolvedTypeDeclaration declaringType() {
        return JavassistFactory.toTypeDeclaration(this.ctField.getDeclaringClass(), this.typeSolver);
    }
}

