/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.javaparsermodel.declarations;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithAnnotations;
import com.github.javaparser.ast.nodeTypes.NodeWithMembers;
import com.github.javaparser.resolution.UnsolvedSymbolException;
import com.github.javaparser.resolution.declarations.ResolvedConstructorDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeDeclaration;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFactory;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.DefaultConstructorDeclaration;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserConstructorDeclaration;
import com.github.javaparser.symbolsolver.model.resolution.SymbolReference;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

class AstResolutionUtils {
    AstResolutionUtils() {
    }

    static String containerName(Node container) {
        String packageName = AstResolutionUtils.getPackageName(container);
        String className = AstResolutionUtils.getClassName("", container);
        return packageName + (!packageName.isEmpty() && !className.isEmpty() ? "." : "") + className;
    }

    static String getPackageName(Node container) {
        if (container instanceof CompilationUnit) {
            Optional p = ((CompilationUnit)container).getPackageDeclaration();
            if (p.isPresent()) {
                return ((PackageDeclaration)p.get()).getName().toString();
            }
        } else if (container != null) {
            return AstResolutionUtils.getPackageName(container.getParentNode().orElse(null));
        }
        return "";
    }

    static String getClassName(String base, Node container) {
        if (container instanceof ClassOrInterfaceDeclaration) {
            String b = AstResolutionUtils.getClassName(base, container.getParentNode().orElse(null));
            String cn = ((ClassOrInterfaceDeclaration)container).getName().getId();
            if (b.isEmpty()) {
                return cn;
            }
            return b + "." + cn;
        }
        if (container instanceof EnumDeclaration) {
            String b = AstResolutionUtils.getClassName(base, container.getParentNode().orElse(null));
            String cn = ((EnumDeclaration)container).getName().getId();
            if (b.isEmpty()) {
                return cn;
            }
            return b + "." + cn;
        }
        if (container != null) {
            return AstResolutionUtils.getClassName(base, container.getParentNode().orElse(null));
        }
        return base;
    }

    static boolean hasDirectlyAnnotation(NodeWithAnnotations<?> nodeWithAnnotations, TypeSolver typeSolver, String canonicalName) {
        for (AnnotationExpr annotationExpr : nodeWithAnnotations.getAnnotations()) {
            SymbolReference<ResolvedTypeDeclaration> ref = JavaParserFactory.getContext((Node)annotationExpr, typeSolver).solveType(annotationExpr.getNameAsString());
            if (ref.isSolved()) {
                if (!((ResolvedTypeDeclaration)ref.getCorrespondingDeclaration()).getQualifiedName().equals(canonicalName)) continue;
                return true;
            }
            throw new UnsolvedSymbolException(annotationExpr.getName().getId());
        }
        return false;
    }

    static <N extends ResolvedReferenceTypeDeclaration> List<ResolvedConstructorDeclaration> getConstructors(NodeWithMembers<?> wrappedNode, TypeSolver typeSolver, N container) {
        List<ResolvedConstructorDeclaration> declared = wrappedNode.getConstructors().stream().map(c -> new JavaParserConstructorDeclaration<ResolvedReferenceTypeDeclaration>(container, (ConstructorDeclaration)c, typeSolver)).collect(Collectors.toList());
        if (declared.isEmpty()) {
            return ImmutableList.of(new DefaultConstructorDeclaration<N>(container));
        }
        return declared;
    }
}

