/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.reflectionmodel;

import com.github.javaparser.resolution.UnsolvedSymbolException;
import com.github.javaparser.resolution.declarations.ResolvedConstructorDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedFieldDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.javaparsermodel.LambdaArgumentTypePlaceholder;
import com.github.javaparser.symbolsolver.logic.FunctionalInterfaceLogic;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import com.github.javaparser.symbolsolver.model.typesystem.NullType;
import com.github.javaparser.symbolsolver.model.typesystem.ReferenceTypeImpl;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionClassDeclaration;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionConstructorDeclaration;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionFactory;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionFieldDeclaration;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionInterfaceDeclaration;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionMethodDeclaration;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionTypeParameter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

class ReflectionClassAdapter {
    private Class<?> clazz;
    private TypeSolver typeSolver;
    private ResolvedReferenceTypeDeclaration typeDeclaration;

    public ReflectionClassAdapter(Class<?> clazz, TypeSolver typeSolver, ResolvedReferenceTypeDeclaration typeDeclaration) {
        this.clazz = clazz;
        this.typeSolver = typeSolver;
        this.typeDeclaration = typeDeclaration;
    }

    public ReferenceTypeImpl getSuperClass() {
        if (this.clazz.getGenericSuperclass() == null) {
            return null;
        }
        Type superType = this.clazz.getGenericSuperclass();
        if (superType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)superType;
            List<ResolvedType> typeParameters = Arrays.stream(parameterizedType.getActualTypeArguments()).map(t -> ReflectionFactory.typeUsageFor(t, this.typeSolver)).collect(Collectors.toList());
            return new ReferenceTypeImpl((ResolvedReferenceTypeDeclaration)new ReflectionClassDeclaration(this.clazz.getSuperclass(), this.typeSolver), typeParameters, this.typeSolver);
        }
        return new ReferenceTypeImpl((ResolvedReferenceTypeDeclaration)new ReflectionClassDeclaration(this.clazz.getSuperclass(), this.typeSolver), this.typeSolver);
    }

    public List<ResolvedReferenceType> getInterfaces() {
        ArrayList<ResolvedReferenceType> interfaces = new ArrayList<ResolvedReferenceType>();
        for (Type superInterface : this.clazz.getGenericInterfaces()) {
            if (superInterface instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)superInterface;
                List<ResolvedType> typeParameters = Arrays.stream(parameterizedType.getActualTypeArguments()).map(t -> ReflectionFactory.typeUsageFor(t, this.typeSolver)).collect(Collectors.toList());
                interfaces.add(new ReferenceTypeImpl((ResolvedReferenceTypeDeclaration)new ReflectionInterfaceDeclaration((Class)((ParameterizedType)superInterface).getRawType(), this.typeSolver), typeParameters, this.typeSolver));
                continue;
            }
            interfaces.add(new ReferenceTypeImpl((ResolvedReferenceTypeDeclaration)new ReflectionInterfaceDeclaration((Class)superInterface, this.typeSolver), this.typeSolver));
        }
        return interfaces;
    }

    public List<ResolvedReferenceType> getAncestors() {
        LinkedList<ResolvedReferenceType> ancestors = new LinkedList<ResolvedReferenceType>();
        if (this.getSuperClass() != null) {
            ReferenceTypeImpl superClass = this.getSuperClass();
            ancestors.add(superClass);
        } else {
            ReferenceTypeImpl object = new ReferenceTypeImpl((ResolvedReferenceTypeDeclaration)new ReflectionClassDeclaration(Object.class, this.typeSolver), this.typeSolver);
            ancestors.add(object);
        }
        ancestors.addAll(this.getInterfaces());
        for (int i = 0; i < ancestors.size(); ++i) {
            ResolvedReferenceType ancestor = (ResolvedReferenceType)ancestors.get(i);
            if (!ancestor.hasName() || !ancestor.getQualifiedName().equals(Object.class.getCanonicalName())) continue;
            ancestors.remove(i);
            --i;
        }
        return ancestors;
    }

    public ResolvedFieldDeclaration getField(String name) {
        for (Field field : this.clazz.getDeclaredFields()) {
            if (!field.getName().equals(name)) continue;
            return new ReflectionFieldDeclaration(field, this.typeSolver);
        }
        for (ResolvedReferenceType ancestor : this.typeDeclaration.getAllAncestors()) {
            if (!ancestor.getTypeDeclaration().hasField(name)) continue;
            ReflectionFieldDeclaration reflectionFieldDeclaration = (ReflectionFieldDeclaration)ancestor.getTypeDeclaration().getField(name);
            return reflectionFieldDeclaration.replaceType((ResolvedType)ancestor.getFieldType(name).get());
        }
        throw new UnsolvedSymbolException(name, "Field in " + this);
    }

    public boolean hasField(String name) {
        for (Field field : this.clazz.getDeclaredFields()) {
            if (!field.getName().equals(name)) continue;
            return true;
        }
        for (ResolvedReferenceType ancestor : this.typeDeclaration.getAllAncestors()) {
            if (!ancestor.getTypeDeclaration().hasField(name)) continue;
            return true;
        }
        return false;
    }

    public List<ResolvedFieldDeclaration> getAllFields() {
        ArrayList<ResolvedFieldDeclaration> fields = new ArrayList<ResolvedFieldDeclaration>();
        for (Field field : this.clazz.getDeclaredFields()) {
            fields.add(new ReflectionFieldDeclaration(field, this.typeSolver));
        }
        for (ResolvedReferenceType ancestor : this.typeDeclaration.getAllAncestors()) {
            fields.addAll(ancestor.getTypeDeclaration().getAllFields());
        }
        return fields;
    }

    public Set<ResolvedMethodDeclaration> getDeclaredMethods() {
        return Arrays.stream(this.clazz.getDeclaredMethods()).filter(m -> !m.isSynthetic() && !m.isBridge()).map(m -> new ReflectionMethodDeclaration((Method)m, this.typeSolver)).collect(Collectors.toSet());
    }

    public List<ResolvedTypeParameterDeclaration> getTypeParameters() {
        ArrayList<ResolvedTypeParameterDeclaration> params = new ArrayList<ResolvedTypeParameterDeclaration>();
        for (TypeVariable<Class<?>> tv : this.clazz.getTypeParameters()) {
            params.add(new ReflectionTypeParameter(tv, true, this.typeSolver));
        }
        return params;
    }

    public boolean isAssignableBy(ResolvedType type) {
        if (type instanceof NullType) {
            return true;
        }
        if (type instanceof LambdaArgumentTypePlaceholder) {
            return this.isFunctionalInterface();
        }
        if (type.isArray()) {
            return false;
        }
        if (type.isPrimitive()) {
            return false;
        }
        if (type.describe().equals(this.typeDeclaration.getQualifiedName())) {
            return true;
        }
        if (type instanceof ReferenceTypeImpl) {
            ReferenceTypeImpl otherTypeDeclaration = (ReferenceTypeImpl)type;
            return otherTypeDeclaration.getTypeDeclaration().canBeAssignedTo(this.typeDeclaration);
        }
        return false;
    }

    public boolean hasDirectlyAnnotation(String canonicalName) {
        for (Annotation a : this.clazz.getDeclaredAnnotations()) {
            if (!a.annotationType().getCanonicalName().equals(canonicalName)) continue;
            return true;
        }
        return false;
    }

    private final boolean isFunctionalInterface() {
        return FunctionalInterfaceLogic.getFunctionalMethod((ResolvedReferenceTypeDeclaration)this.typeDeclaration).isPresent();
    }

    public List<ResolvedConstructorDeclaration> getConstructors() {
        return Arrays.stream(this.clazz.getDeclaredConstructors()).filter(m -> !m.isSynthetic()).map(m -> new ReflectionConstructorDeclaration((Constructor<?>)m, this.typeSolver)).collect(Collectors.toList());
    }

    public Optional<ResolvedReferenceTypeDeclaration> containerType() {
        Class<?> declaringClass = this.clazz.getDeclaringClass();
        return declaringClass == null ? Optional.empty() : Optional.of(ReflectionFactory.typeDeclarationFor(declaringClass, this.typeSolver));
    }
}

