/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.javassistmodel;

import com.github.javaparser.resolution.MethodUsage;
import com.github.javaparser.resolution.UnsolvedSymbolException;
import com.github.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParametrizable;
import com.github.javaparser.resolution.types.ResolvedArrayType;
import com.github.javaparser.resolution.types.ResolvedPrimitiveType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.resolution.types.ResolvedTypeVariable;
import com.github.javaparser.resolution.types.ResolvedVoidType;
import com.github.javaparser.resolution.types.ResolvedWildcard;
import com.github.javaparser.symbolsolver.javassistmodel.JavassistMethodDeclaration;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import com.github.javaparser.symbolsolver.model.typesystem.ReferenceTypeImpl;
import com.github.javaparser.symbolsolver.resolution.MethodResolutionLogic;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.LocalVariableAttribute;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.SignatureAttribute;

class JavassistUtils {
    JavassistUtils() {
    }

    static Optional<MethodUsage> getMethodUsage(CtClass ctClass, String name, List<ResolvedType> argumentsTypes, TypeSolver typeSolver, List<ResolvedTypeParameterDeclaration> typeParameters, List<ResolvedType> typeParameterValues) {
        ArrayList<MethodUsage> methods = new ArrayList<MethodUsage>();
        CtMethod[] ctMethodArray = ctClass.getDeclaredMethods();
        int n = ctMethodArray.length;
        for (int i = 0; i < n; ++i) {
            CtMethod method = ctMethodArray[i];
            if (!method.getName().equals(name) || (method.getMethodInfo().getAccessFlags() & 0x40) != 0 || (method.getMethodInfo().getAccessFlags() & 0x1000) != 0) continue;
            MethodUsage methodUsage = new MethodUsage((ResolvedMethodDeclaration)new JavassistMethodDeclaration(method, typeSolver));
            for (int i2 = 0; i2 < typeParameters.size() && i2 < typeParameterValues.size(); ++i2) {
                ResolvedTypeParameterDeclaration tpToReplace = typeParameters.get(i2);
                ResolvedType newValue = typeParameterValues.get(i2);
                methodUsage = methodUsage.replaceTypeParameter(tpToReplace, newValue);
            }
            methods.add(methodUsage);
        }
        try {
            Optional<MethodUsage> ref;
            CtClass superClass = ctClass.getSuperclass();
            if (superClass != null && (ref = JavassistUtils.getMethodUsage(superClass, name, argumentsTypes, typeSolver, typeParameters, typeParameterValues)).isPresent()) {
                methods.add(ref.get());
            }
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        try {
            for (CtClass interfaze : ctClass.getInterfaces()) {
                Optional<MethodUsage> ref = JavassistUtils.getMethodUsage(interfaze, name, argumentsTypes, typeSolver, typeParameters, typeParameterValues);
                if (!ref.isPresent()) continue;
                methods.add(ref.get());
            }
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        return MethodResolutionLogic.findMostApplicableUsage(methods, name, argumentsTypes, typeSolver);
    }

    static ResolvedType signatureTypeToType(SignatureAttribute.Type signatureType, TypeSolver typeSolver, ResolvedTypeParametrizable typeParametrizable) {
        if (signatureType instanceof SignatureAttribute.ClassType) {
            SignatureAttribute.ClassType classType = (SignatureAttribute.ClassType)signatureType;
            List<ResolvedType> typeArguments = classType.getTypeArguments() == null ? Collections.emptyList() : Arrays.stream(classType.getTypeArguments()).map(ta -> JavassistUtils.typeArgumentToType(ta, typeSolver, typeParametrizable)).collect(Collectors.toList());
            ResolvedReferenceTypeDeclaration typeDeclaration = typeSolver.solveType(JavassistUtils.removeTypeArguments(JavassistUtils.internalNameToCanonicalName(JavassistUtils.getTypeName(classType))));
            return new ReferenceTypeImpl(typeDeclaration, typeArguments, typeSolver);
        }
        if (signatureType instanceof SignatureAttribute.TypeVariable) {
            SignatureAttribute.TypeVariable typeVariableSignature = (SignatureAttribute.TypeVariable)signatureType;
            Optional typeParameterDeclarationOpt = typeParametrizable.findTypeParameter(typeVariableSignature.getName());
            if (!typeParameterDeclarationOpt.isPresent()) {
                throw new UnsolvedSymbolException("Unable to solve TypeVariable " + typeVariableSignature);
            }
            ResolvedTypeParameterDeclaration typeParameterDeclaration = (ResolvedTypeParameterDeclaration)typeParameterDeclarationOpt.get();
            return new ResolvedTypeVariable(typeParameterDeclaration);
        }
        if (signatureType instanceof SignatureAttribute.ArrayType) {
            SignatureAttribute.ArrayType arrayType = (SignatureAttribute.ArrayType)signatureType;
            return new ResolvedArrayType(JavassistUtils.signatureTypeToType(arrayType.getComponentType(), typeSolver, typeParametrizable));
        }
        if (signatureType instanceof SignatureAttribute.BaseType) {
            SignatureAttribute.BaseType baseType = (SignatureAttribute.BaseType)signatureType;
            if (baseType.toString().equals("void")) {
                return ResolvedVoidType.INSTANCE;
            }
            return ResolvedPrimitiveType.byName((String)baseType.toString());
        }
        throw new RuntimeException(signatureType.getClass().getCanonicalName());
    }

    private static String getTypeName(SignatureAttribute.ClassType classType) {
        SignatureAttribute.ClassType declaringClass = classType.getDeclaringClass();
        return declaringClass == null ? classType.getName() : JavassistUtils.getTypeName(declaringClass) + "." + classType.getName();
    }

    private static String removeTypeArguments(String typeName) {
        if (typeName.contains("<")) {
            return typeName.substring(0, typeName.indexOf(60));
        }
        return typeName;
    }

    static String internalNameToCanonicalName(String typeName) {
        return typeName.replaceAll("\\$", ".");
    }

    private static ResolvedType objectTypeArgumentToType(SignatureAttribute.ObjectType typeArgument, TypeSolver typeSolver, ResolvedTypeParametrizable typeParametrizable) {
        if (typeArgument instanceof SignatureAttribute.ClassType) {
            return JavassistUtils.signatureTypeToType((SignatureAttribute.Type)typeArgument, typeSolver, typeParametrizable);
        }
        if (typeArgument instanceof SignatureAttribute.ArrayType) {
            return JavassistUtils.signatureTypeToType(((SignatureAttribute.ArrayType)typeArgument).getComponentType(), typeSolver, typeParametrizable);
        }
        String typeName = typeArgument.jvmTypeName();
        return JavassistUtils.getGenericParameterByName(typeName, typeParametrizable, typeSolver);
    }

    private static ResolvedType getGenericParameterByName(String typeName, ResolvedTypeParametrizable typeParametrizable, TypeSolver typeSolver) {
        Optional<ResolvedType> type = typeParametrizable.findTypeParameter(typeName).map(ResolvedTypeVariable::new);
        return type.orElseGet(() -> new ReferenceTypeImpl(typeSolver.solveType(JavassistUtils.removeTypeArguments(JavassistUtils.internalNameToCanonicalName(typeName))), typeSolver));
    }

    private static ResolvedType typeArgumentToType(SignatureAttribute.TypeArgument typeArgument, TypeSolver typeSolver, ResolvedTypeParametrizable typeParametrizable) {
        if (typeArgument.isWildcard()) {
            if (typeArgument.getType() == null) {
                return ResolvedWildcard.UNBOUNDED;
            }
            if (typeArgument.getKind() == '+') {
                return ResolvedWildcard.extendsBound((ResolvedType)JavassistUtils.objectTypeArgumentToType(typeArgument.getType(), typeSolver, typeParametrizable));
            }
            if (typeArgument.getKind() == '-') {
                return ResolvedWildcard.superBound((ResolvedType)JavassistUtils.objectTypeArgumentToType(typeArgument.getType(), typeSolver, typeParametrizable));
            }
            throw new UnsupportedOperationException();
        }
        return JavassistUtils.objectTypeArgumentToType(typeArgument.getType(), typeSolver, typeParametrizable);
    }

    static Optional<String> extractParameterName(CtBehavior method, int paramNumber) {
        LocalVariableAttribute attr;
        MethodInfo methodInfo = method.getMethodInfo();
        CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
        if (codeAttribute != null && (attr = (LocalVariableAttribute)codeAttribute.getAttribute("LocalVariableTable")) != null) {
            int pos = Modifier.isStatic((int)method.getModifiers()) ? 0 : 1;
            return Optional.ofNullable(attr.variableName(paramNumber + pos));
        }
        return Optional.empty();
    }
}

