/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.javassistmodel;

import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedClassDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedConstructorDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedParameterDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParametrizable;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.javassistmodel.JavassistClassDeclaration;
import com.github.javaparser.symbolsolver.javassistmodel.JavassistFactory;
import com.github.javaparser.symbolsolver.javassistmodel.JavassistParameterDeclaration;
import com.github.javaparser.symbolsolver.javassistmodel.JavassistTypeParameter;
import com.github.javaparser.symbolsolver.javassistmodel.JavassistUtils;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javassist.CtBehavior;
import javassist.CtConstructor;
import javassist.NotFoundException;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.SignatureAttribute;

public class JavassistConstructorDeclaration
implements ResolvedConstructorDeclaration {
    private final CtConstructor ctConstructor;
    private final TypeSolver typeSolver;

    public JavassistConstructorDeclaration(CtConstructor ctConstructor, TypeSolver typeSolver) {
        this.ctConstructor = ctConstructor;
        this.typeSolver = typeSolver;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{ctConstructor=" + this.ctConstructor.getName() + ", typeSolver=" + this.typeSolver + '}';
    }

    public String getName() {
        return this.ctConstructor.getName();
    }

    public boolean isField() {
        return false;
    }

    public boolean isParameter() {
        return false;
    }

    public boolean isType() {
        return false;
    }

    public ResolvedClassDeclaration declaringType() {
        return new JavassistClassDeclaration(this.ctConstructor.getDeclaringClass(), this.typeSolver);
    }

    public int getNumberOfParams() {
        try {
            return this.ctConstructor.getParameterTypes().length;
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public ResolvedParameterDeclaration getParam(int i) {
        try {
            boolean variadic = false;
            if ((this.ctConstructor.getModifiers() & 0x80) > 0) {
                variadic = i == this.ctConstructor.getParameterTypes().length - 1;
            }
            Optional<String> paramName = JavassistUtils.extractParameterName((CtBehavior)this.ctConstructor, i);
            if (this.ctConstructor.getGenericSignature() != null) {
                SignatureAttribute.MethodSignature methodSignature = SignatureAttribute.toMethodSignature((String)this.ctConstructor.getGenericSignature());
                SignatureAttribute.Type signatureType = methodSignature.getParameterTypes()[i];
                return new JavassistParameterDeclaration(JavassistUtils.signatureTypeToType(signatureType, this.typeSolver, (ResolvedTypeParametrizable)this), this.typeSolver, variadic, (String)paramName.orElse(null));
            }
            return new JavassistParameterDeclaration(this.ctConstructor.getParameterTypes()[i], this.typeSolver, variadic, (String)paramName.orElse(null));
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (BadBytecode badBytecode) {
            throw new RuntimeException(badBytecode);
        }
    }

    public List<ResolvedTypeParameterDeclaration> getTypeParameters() {
        try {
            if (this.ctConstructor.getGenericSignature() == null) {
                return Collections.emptyList();
            }
            SignatureAttribute.MethodSignature methodSignature = SignatureAttribute.toMethodSignature((String)this.ctConstructor.getGenericSignature());
            return Arrays.stream(methodSignature.getTypeParameters()).map(jasTp -> new JavassistTypeParameter((SignatureAttribute.TypeParameter)jasTp, (ResolvedTypeParametrizable)this, this.typeSolver)).collect(Collectors.toList());
        }
        catch (BadBytecode badBytecode) {
            throw new RuntimeException(badBytecode);
        }
    }

    public Modifier.Keyword accessSpecifier() {
        return JavassistFactory.modifiersToAccessLevel(this.ctConstructor.getModifiers());
    }

    public int getNumberOfSpecifiedExceptions() {
        try {
            return this.ctConstructor.getExceptionTypes().length;
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public ResolvedType getSpecifiedException(int index) {
        if (index < 0 || index >= this.getNumberOfSpecifiedExceptions()) {
            throw new IllegalArgumentException(String.format("No exception with index %d. Number of exceptions: %d", index, this.getNumberOfSpecifiedExceptions()));
        }
        try {
            return JavassistFactory.typeUsageFor(this.ctConstructor.getExceptionTypes()[index], this.typeSolver);
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public Optional<ConstructorDeclaration> toAst() {
        return Optional.empty();
    }
}

