/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.javaparsermodel;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.DataKey;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.MethodReferenceExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.expr.ThisExpr;
import com.github.javaparser.ast.expr.TypeExpr;
import com.github.javaparser.ast.stmt.ExplicitConstructorInvocationStmt;
import com.github.javaparser.ast.type.ArrayType;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.PrimitiveType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.type.UnionType;
import com.github.javaparser.ast.type.VarType;
import com.github.javaparser.ast.type.VoidType;
import com.github.javaparser.ast.type.WildcardType;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.resolution.MethodUsage;
import com.github.javaparser.resolution.UnsolvedSymbolException;
import com.github.javaparser.resolution.declarations.ResolvedAnnotationDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedClassDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedConstructorDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedValueDeclaration;
import com.github.javaparser.resolution.types.ResolvedArrayType;
import com.github.javaparser.resolution.types.ResolvedPrimitiveType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.resolution.types.ResolvedTypeVariable;
import com.github.javaparser.resolution.types.ResolvedUnionType;
import com.github.javaparser.resolution.types.ResolvedVoidType;
import com.github.javaparser.resolution.types.ResolvedWildcard;
import com.github.javaparser.symbolsolver.core.resolution.Context;
import com.github.javaparser.symbolsolver.javaparser.Navigator;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFactory;
import com.github.javaparser.symbolsolver.javaparsermodel.LambdaArgumentTypePlaceholder;
import com.github.javaparser.symbolsolver.javaparsermodel.TypeExtractor;
import com.github.javaparser.symbolsolver.javaparsermodel.contexts.FieldAccessContext;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserAnonymousClassDeclaration;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserEnumDeclaration;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserTypeVariableDeclaration;
import com.github.javaparser.symbolsolver.model.resolution.SymbolReference;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import com.github.javaparser.symbolsolver.model.typesystem.ReferenceTypeImpl;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionClassDeclaration;
import com.github.javaparser.symbolsolver.resolution.ConstructorResolutionLogic;
import com.github.javaparser.symbolsolver.resolution.SymbolSolver;
import com.github.javaparser.utils.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.stream.Collectors;

public class JavaParserFacade {
    private static final DataKey<ResolvedType> TYPE_WITH_LAMBDAS_RESOLVED = new DataKey<ResolvedType>(){};
    private static final DataKey<ResolvedType> TYPE_WITHOUT_LAMBDAS_RESOLVED = new DataKey<ResolvedType>(){};
    private static final Map<TypeSolver, JavaParserFacade> instances = new WeakHashMap<TypeSolver, JavaParserFacade>();
    private final TypeSolver typeSolver;
    private final TypeExtractor typeExtractor;
    private final SymbolSolver symbolSolver;

    private JavaParserFacade(TypeSolver typeSolver) {
        this.typeSolver = typeSolver.getRoot();
        this.symbolSolver = new SymbolSolver(typeSolver);
        this.typeExtractor = new TypeExtractor(typeSolver, this);
    }

    public TypeSolver getTypeSolver() {
        return this.typeSolver;
    }

    public SymbolSolver getSymbolSolver() {
        return this.symbolSolver;
    }

    public static JavaParserFacade get(TypeSolver typeSolver) {
        return instances.computeIfAbsent(typeSolver, JavaParserFacade::new);
    }

    public static void clearInstances() {
        instances.clear();
    }

    protected static ResolvedType solveGenericTypes(ResolvedType type, Context context) {
        if (type.isTypeVariable()) {
            return context.solveGenericType(type.describe()).orElse(type);
        }
        if (type.isWildcard() && (type.asWildcard().isExtends() || type.asWildcard().isSuper())) {
            ResolvedWildcard wildcardUsage = type.asWildcard();
            ResolvedType boundResolved = JavaParserFacade.solveGenericTypes(wildcardUsage.getBoundedType(), context);
            if (wildcardUsage.isExtends()) {
                return ResolvedWildcard.extendsBound((ResolvedType)boundResolved);
            }
            return ResolvedWildcard.superBound((ResolvedType)boundResolved);
        }
        return type;
    }

    public SymbolReference<? extends ResolvedValueDeclaration> solve(NameExpr nameExpr) {
        return this.symbolSolver.solveSymbol(nameExpr.getName().getId(), (Node)nameExpr);
    }

    public SymbolReference<? extends ResolvedValueDeclaration> solve(SimpleName nameExpr) {
        return this.symbolSolver.solveSymbol(nameExpr.getId(), (Node)nameExpr);
    }

    public SymbolReference<? extends ResolvedValueDeclaration> solve(Expression expr) {
        return expr.toNameExpr().map(this::solve).orElseThrow(() -> new IllegalArgumentException(expr.getClass().getCanonicalName()));
    }

    public SymbolReference<ResolvedMethodDeclaration> solve(MethodCallExpr methodCallExpr) {
        return this.solve(methodCallExpr, true);
    }

    public SymbolReference<ResolvedConstructorDeclaration> solve(ObjectCreationExpr objectCreationExpr) {
        return this.solve(objectCreationExpr, true);
    }

    public SymbolReference<ResolvedConstructorDeclaration> solve(ExplicitConstructorInvocationStmt explicitConstructorInvocationStmt) {
        return this.solve(explicitConstructorInvocationStmt, true);
    }

    public SymbolReference<ResolvedConstructorDeclaration> solve(ExplicitConstructorInvocationStmt explicitConstructorInvocationStmt, boolean solveLambdas) {
        LinkedList<ResolvedType> argumentTypes = new LinkedList<ResolvedType>();
        LinkedList<LambdaArgumentTypePlaceholder> placeholders = new LinkedList<LambdaArgumentTypePlaceholder>();
        this.solveArguments((Node)explicitConstructorInvocationStmt, (NodeList<Expression>)explicitConstructorInvocationStmt.getArguments(), solveLambdas, argumentTypes, placeholders);
        Optional optAncestor = explicitConstructorInvocationStmt.findAncestor(ClassOrInterfaceDeclaration.class);
        if (!optAncestor.isPresent()) {
            return SymbolReference.unsolved(ResolvedConstructorDeclaration.class);
        }
        ClassOrInterfaceDeclaration classNode = (ClassOrInterfaceDeclaration)optAncestor.get();
        ResolvedTypeDeclaration typeDecl = null;
        if (!explicitConstructorInvocationStmt.isThis()) {
            ResolvedType classDecl = JavaParserFacade.get(this.typeSolver).convert((Type)classNode.getExtendedTypes(0), (Node)classNode);
            if (classDecl.isReferenceType()) {
                typeDecl = classDecl.asReferenceType().getTypeDeclaration();
            }
        } else {
            SymbolReference<ResolvedTypeDeclaration> sr = JavaParserFactory.getContext((Node)classNode, this.typeSolver).solveType(classNode.getNameAsString());
            if (sr.isSolved()) {
                typeDecl = (ResolvedTypeDeclaration)sr.getCorrespondingDeclaration();
            }
        }
        if (typeDecl == null) {
            return SymbolReference.unsolved(ResolvedConstructorDeclaration.class);
        }
        SymbolReference<ResolvedConstructorDeclaration> res = ConstructorResolutionLogic.findMostApplicable(((ResolvedClassDeclaration)typeDecl).getConstructors(), argumentTypes, this.typeSolver);
        for (LambdaArgumentTypePlaceholder placeholder : placeholders) {
            placeholder.setMethod(res);
        }
        return res;
    }

    public SymbolReference<ResolvedTypeDeclaration> solve(ThisExpr node) {
        if (node.getClassExpr().isPresent()) {
            Optional classByName;
            String className = ((Expression)node.getClassExpr().get()).toString();
            SymbolReference clazz = this.typeSolver.tryToSolveType(className);
            if (clazz.isSolved()) {
                return SymbolReference.solved((ResolvedDeclaration)((ResolvedReferenceTypeDeclaration)clazz.getCorrespondingDeclaration()));
            }
            Optional cu = node.findAncestor(CompilationUnit.class);
            if (cu.isPresent() && (classByName = ((CompilationUnit)cu.get()).getClassByName(className)).isPresent()) {
                return SymbolReference.solved((ResolvedDeclaration)this.getTypeDeclaration((ClassOrInterfaceDeclaration)classByName.get()));
            }
        }
        return SymbolReference.solved((ResolvedDeclaration)this.getTypeDeclaration(this.findContainingTypeDeclOrObjectCreationExpr((Node)node)));
    }

    public SymbolReference<ResolvedConstructorDeclaration> solve(ObjectCreationExpr objectCreationExpr, boolean solveLambdas) {
        LinkedList<ResolvedType> argumentTypes = new LinkedList<ResolvedType>();
        LinkedList<LambdaArgumentTypePlaceholder> placeholders = new LinkedList<LambdaArgumentTypePlaceholder>();
        this.solveArguments((Node)objectCreationExpr, (NodeList<Expression>)objectCreationExpr.getArguments(), solveLambdas, argumentTypes, placeholders);
        ResolvedType classDecl = JavaParserFacade.get(this.typeSolver).convert((Type)objectCreationExpr.getType(), (Node)objectCreationExpr);
        if (!classDecl.isReferenceType()) {
            return SymbolReference.unsolved(ResolvedConstructorDeclaration.class);
        }
        SymbolReference<ResolvedConstructorDeclaration> res = ConstructorResolutionLogic.findMostApplicable(classDecl.asReferenceType().getTypeDeclaration().getConstructors(), argumentTypes, this.typeSolver);
        for (LambdaArgumentTypePlaceholder placeholder : placeholders) {
            placeholder.setMethod(res);
        }
        return res;
    }

    private void solveArguments(Node node, NodeList<Expression> args, boolean solveLambdas, List<ResolvedType> argumentTypes, List<LambdaArgumentTypePlaceholder> placeholders) {
        int i = 0;
        for (Expression parameterValue : args) {
            if (parameterValue instanceof LambdaExpr || parameterValue instanceof MethodReferenceExpr) {
                LambdaArgumentTypePlaceholder placeholder = new LambdaArgumentTypePlaceholder(i);
                argumentTypes.add(placeholder);
                placeholders.add(placeholder);
            } else {
                try {
                    argumentTypes.add(JavaParserFacade.get(this.typeSolver).getType((Node)parameterValue, solveLambdas));
                }
                catch (UnsolvedSymbolException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(String.format("Unable to calculate the type of a parameter of a method call. Method call: %s, Parameter: %s", node, parameterValue), e);
                }
            }
            ++i;
        }
    }

    public SymbolReference<ResolvedMethodDeclaration> solve(MethodCallExpr methodCallExpr, boolean solveLambdas) {
        LinkedList<ResolvedType> argumentTypes = new LinkedList<ResolvedType>();
        LinkedList<LambdaArgumentTypePlaceholder> placeholders = new LinkedList<LambdaArgumentTypePlaceholder>();
        this.solveArguments((Node)methodCallExpr, (NodeList<Expression>)methodCallExpr.getArguments(), solveLambdas, argumentTypes, placeholders);
        SymbolReference<ResolvedMethodDeclaration> res = JavaParserFactory.getContext((Node)methodCallExpr, this.typeSolver).solveMethod(methodCallExpr.getName().getId(), argumentTypes, false);
        for (LambdaArgumentTypePlaceholder placeholder : placeholders) {
            placeholder.setMethod(res);
        }
        return res;
    }

    public SymbolReference<ResolvedAnnotationDeclaration> solve(AnnotationExpr annotationExpr) {
        Context context = JavaParserFactory.getContext((Node)annotationExpr, this.typeSolver);
        SymbolReference<ResolvedTypeDeclaration> typeDeclarationSymbolReference = context.solveType(annotationExpr.getNameAsString());
        if (typeDeclarationSymbolReference.isSolved()) {
            ResolvedAnnotationDeclaration annotationDeclaration = (ResolvedAnnotationDeclaration)typeDeclarationSymbolReference.getCorrespondingDeclaration();
            return SymbolReference.solved((ResolvedDeclaration)annotationDeclaration);
        }
        return SymbolReference.unsolved(ResolvedAnnotationDeclaration.class);
    }

    public SymbolReference<ResolvedValueDeclaration> solve(FieldAccessExpr fieldAccessExpr) {
        return ((FieldAccessContext)JavaParserFactory.getContext((Node)fieldAccessExpr, this.typeSolver)).solveField(fieldAccessExpr.getName().getId());
    }

    public ResolvedType getType(Node node) {
        try {
            return this.getType(node, true);
        }
        catch (UnsolvedSymbolException e) {
            if (node instanceof NameExpr) {
                NameExpr nameExpr = (NameExpr)node;
                SymbolReference<ResolvedTypeDeclaration> typeDeclaration = JavaParserFactory.getContext(node, this.typeSolver).solveType(nameExpr.getNameAsString());
                if (typeDeclaration.isSolved() && typeDeclaration.getCorrespondingDeclaration() instanceof ResolvedReferenceTypeDeclaration) {
                    ResolvedReferenceTypeDeclaration resolvedReferenceTypeDeclaration = (ResolvedReferenceTypeDeclaration)typeDeclaration.getCorrespondingDeclaration();
                    return ReferenceTypeImpl.undeterminedParameters(resolvedReferenceTypeDeclaration, this.typeSolver);
                }
            }
            throw e;
        }
    }

    public ResolvedType getType(Node node, boolean solveLambdas) {
        if (solveLambdas) {
            if (!node.containsData(TYPE_WITH_LAMBDAS_RESOLVED)) {
                ResolvedType res = this.getTypeConcrete(node, solveLambdas);
                node.setData(TYPE_WITH_LAMBDAS_RESOLVED, (Object)res);
                boolean secondPassNecessary = false;
                if (node instanceof MethodCallExpr) {
                    MethodCallExpr methodCallExpr = (MethodCallExpr)node;
                    for (Node arg : methodCallExpr.getArguments()) {
                        if (arg.containsData(TYPE_WITH_LAMBDAS_RESOLVED)) continue;
                        this.getType(arg, true);
                        secondPassNecessary = true;
                    }
                }
                if (secondPassNecessary) {
                    node.removeData(TYPE_WITH_LAMBDAS_RESOLVED);
                    ResolvedType type = this.getType(node, true);
                    node.setData(TYPE_WITH_LAMBDAS_RESOLVED, (Object)type);
                }
                Log.trace((String)"getType on %s  -> %s", (Object[])new Object[]{node, res});
            }
            return (ResolvedType)node.getData(TYPE_WITH_LAMBDAS_RESOLVED);
        }
        Optional<ResolvedType> res = this.find(TYPE_WITH_LAMBDAS_RESOLVED, node);
        if (res.isPresent()) {
            return res.get();
        }
        res = this.find(TYPE_WITHOUT_LAMBDAS_RESOLVED, node);
        if (!res.isPresent()) {
            ResolvedType resType = this.getTypeConcrete(node, solveLambdas);
            node.setData(TYPE_WITHOUT_LAMBDAS_RESOLVED, (Object)resType);
            Log.trace((String)"getType on %s (no solveLambdas) -> %s", (Object[])new Object[]{node, res});
            return resType;
        }
        return res.get();
    }

    private Optional<ResolvedType> find(DataKey<ResolvedType> dataKey, Node node) {
        if (node.containsData(dataKey)) {
            return Optional.of((ResolvedType)node.getData(dataKey));
        }
        return Optional.empty();
    }

    protected MethodUsage toMethodUsage(MethodReferenceExpr methodReferenceExpr) {
        if (!(methodReferenceExpr.getScope() instanceof TypeExpr)) {
            throw new UnsupportedOperationException();
        }
        TypeExpr typeExpr = (TypeExpr)methodReferenceExpr.getScope();
        if (!(typeExpr.getType() instanceof ClassOrInterfaceType)) {
            throw new UnsupportedOperationException(typeExpr.getType().getClass().getCanonicalName());
        }
        ClassOrInterfaceType classOrInterfaceType = (ClassOrInterfaceType)typeExpr.getType();
        SymbolReference<ResolvedTypeDeclaration> typeDeclarationSymbolReference = JavaParserFactory.getContext((Node)classOrInterfaceType, this.typeSolver).solveType(classOrInterfaceType.getName().getId());
        if (!typeDeclarationSymbolReference.isSolved()) {
            throw new UnsupportedOperationException();
        }
        List methodUsages = ((ResolvedReferenceTypeDeclaration)typeDeclarationSymbolReference.getCorrespondingDeclaration()).getAllMethods().stream().filter(it -> it.getName().equals(methodReferenceExpr.getIdentifier())).collect(Collectors.toList());
        switch (methodUsages.size()) {
            case 0: {
                throw new UnsupportedOperationException();
            }
            case 1: {
                return (MethodUsage)methodUsages.get(0);
            }
        }
        throw new UnsupportedOperationException();
    }

    protected ResolvedType getBinaryTypeConcrete(Node left, Node right, boolean solveLambdas, BinaryExpr.Operator operator) {
        boolean isRightNumeric;
        ResolvedType leftType = this.getTypeConcrete(left, solveLambdas);
        ResolvedType rightType = this.getTypeConcrete(right, solveLambdas);
        if (operator == BinaryExpr.Operator.PLUS) {
            boolean isRightString;
            boolean isLeftString = leftType.isReferenceType() && leftType.asReferenceType().getQualifiedName().equals(String.class.getCanonicalName());
            boolean bl = isRightString = rightType.isReferenceType() && rightType.asReferenceType().getQualifiedName().equals(String.class.getCanonicalName());
            if (isLeftString || isRightString) {
                return isLeftString ? leftType : rightType;
            }
        }
        boolean isLeftNumeric = leftType.isPrimitive() && leftType.asPrimitive().isNumeric();
        boolean bl = isRightNumeric = rightType.isPrimitive() && rightType.asPrimitive().isNumeric();
        if (isLeftNumeric && isRightNumeric) {
            if (leftType.asPrimitive().equals((Object)ResolvedPrimitiveType.DOUBLE) || rightType.asPrimitive().equals((Object)ResolvedPrimitiveType.DOUBLE)) {
                return ResolvedPrimitiveType.DOUBLE;
            }
            if (leftType.asPrimitive().equals((Object)ResolvedPrimitiveType.FLOAT) || rightType.asPrimitive().equals((Object)ResolvedPrimitiveType.FLOAT)) {
                return ResolvedPrimitiveType.FLOAT;
            }
            if (leftType.asPrimitive().equals((Object)ResolvedPrimitiveType.LONG) || rightType.asPrimitive().equals((Object)ResolvedPrimitiveType.LONG)) {
                return ResolvedPrimitiveType.LONG;
            }
            return ResolvedPrimitiveType.INT;
        }
        if (rightType.isAssignableBy(leftType)) {
            return rightType;
        }
        return leftType;
    }

    private ResolvedType getTypeConcrete(Node node, boolean solveLambdas) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        return (ResolvedType)node.accept((GenericVisitor)this.typeExtractor, (Object)solveLambdas);
    }

    protected TypeDeclaration<?> findContainingTypeDecl(Node node) {
        if (node instanceof ClassOrInterfaceDeclaration) {
            return (ClassOrInterfaceDeclaration)node;
        }
        if (node instanceof EnumDeclaration) {
            return (EnumDeclaration)node;
        }
        return this.findContainingTypeDecl(Navigator.requireParentNode(node));
    }

    protected Node findContainingTypeDeclOrObjectCreationExpr(Node node) {
        if (node instanceof ClassOrInterfaceDeclaration) {
            return node;
        }
        if (node instanceof EnumDeclaration) {
            return node;
        }
        Node parent = Navigator.requireParentNode(node);
        if (parent instanceof ObjectCreationExpr && !((ObjectCreationExpr)parent).getArguments().contains((Object)node)) {
            return parent;
        }
        return this.findContainingTypeDeclOrObjectCreationExpr(parent);
    }

    public ResolvedType convertToUsageVariableType(VariableDeclarator var) {
        return JavaParserFacade.get(this.typeSolver).convertToUsage(var.getType(), (Node)var);
    }

    public ResolvedType convertToUsage(Type type, Node context) {
        if (type.isUnknownType()) {
            throw new IllegalArgumentException("Inferred lambda parameter type");
        }
        return this.convertToUsage(type, JavaParserFactory.getContext(context, this.typeSolver));
    }

    public ResolvedType convertToUsage(Type type) {
        return this.convertToUsage(type, (Node)type);
    }

    private String qName(ClassOrInterfaceType classOrInterfaceType) {
        String name = classOrInterfaceType.getName().getId();
        if (classOrInterfaceType.getScope().isPresent()) {
            return this.qName((ClassOrInterfaceType)classOrInterfaceType.getScope().get()) + "." + name;
        }
        return name;
    }

    protected ResolvedType convertToUsage(Type type, Context context) {
        if (context == null) {
            throw new NullPointerException("Context should not be null");
        }
        if (type instanceof ClassOrInterfaceType) {
            ClassOrInterfaceType classOrInterfaceType = (ClassOrInterfaceType)type;
            String name = this.qName(classOrInterfaceType);
            SymbolReference<ResolvedTypeDeclaration> ref = context.solveType(name);
            if (!ref.isSolved()) {
                throw new UnsolvedSymbolException(name);
            }
            ResolvedTypeDeclaration typeDeclaration = (ResolvedTypeDeclaration)ref.getCorrespondingDeclaration();
            List<Object> typeParameters = Collections.emptyList();
            if (classOrInterfaceType.getTypeArguments().isPresent()) {
                typeParameters = ((NodeList)classOrInterfaceType.getTypeArguments().get()).stream().map(pt -> this.convertToUsage((Type)pt, context)).collect(Collectors.toList());
            }
            if (typeDeclaration.isTypeParameter()) {
                if (typeDeclaration instanceof ResolvedTypeParameterDeclaration) {
                    return new ResolvedTypeVariable((ResolvedTypeParameterDeclaration)typeDeclaration);
                }
                JavaParserTypeVariableDeclaration javaParserTypeVariableDeclaration = (JavaParserTypeVariableDeclaration)typeDeclaration;
                return new ResolvedTypeVariable(javaParserTypeVariableDeclaration.asTypeParameter());
            }
            return new ReferenceTypeImpl((ResolvedReferenceTypeDeclaration)typeDeclaration, typeParameters, this.typeSolver);
        }
        if (type instanceof PrimitiveType) {
            return ResolvedPrimitiveType.byName((String)((PrimitiveType)type).getType().name());
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            if (wildcardType.getExtendedType().isPresent() && !wildcardType.getSuperType().isPresent()) {
                return ResolvedWildcard.extendsBound((ResolvedType)this.convertToUsage((Type)wildcardType.getExtendedType().get(), context));
            }
            if (!wildcardType.getExtendedType().isPresent() && wildcardType.getSuperType().isPresent()) {
                return ResolvedWildcard.superBound((ResolvedType)this.convertToUsage((Type)wildcardType.getSuperType().get(), context));
            }
            if (!wildcardType.getExtendedType().isPresent() && !wildcardType.getSuperType().isPresent()) {
                return ResolvedWildcard.UNBOUNDED;
            }
            throw new UnsupportedOperationException(wildcardType.toString());
        }
        if (type instanceof VoidType) {
            return ResolvedVoidType.INSTANCE;
        }
        if (type instanceof ArrayType) {
            ArrayType jpArrayType = (ArrayType)type;
            return new ResolvedArrayType(this.convertToUsage(jpArrayType.getComponentType(), context));
        }
        if (type instanceof UnionType) {
            UnionType unionType = (UnionType)type;
            return new ResolvedUnionType(unionType.getElements().stream().map(el -> this.convertToUsage((Type)el, context)).collect(Collectors.toList()));
        }
        if (type instanceof VarType) {
            Node parent = (Node)type.getParentNode().get();
            if (!(parent instanceof VariableDeclarator)) {
                throw new IllegalStateException("Trying to resolve a `var` which is not in a variable declaration.");
            }
            VariableDeclarator variableDeclarator = (VariableDeclarator)parent;
            return variableDeclarator.getInitializer().map(Expression::calculateResolvedType).orElseThrow(() -> new IllegalStateException("Cannot resolve `var` which has no initializer."));
        }
        throw new UnsupportedOperationException(type.getClass().getCanonicalName());
    }

    public ResolvedType convert(Type type, Node node) {
        return this.convert(type, JavaParserFactory.getContext(node, this.typeSolver));
    }

    public ResolvedType convert(Type type, Context context) {
        return this.convertToUsage(type, context);
    }

    public MethodUsage solveMethodAsUsage(MethodCallExpr call) {
        Context context;
        Optional<MethodUsage> methodUsage;
        ArrayList<ResolvedType> params = new ArrayList<ResolvedType>();
        if (call.getArguments() != null) {
            for (Expression param : call.getArguments()) {
                try {
                    params.add(this.getType((Node)param, false));
                }
                catch (Exception e) {
                    throw new RuntimeException(String.format("Error calculating the type of parameter %s of method call %s", param, call), e);
                }
            }
        }
        if (!(methodUsage = (context = JavaParserFactory.getContext((Node)call, this.typeSolver)).solveMethodAsUsage(call.getName().getId(), params)).isPresent()) {
            throw new RuntimeException("Method '" + call.getName() + "' cannot be resolved in context " + call + " (line: " + call.getRange().map(r -> "" + r.begin.line).orElse("??") + ") " + context + ". Parameter types: " + params);
        }
        return methodUsage.get();
    }

    public ResolvedReferenceTypeDeclaration getTypeDeclaration(Node node) {
        if (node instanceof TypeDeclaration) {
            return this.getTypeDeclaration((TypeDeclaration)node);
        }
        if (node instanceof ObjectCreationExpr) {
            return new JavaParserAnonymousClassDeclaration((ObjectCreationExpr)node, this.typeSolver);
        }
        throw new IllegalArgumentException();
    }

    public ResolvedReferenceTypeDeclaration getTypeDeclaration(ClassOrInterfaceDeclaration classOrInterfaceDeclaration) {
        return JavaParserFactory.toTypeDeclaration((Node)classOrInterfaceDeclaration, this.typeSolver);
    }

    public ResolvedType getTypeOfThisIn(Node node) {
        if (node instanceof ClassOrInterfaceDeclaration) {
            return new ReferenceTypeImpl(this.getTypeDeclaration((ClassOrInterfaceDeclaration)node), this.typeSolver);
        }
        if (node instanceof EnumDeclaration) {
            JavaParserEnumDeclaration enumDeclaration = new JavaParserEnumDeclaration((EnumDeclaration)node, this.typeSolver);
            return new ReferenceTypeImpl((ResolvedReferenceTypeDeclaration)enumDeclaration, this.typeSolver);
        }
        if (node instanceof ObjectCreationExpr && ((ObjectCreationExpr)node).getAnonymousClassBody().isPresent()) {
            JavaParserAnonymousClassDeclaration anonymousDeclaration = new JavaParserAnonymousClassDeclaration((ObjectCreationExpr)node, this.typeSolver);
            return new ReferenceTypeImpl((ResolvedReferenceTypeDeclaration)anonymousDeclaration, this.typeSolver);
        }
        return this.getTypeOfThisIn(Navigator.requireParentNode(node));
    }

    public ResolvedReferenceTypeDeclaration getTypeDeclaration(TypeDeclaration<?> typeDeclaration) {
        return JavaParserFactory.toTypeDeclaration(typeDeclaration, this.typeSolver);
    }

    public ResolvedType classToResolvedType(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return ResolvedPrimitiveType.byName((String)clazz.getName());
        }
        return new ReferenceTypeImpl((ResolvedReferenceTypeDeclaration)new ReflectionClassDeclaration(clazz, this.typeSolver), this.typeSolver);
    }
}

