/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.nodeTypes;

import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import java.util.Arrays;
import java.util.Collection;

public interface NodeWithModifiers<N extends Node> {
    public NodeList<Modifier> getModifiers();

    public N setModifiers(NodeList<Modifier> var1);

    default public N addModifier(Modifier.Keyword ... newModifiers) {
        NodeList<Modifier> existingModifiers = new NodeList<Modifier>((Collection<Modifier>)this.getModifiers());
        for (Modifier.Keyword newModifier : newModifiers) {
            boolean alreadyPresent = existingModifiers.stream().anyMatch(m -> m.getKeyword() == newModifier);
            if (alreadyPresent) continue;
            existingModifiers.add(new Modifier(newModifier));
        }
        this.setModifiers(existingModifiers);
        return (N)((Node)((Object)this));
    }

    default public N removeModifier(Modifier.Keyword ... modifiersToRemove) {
        NodeList<Modifier> existingModifiers = new NodeList<Modifier>((Collection<Modifier>)this.getModifiers());
        for (Modifier.Keyword modifierToRemove : modifiersToRemove) {
            for (Modifier existingModifier : existingModifiers) {
                if (existingModifier.getKeyword() != modifierToRemove) continue;
                existingModifiers.remove(existingModifier);
            }
        }
        this.setModifiers(existingModifiers);
        return (N)((Node)((Object)this));
    }

    default public N setModifier(Modifier.Keyword m, boolean set) {
        if (set) {
            return this.addModifier(m);
        }
        return this.removeModifier(m);
    }

    default public boolean hasModifier(Modifier.Keyword modifier) {
        for (Modifier m : this.getModifiers()) {
            if (m.getKeyword() != modifier) continue;
            return true;
        }
        return false;
    }

    default public N setModifiers(Modifier.Keyword ... modifiers) {
        return this.setModifiers(Arrays.stream(modifiers).map(Modifier::new).collect(NodeList.toNodeList()));
    }

    default public Modifier.Keyword getAccessSpecifier() {
        for (Modifier modifier : this.getModifiers()) {
            switch (modifier.getKeyword()) {
                case PUBLIC: 
                case PROTECTED: 
                case PRIVATE: {
                    return modifier.getKeyword();
                }
            }
        }
        return Modifier.Keyword.PACKAGE_PRIVATE;
    }
}

