/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser;

import com.github.javaparser.JavaToken;
import com.github.javaparser.Range;
import com.github.javaparser.utils.Utils;
import java.util.Optional;

public class TokenRange {
    public static final TokenRange INVALID = new TokenRange(JavaToken.INVALID, JavaToken.INVALID);
    private final JavaToken begin;
    private final JavaToken end;

    public TokenRange(JavaToken begin, JavaToken end) {
        this.begin = Utils.assertNotNull(begin);
        this.end = Utils.assertNotNull(end);
    }

    public JavaToken getBegin() {
        return this.begin;
    }

    public JavaToken getEnd() {
        return this.end;
    }

    public Optional<Range> toRange() {
        if (this.begin.getRange().isPresent() && this.end.getRange().isPresent()) {
            return Optional.of(new Range(this.begin.getRange().get().begin, this.end.getRange().get().end));
        }
        return Optional.empty();
    }

    public TokenRange withBegin(JavaToken begin) {
        return new TokenRange(Utils.assertNotNull(begin), this.end);
    }

    public TokenRange withEnd(JavaToken end) {
        return new TokenRange(this.begin, Utils.assertNotNull(end));
    }

    public String toString() {
        JavaToken t = this.begin;
        StringBuilder result = new StringBuilder();
        while (true) {
            result.append(t.getText());
            if (t == this.end) {
                return result.toString();
            }
            Optional<JavaToken> next = t.getNextToken();
            if (!next.isPresent()) break;
            t = next.get();
        }
        return result.toString();
    }
}

