/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.comments;

import com.github.javaparser.TokenRange;
import com.github.javaparser.ast.AllFieldsConstructor;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.comments.JavadocDescriptionElement;
import com.github.javaparser.ast.observer.ObservableProperty;
import com.github.javaparser.ast.visitor.CloneVisitor;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.metamodel.JavaParserMetaModel;
import com.github.javaparser.metamodel.JavadocInlineTagMetaModel;
import com.github.javaparser.utils.Utils;

public class JavadocInlineTag
extends JavadocDescriptionElement {
    private InlineTagType type;
    private String content;

    public JavadocInlineTag() {
        this(null, InlineTagType.UNKNOWN, "");
    }

    @AllFieldsConstructor
    public JavadocInlineTag(InlineTagType type, String content) {
        this(null, type, content);
    }

    public JavadocInlineTag(TokenRange tokenRange, InlineTagType type, String content) {
        super(tokenRange);
        this.setType(type);
        this.setContent(content);
        this.customInitialization();
    }

    public JavadocInlineTag setType(InlineTagType type) {
        Utils.assertNotNull(type);
        if (type == this.type) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.TYPE, this.type, type);
        this.type = type;
        return this;
    }

    public JavadocInlineTag setContent(String content) {
        Utils.assertNotNull(content);
        if (content == this.content) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.CONTENT, this.content, content);
        this.content = content;
        return this;
    }

    public String getContent() {
        return this.content;
    }

    public InlineTagType getType() {
        return this.type;
    }

    @Override
    public String toText() {
        return "{@" + this.type.toString() + this.content + "}";
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    @Override
    public boolean remove(Node node) {
        if (node == null) {
            return false;
        }
        return super.remove(node);
    }

    @Override
    public boolean replace(Node node, Node replacementNode) {
        if (node == null) {
            return false;
        }
        return super.replace(node, replacementNode);
    }

    @Override
    public JavadocInlineTag clone() {
        return (JavadocInlineTag)this.accept(new CloneVisitor(), null);
    }

    @Override
    public JavadocInlineTagMetaModel getMetaModel() {
        return JavaParserMetaModel.javadocInlineTagMetaModel;
    }

    public static enum InlineTagType {
        CODE,
        DOC_ROOT,
        INHERIT_DOC,
        LINK,
        LINKPLAIN,
        LITERAL,
        VALUE,
        SYSTEM_PROPERTY,
        UNKNOWN;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

