/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.comments;

import com.github.javaparser.TokenRange;
import com.github.javaparser.ast.AllFieldsConstructor;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.comments.JavadocBlockTag;
import com.github.javaparser.ast.comments.JavadocDescription;
import com.github.javaparser.ast.observer.ObservableProperty;
import com.github.javaparser.ast.visitor.CloneVisitor;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.metamodel.JavaParserMetaModel;
import com.github.javaparser.metamodel.JavadocContentMetaModel;
import com.github.javaparser.utils.Utils;
import java.util.Optional;
import java.util.function.Consumer;

public class JavadocContent
extends Comment {
    private JavadocDescription description;
    private NodeList<JavadocBlockTag> blockTags;

    public JavadocContent() {
        this("", new JavadocDescription(), new NodeList<JavadocBlockTag>());
    }

    public JavadocContent(JavadocDescription description, NodeList<JavadocBlockTag> blockTags) {
        this("", description, blockTags);
    }

    @AllFieldsConstructor
    public JavadocContent(String content, JavadocDescription description, NodeList<JavadocBlockTag> blockTags) {
        this(null, content, description, blockTags);
    }

    public JavadocContent(TokenRange tokenRange, String content, JavadocDescription description, NodeList<JavadocBlockTag> blockTags) {
        super(tokenRange, content);
        this.setDescription(description);
        this.setBlockTags(blockTags);
        this.customInitialization();
    }

    protected JavadocContent(TokenRange tokenRange) {
        super(tokenRange, "");
    }

    public JavadocContent setDescription(JavadocDescription description) {
        Utils.assertNotNull(description);
        if (description == this.description) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.DESCRIPTION, this.description, description);
        if (this.description != null) {
            this.description.setParentNode(null);
        }
        this.description = description;
        this.setAsParentNodeOf(description);
        return this;
    }

    public JavadocContent setBlockTags(NodeList<JavadocBlockTag> blockTags) {
        Utils.assertNotNull(blockTags);
        if (blockTags == this.blockTags) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.BLOCK_TAGS, this.blockTags, blockTags);
        if (this.blockTags != null) {
            this.blockTags.setParentNode(null);
        }
        this.blockTags = blockTags;
        this.setAsParentNodeOf(blockTags);
        return this;
    }

    public void addBlockTag(JavadocBlockTag blockTag) {
        if (this.blockTags == null) {
            this.blockTags = new NodeList();
        }
        this.blockTags.add(blockTag);
    }

    public NodeList<JavadocBlockTag> getBlockTags() {
        return this.blockTags;
    }

    public JavadocDescription getDescription() {
        return this.description;
    }

    public String toText() {
        StringBuilder sb = new StringBuilder();
        if (!this.description.toText().isEmpty()) {
            sb.append(this.description.toText());
            sb.append(Utils.EOL);
        }
        if (!this.blockTags.isEmpty()) {
            sb.append(Utils.EOL);
        }
        this.blockTags.forEach(bt -> {
            sb.append(bt.toText());
            sb.append(Utils.EOL);
        });
        return sb.toString();
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    @Override
    public boolean isJavadocContent() {
        return true;
    }

    @Override
    public JavadocContent asJavadocContent() {
        return this;
    }

    @Override
    public Optional<JavadocContent> toJavadocContent() {
        return Optional.of(this);
    }

    @Override
    public void ifJavadocContent(Consumer<JavadocContent> action) {
        action.accept(this);
    }

    @Override
    public boolean remove(Node node) {
        if (node == null) {
            return false;
        }
        for (int i = 0; i < this.blockTags.size(); ++i) {
            if (this.blockTags.get(i) != node) continue;
            this.blockTags.remove(i);
            return true;
        }
        return super.remove(node);
    }

    @Override
    public boolean replace(Node node, Node replacementNode) {
        if (node == null) {
            return false;
        }
        for (int i = 0; i < this.blockTags.size(); ++i) {
            if (this.blockTags.get(i) != node) continue;
            this.blockTags.set(i, (JavadocBlockTag)replacementNode);
            return true;
        }
        if (node == this.description) {
            this.setDescription((JavadocDescription)replacementNode);
            return true;
        }
        return super.replace(node, replacementNode);
    }

    @Override
    public JavadocContent clone() {
        return (JavadocContent)this.accept(new CloneVisitor(), null);
    }

    @Override
    public JavadocContentMetaModel getMetaModel() {
        return JavaParserMetaModel.javadocContentMetaModel;
    }
}

