/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.validator;

import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.InitializerDeclaration;
import com.github.javaparser.ast.nodeTypes.NodeWithRange;
import com.github.javaparser.ast.stmt.LocalClassDeclarationStmt;
import com.github.javaparser.ast.stmt.TryStmt;
import com.github.javaparser.ast.validator.BaseModifierValidator;
import com.github.javaparser.ast.validator.ProblemReporter;
import com.github.javaparser.ast.validator.Validators;
import com.github.javaparser.ast.validator.VisitorValidator;
import java.util.function.Consumer;

public class BaseJavaValidator
extends Validators {
    public BaseJavaValidator() {
        super(new VisitorValidator(){

            @Override
            public void visit(TryStmt n, ProblemReporter reporter) {
                if (n.getCatchClauses().isEmpty() && n.getResources().isEmpty() && !n.getFinallyBlock().isPresent()) {
                    reporter.report(n, "Try has no finally, no catch, and no resources.", new Object[0]);
                }
                super.visit(n, reporter);
            }
        }, new VisitorValidator(){

            @Override
            public void visit(ClassOrInterfaceDeclaration n, ProblemReporter reporter) {
                if (!n.isInterface() && n.getExtendedTypes().size() > 1) {
                    reporter.report(n.getExtendedTypes(1), "A class cannot extend more than one other class.", new Object[0]);
                }
                super.visit(n, reporter);
            }
        }, new VisitorValidator(){

            @Override
            public void visit(ClassOrInterfaceDeclaration n, ProblemReporter reporter) {
                if (n.isInterface() && !n.getImplementedTypes().isEmpty()) {
                    reporter.report(n.getImplementedTypes(0), "An interface cannot implement other interfaces.", new Object[0]);
                }
                super.visit(n, reporter);
            }
        }, new VisitorValidator(){

            @Override
            public void visit(ClassOrInterfaceDeclaration n, ProblemReporter reporter) {
                n.getParentNode().ifPresent(p -> {
                    if (p instanceof LocalClassDeclarationStmt && n.isInterface()) {
                        reporter.report(n, "There is no such thing as a local interface.", new Object[0]);
                    }
                });
                super.visit(n, reporter);
            }
        }, new VisitorValidator(){

            @Override
            public void visit(ClassOrInterfaceDeclaration n, ProblemReporter reporter) {
                if (n.isInterface()) {
                    n.getMembers().forEach((Consumer<BodyDeclaration<?>>)((Consumer<BodyDeclaration>)mem -> {
                        if (mem instanceof InitializerDeclaration) {
                            reporter.report((NodeWithRange<?>)mem, "An interface cannot have initializers.", new Object[0]);
                        }
                    }));
                }
                super.visit(n, reporter);
            }
        }, new VisitorValidator(){

            @Override
            public void visit(ClassOrInterfaceDeclaration n, ProblemReporter reporter) {
                if (n.isInterface()) {
                    n.getMethods().forEach(m -> {
                        if (m.isDefault() && !m.getBody().isPresent()) {
                            reporter.report((NodeWithRange<?>)m, "'default' methods must have a body.", new Object[0]);
                        }
                    });
                }
                super.visit(n, reporter);
            }
        }, new BaseModifierValidator());
    }
}

