/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.printer.lexicalpreservation;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.type.PrimitiveType;
import com.github.javaparser.printer.TokenConstants;
import com.github.javaparser.printer.concretesyntaxmodel.CsmElement;
import com.github.javaparser.printer.concretesyntaxmodel.CsmIndent;
import com.github.javaparser.printer.concretesyntaxmodel.CsmToken;
import com.github.javaparser.printer.lexicalpreservation.ChildTextElement;
import com.github.javaparser.printer.lexicalpreservation.LexicalDifferenceCalculator;
import com.github.javaparser.printer.lexicalpreservation.LexicalPreservingPrinter;
import com.github.javaparser.printer.lexicalpreservation.NodeText;
import com.github.javaparser.printer.lexicalpreservation.TextElement;
import com.github.javaparser.printer.lexicalpreservation.TokenTextElement;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Difference {
    private int STANDARD_INDENTANTION_SIZE = 4;
    private List<DifferenceElement> elements;

    private Difference(List<DifferenceElement> elements) {
        this.elements = elements;
    }

    private static boolean matching(CsmElement a, CsmElement b) {
        if (a instanceof LexicalDifferenceCalculator.CsmChild) {
            if (b instanceof LexicalDifferenceCalculator.CsmChild) {
                LexicalDifferenceCalculator.CsmChild childA = (LexicalDifferenceCalculator.CsmChild)a;
                LexicalDifferenceCalculator.CsmChild childB = (LexicalDifferenceCalculator.CsmChild)b;
                return childA.getChild().equals(childB.getChild());
            }
            if (b instanceof CsmToken) {
                return false;
            }
            throw new UnsupportedOperationException(a.getClass().getSimpleName() + " " + b.getClass().getSimpleName());
        }
        if (a instanceof CsmToken) {
            if (b instanceof CsmToken) {
                CsmToken childA = (CsmToken)a;
                CsmToken childB = (CsmToken)b;
                return childA.getTokenType() == childB.getTokenType();
            }
            if (b instanceof LexicalDifferenceCalculator.CsmChild) {
                return false;
            }
        } else if (a instanceof CsmIndent) {
            return b instanceof CsmIndent;
        }
        throw new UnsupportedOperationException(a.getClass().getSimpleName() + " " + b.getClass().getSimpleName());
    }

    private static boolean replacement(CsmElement a, CsmElement b) {
        if (a instanceof LexicalDifferenceCalculator.CsmChild) {
            if (b instanceof LexicalDifferenceCalculator.CsmChild) {
                LexicalDifferenceCalculator.CsmChild childA = (LexicalDifferenceCalculator.CsmChild)a;
                LexicalDifferenceCalculator.CsmChild childB = (LexicalDifferenceCalculator.CsmChild)b;
                return childA.getChild().getClass().equals(childB.getClass());
            }
            if (b instanceof CsmToken) {
                return false;
            }
            throw new UnsupportedOperationException(a.getClass().getSimpleName() + " " + b.getClass().getSimpleName());
        }
        if (a instanceof CsmToken) {
            if (b instanceof CsmToken) {
                CsmToken childA = (CsmToken)a;
                CsmToken childB = (CsmToken)b;
                return childA.getTokenType() == childB.getTokenType();
            }
            if (b instanceof LexicalDifferenceCalculator.CsmChild) {
                return false;
            }
        }
        throw new UnsupportedOperationException(a.getClass().getSimpleName() + " " + b.getClass().getSimpleName());
    }

    private static Map<Node, Integer> findChildrenPositions(LexicalDifferenceCalculator.CalculatedSyntaxModel calculatedSyntaxModel) {
        HashMap<Node, Integer> positions = new HashMap<Node, Integer>();
        for (int i = 0; i < calculatedSyntaxModel.elements.size(); ++i) {
            CsmElement element = calculatedSyntaxModel.elements.get(i);
            if (!(element instanceof LexicalDifferenceCalculator.CsmChild)) continue;
            positions.put(((LexicalDifferenceCalculator.CsmChild)element).getChild(), i);
        }
        return positions;
    }

    static Difference calculate(LexicalDifferenceCalculator.CalculatedSyntaxModel original, LexicalDifferenceCalculator.CalculatedSyntaxModel after) {
        Map<Node, Integer> childrenInOriginal = Difference.findChildrenPositions(original);
        Map<Node, Integer> childrenInAfter = Difference.findChildrenPositions(after);
        LinkedList<Node> commonChildren = new LinkedList<Node>(childrenInOriginal.keySet());
        commonChildren.retainAll(childrenInAfter.keySet());
        commonChildren.sort(Comparator.comparingInt(childrenInOriginal::get));
        LinkedList<DifferenceElement> elements = new LinkedList<DifferenceElement>();
        int originalIndex = 0;
        int afterIndex = 0;
        int commonChildrenIndex = 0;
        while (commonChildrenIndex < commonChildren.size()) {
            Node child = (Node)commonChildren.get(commonChildrenIndex++);
            int posOfNextChildInOriginal = childrenInOriginal.get(child);
            int posOfNextChildInAfter = childrenInAfter.get(child);
            if (originalIndex < posOfNextChildInOriginal || afterIndex < posOfNextChildInAfter) {
                elements.addAll(Difference.calculateImpl((LexicalDifferenceCalculator.CalculatedSyntaxModel)original.sub((int)originalIndex, (int)posOfNextChildInOriginal), (LexicalDifferenceCalculator.CalculatedSyntaxModel)after.sub((int)afterIndex, (int)posOfNextChildInAfter)).elements);
            }
            elements.add(new Kept(new LexicalDifferenceCalculator.CsmChild(child)));
            originalIndex = posOfNextChildInOriginal + 1;
            afterIndex = posOfNextChildInAfter + 1;
        }
        if (originalIndex < original.elements.size() || afterIndex < after.elements.size()) {
            elements.addAll(Difference.calculateImpl((LexicalDifferenceCalculator.CalculatedSyntaxModel)original.sub((int)originalIndex, (int)original.elements.size()), (LexicalDifferenceCalculator.CalculatedSyntaxModel)after.sub((int)afterIndex, (int)after.elements.size())).elements);
        }
        return new Difference(elements);
    }

    private static Difference calculateImpl(LexicalDifferenceCalculator.CalculatedSyntaxModel original, LexicalDifferenceCalculator.CalculatedSyntaxModel after) {
        LinkedList<DifferenceElement> elements = new LinkedList<DifferenceElement>();
        int originalIndex = 0;
        int afterIndex = 0;
        do {
            CsmElement nextAfter;
            if (originalIndex < original.elements.size() && afterIndex >= after.elements.size()) {
                elements.add(new Removed(original.elements.get(originalIndex)));
                ++originalIndex;
                continue;
            }
            if (originalIndex >= original.elements.size() && afterIndex < after.elements.size()) {
                elements.add(new Added(after.elements.get(afterIndex)));
                ++afterIndex;
                continue;
            }
            CsmElement nextOriginal = original.elements.get(originalIndex);
            if (Difference.matching(nextOriginal, nextAfter = after.elements.get(afterIndex))) {
                elements.add(new Kept(nextOriginal));
                ++originalIndex;
                ++afterIndex;
                continue;
            }
            if (Difference.replacement(nextOriginal, nextAfter)) {
                elements.add(new Removed(nextOriginal));
                elements.add(new Added(nextAfter));
                ++originalIndex;
                ++afterIndex;
                continue;
            }
            Difference adding = Difference.calculate(original.from(originalIndex), after.from(afterIndex + 1));
            Difference removing = null;
            if (adding.cost() > 0L) {
                removing = Difference.calculate(original.from(originalIndex + 1), after.from(afterIndex));
            }
            if (removing == null || removing.cost() > adding.cost()) {
                elements.add(new Added(nextAfter));
                ++afterIndex;
                continue;
            }
            elements.add(new Removed(nextOriginal));
            ++originalIndex;
        } while (originalIndex < original.elements.size() || afterIndex < after.elements.size());
        return new Difference(elements);
    }

    private TextElement toTextElement(LexicalPreservingPrinter lpp, CsmElement csmElement) {
        if (csmElement instanceof LexicalDifferenceCalculator.CsmChild) {
            return new ChildTextElement(lpp, ((LexicalDifferenceCalculator.CsmChild)csmElement).getChild());
        }
        if (csmElement instanceof CsmToken) {
            return new TokenTextElement(((CsmToken)csmElement).getTokenType(), ((CsmToken)csmElement).getContent(null));
        }
        throw new UnsupportedOperationException(csmElement.getClass().getSimpleName());
    }

    private List<TextElement> processIndentation(List<TokenTextElement> indentation, List<TextElement> prevElements) {
        LinkedList<TextElement> res = new LinkedList<TextElement>();
        res.addAll(indentation);
        boolean afterNl = false;
        for (TextElement e : prevElements) {
            if (e.isToken(TokenConstants.NEWLINE_TOKEN) || e.isToken(31)) {
                res.clear();
                afterNl = true;
                continue;
            }
            if (afterNl && e instanceof TokenTextElement && TokenConstants.isWhitespace(((TokenTextElement)e).getTokenKind())) {
                res.add(e);
                continue;
            }
            afterNl = false;
        }
        return res;
    }

    private List<TextElement> indentationBlock() {
        LinkedList<TextElement> res = new LinkedList<TextElement>();
        res.add(new TokenTextElement(TokenConstants.SPACE_TOKEN));
        res.add(new TokenTextElement(TokenConstants.SPACE_TOKEN));
        res.add(new TokenTextElement(TokenConstants.SPACE_TOKEN));
        res.add(new TokenTextElement(TokenConstants.SPACE_TOKEN));
        return res;
    }

    private int considerCleaningTheLine(NodeText nodeText, int nodeTextIndex) {
        while (nodeTextIndex >= 1 && nodeText.getElements().get(nodeTextIndex - 1).isWhiteSpace() && !nodeText.getElements().get(nodeTextIndex - 1).isToken(3)) {
            nodeText.removeElement(nodeTextIndex - 1);
            --nodeTextIndex;
        }
        return nodeTextIndex;
    }

    private boolean isAfterLBrace(NodeText nodeText, int nodeTextIndex) {
        if (nodeTextIndex > 0 && nodeText.getElements().get(nodeTextIndex - 1).isToken(118)) {
            return true;
        }
        if (nodeTextIndex > 0 && nodeText.getElements().get(nodeTextIndex - 1).isWhiteSpace() && !nodeText.getElements().get(nodeTextIndex - 1).isToken(3)) {
            return this.isAfterLBrace(nodeText, nodeTextIndex - 1);
        }
        return false;
    }

    private int considerEnforcingIndentation(NodeText nodeText, int nodeTextIndex) {
        int i;
        boolean hasOnlyWsBefore = true;
        for (i = nodeTextIndex; i >= 0 && hasOnlyWsBefore && i < nodeText.getElements().size() && !nodeText.getElements().get(i).isNewline(); --i) {
            if (nodeText.getElements().get(i).isSpaceOrTab()) continue;
            hasOnlyWsBefore = false;
        }
        if (hasOnlyWsBefore) {
            for (i = nodeTextIndex; i >= 0 && hasOnlyWsBefore && i < nodeText.getElements().size() && !nodeText.getElements().get(i).isNewline(); --i) {
                nodeText.removeElement(i);
            }
        }
        return nodeTextIndex;
    }

    void apply(NodeText nodeText, Node node) {
        List<TokenTextElement> indentation = nodeText.getLexicalPreservingPrinter().findIndentation(node);
        if (nodeText == null) {
            throw new NullPointerException();
        }
        int diffIndex = 0;
        int nodeTextIndex = 0;
        do {
            DifferenceElement diffEl;
            if (diffIndex < this.elements.size() && nodeTextIndex >= nodeText.getElements().size()) {
                diffEl = this.elements.get(diffIndex);
                if (diffEl instanceof Kept) {
                    Kept kept = (Kept)diffEl;
                    if (kept.element instanceof CsmToken) {
                        CsmToken csmToken = (CsmToken)kept.element;
                        if (TokenConstants.isWhitespaceOrComment(csmToken.getTokenType())) {
                            ++diffIndex;
                            continue;
                        }
                        throw new IllegalStateException("Cannot keep element because we reached the end of nodetext: " + nodeText + ". Difference: " + this);
                    }
                    throw new IllegalStateException("Cannot keep element because we reached the end of nodetext: " + nodeText + ". Difference: " + this);
                }
                if (diffEl instanceof Added) {
                    nodeText.addElement(nodeTextIndex, this.toTextElement(nodeText.getLexicalPreservingPrinter(), ((Added)diffEl).element));
                    ++nodeTextIndex;
                    ++diffIndex;
                    continue;
                }
                throw new UnsupportedOperationException(diffEl.getClass().getSimpleName());
            }
            if (diffIndex >= this.elements.size() && nodeTextIndex < nodeText.getElements().size()) {
                TextElement nodeTextEl = nodeText.getElements().get(nodeTextIndex);
                if (nodeTextEl instanceof TokenTextElement && ((TokenTextElement)nodeTextEl).isWhiteSpaceOrComment()) {
                    ++nodeTextIndex;
                    continue;
                }
                throw new UnsupportedOperationException("NodeText: " + nodeText + ". Difference: " + this + " " + nodeTextEl);
            }
            diffEl = this.elements.get(diffIndex);
            TextElement nodeTextEl = nodeText.getElements().get(nodeTextIndex);
            if (diffEl instanceof Added) {
                TextElement textElement = this.toTextElement(nodeText.getLexicalPreservingPrinter(), ((Added)diffEl).element);
                boolean used = false;
                if (nodeTextIndex > 0 && nodeText.getElements().get(nodeTextIndex - 1).isToken(TokenConstants.NEWLINE_TOKEN)) {
                    for (TextElement e : this.processIndentation(indentation, nodeText.getElements().subList(0, nodeTextIndex - 1))) {
                        nodeText.addElement(nodeTextIndex++, e);
                    }
                } else if (this.isAfterLBrace(nodeText, nodeTextIndex) && !this.isAReplacement(diffIndex)) {
                    if (textElement.isToken(TokenConstants.NEWLINE_TOKEN)) {
                        used = true;
                    }
                    nodeText.addElement(nodeTextIndex++, new TokenTextElement(TokenConstants.NEWLINE_TOKEN));
                    while (nodeText.getElements().get(nodeTextIndex).isSpaceOrTab()) {
                        nodeText.getElements().remove(nodeTextIndex);
                    }
                    for (TextElement e : this.processIndentation(indentation, nodeText.getElements().subList(0, nodeTextIndex - 1))) {
                        nodeText.addElement(nodeTextIndex++, e);
                    }
                    for (TextElement e : this.indentationBlock()) {
                        nodeText.addElement(nodeTextIndex++, e);
                    }
                }
                if (!used) {
                    nodeText.addElement(nodeTextIndex, textElement);
                    ++nodeTextIndex;
                }
                if (textElement.isNewline()) {
                    nodeTextIndex = this.adjustIndentation(indentation, nodeText, nodeTextIndex);
                }
                ++diffIndex;
                continue;
            }
            if (diffEl instanceof Kept) {
                Kept kept = (Kept)diffEl;
                if (kept.element instanceof LexicalDifferenceCalculator.CsmChild && nodeTextEl instanceof ChildTextElement) {
                    ++diffIndex;
                    ++nodeTextIndex;
                    continue;
                }
                if (kept.element instanceof LexicalDifferenceCalculator.CsmChild && nodeTextEl instanceof TokenTextElement) {
                    if (((TokenTextElement)nodeTextEl).isWhiteSpaceOrComment()) {
                        ++nodeTextIndex;
                        continue;
                    }
                    if (kept.element instanceof LexicalDifferenceCalculator.CsmChild) {
                        LexicalDifferenceCalculator.CsmChild keptChild = (LexicalDifferenceCalculator.CsmChild)kept.element;
                        if (keptChild.getChild() instanceof PrimitiveType) {
                            ++nodeTextIndex;
                            ++diffIndex;
                            continue;
                        }
                        throw new UnsupportedOperationException("kept " + kept.element + " vs " + nodeTextEl);
                    }
                    throw new UnsupportedOperationException("kept " + kept.element + " vs " + nodeTextEl);
                }
                if (kept.element instanceof CsmToken && nodeTextEl instanceof TokenTextElement) {
                    CsmToken csmToken = (CsmToken)kept.element;
                    TokenTextElement nodeTextToken = (TokenTextElement)nodeTextEl;
                    if (csmToken.getTokenType() == nodeTextToken.getTokenKind()) {
                        ++nodeTextIndex;
                        ++diffIndex;
                        continue;
                    }
                    if (TokenConstants.isWhitespaceOrComment(csmToken.getTokenType())) {
                        ++diffIndex;
                        continue;
                    }
                    if (nodeTextToken.isWhiteSpaceOrComment()) {
                        ++nodeTextIndex;
                        continue;
                    }
                    throw new UnsupportedOperationException("Csm token " + csmToken + " NodeText TOKEN " + nodeTextToken);
                }
                if (kept.element instanceof CsmToken && ((CsmToken)kept.element).isWhiteSpace()) {
                    ++diffIndex;
                    continue;
                }
                throw new UnsupportedOperationException("kept " + kept.element + " vs " + nodeTextEl);
            }
            if (diffEl instanceof Removed) {
                Removed removed = (Removed)diffEl;
                if (removed.element instanceof LexicalDifferenceCalculator.CsmChild && nodeTextEl instanceof ChildTextElement) {
                    nodeText.removeElement(nodeTextIndex);
                    if (nodeTextIndex < nodeText.getElements().size() && nodeText.getElements().get(nodeTextIndex).isToken(TokenConstants.NEWLINE_TOKEN)) {
                        nodeTextIndex = this.considerCleaningTheLine(nodeText, nodeTextIndex);
                    } else if (diffIndex + 1 >= this.getElements().size() || !(this.getElements().get(diffIndex + 1) instanceof Added)) {
                        nodeTextIndex = this.considerEnforcingIndentation(nodeText, nodeTextIndex);
                    }
                    ++diffIndex;
                    continue;
                }
                if (removed.element instanceof CsmToken && nodeTextEl instanceof TokenTextElement && ((CsmToken)removed.element).getTokenType() == ((TokenTextElement)nodeTextEl).getTokenKind()) {
                    nodeText.removeElement(nodeTextIndex);
                    ++diffIndex;
                    continue;
                }
                if (nodeTextEl instanceof TokenTextElement && ((TokenTextElement)nodeTextEl).isWhiteSpaceOrComment()) {
                    ++nodeTextIndex;
                    continue;
                }
                if (removed.element instanceof LexicalDifferenceCalculator.CsmChild && ((LexicalDifferenceCalculator.CsmChild)removed.element).getChild() instanceof PrimitiveType) {
                    if (this.isPrimitiveType(nodeTextEl)) {
                        nodeText.removeElement(nodeTextIndex);
                        ++diffIndex;
                        continue;
                    }
                    throw new UnsupportedOperationException("removed " + removed.element + " vs " + nodeTextEl);
                }
                if (removed.element instanceof CsmToken && ((CsmToken)removed.element).isWhiteSpace()) {
                    ++diffIndex;
                    continue;
                }
                if (nodeTextEl.isWhiteSpace()) {
                    ++nodeTextIndex;
                    continue;
                }
                throw new UnsupportedOperationException("removed " + removed.element + " vs " + nodeTextEl);
            }
            throw new UnsupportedOperationException("" + diffEl + " vs " + nodeTextEl);
        } while (diffIndex < this.elements.size() || nodeTextIndex < nodeText.getElements().size());
    }

    private int adjustIndentation(List<TokenTextElement> indentation, NodeText nodeText, int nodeTextIndex) {
        List<TextElement> indentationAdj = this.processIndentation(indentation, nodeText.getElements().subList(0, nodeTextIndex - 1));
        if (nodeTextIndex < nodeText.getElements().size() && nodeText.getElements().get(nodeTextIndex).isToken(119)) {
            indentationAdj = indentationAdj.subList(0, indentationAdj.size() - Math.min(this.STANDARD_INDENTANTION_SIZE, indentationAdj.size()));
        }
        for (TextElement e : indentationAdj) {
            nodeText.getElements().add(nodeTextIndex++, e);
        }
        return nodeTextIndex;
    }

    private boolean isAReplacement(int diffIndex) {
        return diffIndex > 0 && this.getElements().get(diffIndex) instanceof Added && this.getElements().get(diffIndex - 1) instanceof Removed;
    }

    private boolean isPrimitiveType(TextElement textElement) {
        if (textElement instanceof TokenTextElement) {
            TokenTextElement tokenTextElement = (TokenTextElement)textElement;
            int tokenKind = tokenTextElement.getTokenKind();
            return tokenKind == 41 || tokenKind == 44 || tokenKind == 75 || tokenKind == 64 || tokenKind == 66 || tokenKind == 57 || tokenKind == 50;
        }
        return false;
    }

    public long cost() {
        return this.elements.stream().filter(e -> !(e instanceof Kept)).count();
    }

    public String toString() {
        return "Difference{" + this.elements + '}';
    }

    public List<DifferenceElement> getElements() {
        return this.elements;
    }

    private static class Removed
    implements DifferenceElement {
        CsmElement element;

        public Removed(CsmElement element) {
            this.element = element;
        }

        public String toString() {
            return "Removed{" + this.element + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Removed removed = (Removed)o;
            return this.element.equals(removed.element);
        }

        public int hashCode() {
            return this.element.hashCode();
        }
    }

    private static class Kept
    implements DifferenceElement {
        CsmElement element;

        public Kept(CsmElement element) {
            this.element = element;
        }

        public String toString() {
            return "Kept{" + this.element + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Kept kept = (Kept)o;
            return this.element.equals(kept.element);
        }

        public int hashCode() {
            return this.element.hashCode();
        }
    }

    private static class Added
    implements DifferenceElement {
        CsmElement element;

        public Added(CsmElement element) {
            this.element = element;
        }

        public String toString() {
            return "Added{" + this.element + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Added added = (Added)o;
            return this.element.equals(added.element);
        }

        public int hashCode() {
            return this.element.hashCode();
        }
    }

    static interface DifferenceElement {
        public static DifferenceElement added(CsmElement element) {
            return new Added(element);
        }

        public static DifferenceElement removed(CsmElement element) {
            return new Removed(element);
        }

        public static DifferenceElement kept(CsmElement element) {
            return new Kept(element);
        }
    }
}

