/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.utils;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseResult;
import com.github.javaparser.ParseStart;
import com.github.javaparser.Problem;
import com.github.javaparser.Providers;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.printer.PrettyPrinter;
import com.github.javaparser.utils.CodeGenerationUtils;
import com.github.javaparser.utils.Log;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class SourceRoot {
    private final Path root;
    private final Map<Path, CompilationUnit> content = new HashMap<Path, CompilationUnit>();
    private final List<Problem> problems = new ArrayList<Problem>();

    public SourceRoot(Path root) {
        this.root = root.normalize();
        Log.info("New source root at \"%s\"", this.root);
    }

    public Map<Path, CompilationUnit> parse(final String startPackage, final JavaParser parser) throws IOException {
        Log.info("Parsing package \"%s\"", startPackage);
        Path path = CodeGenerationUtils.packageAbsolutePath(this.root, startPackage);
        this.content.clear();
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (!attrs.isDirectory() && file.toString().endsWith(".java")) {
                    SourceRoot.this.parse(startPackage, file.getFileName().toString(), parser);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return this.content;
    }

    public Map<Path, CompilationUnit> parse(JavaParser parser) throws IOException {
        return this.parse("", parser);
    }

    public void saveAll() throws FileNotFoundException, UnsupportedEncodingException {
        this.saveAll(this.root);
    }

    public void saveAll(Path root) throws FileNotFoundException, UnsupportedEncodingException {
        Log.info("Saving all files (%s) to %s", this.content.size(), root);
        for (Map.Entry<Path, CompilationUnit> cu : this.content.entrySet()) {
            Path path = root.resolve(cu.getKey());
            Log.trace("Saving %s", path);
            path.getParent().toFile().mkdirs();
            String code = new PrettyPrinter().print(cu.getValue());
            PrintWriter out = new PrintWriter(path.toFile(), Providers.UTF8.toString());
            Throwable throwable = null;
            try {
                out.println(code);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out == null) continue;
                if (throwable != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                out.close();
            }
        }
    }

    public List<Problem> getProblems() {
        return this.problems;
    }

    public Map<Path, CompilationUnit> getContent() {
        return this.content;
    }

    public Optional<CompilationUnit> parse(String packag, String filename, JavaParser javaParser) throws IOException {
        Path relativePath = CodeGenerationUtils.fileInPackageRelativePath(packag, filename);
        if (this.content.containsKey(relativePath)) {
            Log.trace("Retrieving cached %s", relativePath);
            return Optional.of(this.content.get(relativePath));
        }
        Path path = this.root.resolve(relativePath);
        Log.trace("Parsing %s", path);
        ParseResult<CompilationUnit> result = javaParser.parse(ParseStart.COMPILATION_UNIT, Providers.provider(path));
        if (result.isSuccessful()) {
            CompilationUnit cu = result.getResult().get();
            this.content.put(relativePath, cu);
        } else {
            Log.error("Problems occurred parsing %s.", relativePath);
            this.problems.addAll(result.getProblems());
        }
        return result.getResult();
    }

    public void add(String pkg, String filename, CompilationUnit compilationUnit) {
        Log.trace("Adding new file %s.%s", pkg, filename);
        Path path = CodeGenerationUtils.fileInPackageRelativePath(pkg, filename);
        this.content.put(path, compilationUnit);
    }
}

