/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.utils;

import com.github.javaparser.utils.Utils;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;

public final class CodeGenerationUtils {
    private CodeGenerationUtils() {
    }

    public static String getterName(Class<?> type, String name) {
        if (name.startsWith("is")) {
            return name;
        }
        if (type.equals(Boolean.class)) {
            return "is" + Utils.capitalize(name);
        }
        return "get" + Utils.capitalize(name);
    }

    public static String setterName(String fieldName) {
        if (fieldName.startsWith("is")) {
            return "set" + fieldName.substring(2);
        }
        return "set" + Utils.capitalize(fieldName);
    }

    public static String optionalOf(String text, boolean isOptional) {
        if (isOptional) {
            return CodeGenerationUtils.f("Optional.of(%s)", text);
        }
        return "Optional.empty()";
    }

    public static String f(String format, Object ... params) {
        return String.format(format, params);
    }

    public static Path fileInPackageAbsolutePath(String root, String pkg, String file) {
        pkg = CodeGenerationUtils.packageToPath(pkg);
        return Paths.get(root, pkg, file).normalize();
    }

    public static Path fileInPackageAbsolutePath(Path root, String pkg, String file) {
        return CodeGenerationUtils.fileInPackageAbsolutePath(root.toString(), pkg, file);
    }

    public static Path fileInPackageRelativePath(String pkg, String file) {
        pkg = CodeGenerationUtils.packageToPath(pkg);
        return Paths.get(pkg, file).normalize();
    }

    public static String packageToPath(String pkg) {
        return pkg.replace(".", File.separator);
    }

    public static Path packageAbsolutePath(String root, String pkg) {
        pkg = CodeGenerationUtils.packageToPath(pkg);
        return Paths.get(root, pkg).normalize();
    }

    public static Path packageAbsolutePath(Path root, String pkg) {
        return CodeGenerationUtils.packageAbsolutePath(root.toString(), pkg);
    }
}

