/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.expr;

import com.github.javaparser.Range;
import com.github.javaparser.ast.AllFieldsConstructor;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.nodeTypes.NodeWithParameters;
import com.github.javaparser.ast.observer.ObservableProperty;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.visitor.CloneVisitor;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.metamodel.JavaParserMetaModel;
import com.github.javaparser.metamodel.LambdaExprMetaModel;
import com.github.javaparser.utils.Utils;
import java.util.Arrays;
import java.util.List;

public class LambdaExpr
extends Expression
implements NodeWithParameters<LambdaExpr> {
    private NodeList<Parameter> parameters;
    private boolean isEnclosingParameters;
    private Statement body;

    public LambdaExpr() {
        this(null, new NodeList<Parameter>(), new ReturnStmt(), false);
    }

    @AllFieldsConstructor
    public LambdaExpr(NodeList<Parameter> parameters, Statement body, boolean isEnclosingParameters) {
        this(null, parameters, body, isEnclosingParameters);
    }

    public LambdaExpr(Range range, NodeList<Parameter> parameters, Statement body, boolean isEnclosingParameters) {
        super(range);
        this.setParameters((NodeList)parameters);
        this.setBody(body);
        this.setEnclosingParameters(isEnclosingParameters);
    }

    @Override
    public NodeList<Parameter> getParameters() {
        return this.parameters;
    }

    @Override
    public LambdaExpr setParameters(NodeList<Parameter> parameters) {
        Utils.assertNotNull(parameters);
        this.notifyPropertyChange(ObservableProperty.PARAMETERS, this.parameters, parameters);
        if (this.parameters != null) {
            this.parameters.setParentNode(null);
        }
        this.parameters = parameters;
        this.setAsParentNodeOf(parameters);
        return this;
    }

    public Statement getBody() {
        return this.body;
    }

    public LambdaExpr setBody(Statement body) {
        Utils.assertNotNull(body);
        this.notifyPropertyChange(ObservableProperty.BODY, this.body, body);
        if (this.body != null) {
            this.body.setParentNode(null);
        }
        this.body = body;
        this.setAsParentNodeOf(body);
        return this;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public boolean isEnclosingParameters() {
        return this.isEnclosingParameters;
    }

    public LambdaExpr setEnclosingParameters(boolean isEnclosingParameters) {
        this.notifyPropertyChange(ObservableProperty.ENCLOSING_PARAMETERS, this.isEnclosingParameters, isEnclosingParameters);
        this.isEnclosingParameters = isEnclosingParameters;
        return this;
    }

    @Override
    public List<NodeList<?>> getNodeLists() {
        return Arrays.asList(this.getParameters());
    }

    @Override
    public boolean remove(Node node) {
        if (node == null) {
            return false;
        }
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (this.parameters.get(i) != node) continue;
            this.parameters.remove(i);
            return true;
        }
        return super.remove(node);
    }

    @Override
    public LambdaExpr clone() {
        return (LambdaExpr)this.accept(new CloneVisitor(), null);
    }

    @Override
    public LambdaExprMetaModel getMetaModel() {
        return JavaParserMetaModel.lambdaExprMetaModel;
    }
}

