/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.body;

import com.github.javaparser.Range;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.nodeTypes.NodeWithJavadoc;
import com.github.javaparser.ast.nodeTypes.NodeWithMembers;
import com.github.javaparser.ast.nodeTypes.NodeWithModifiers;
import com.github.javaparser.ast.nodeTypes.NodeWithSimpleName;
import com.github.javaparser.ast.observer.ObservableProperty;
import com.github.javaparser.ast.visitor.CloneVisitor;
import com.github.javaparser.metamodel.JavaParserMetaModel;
import com.github.javaparser.metamodel.TypeDeclarationMetaModel;
import com.github.javaparser.utils.Utils;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;

public abstract class TypeDeclaration<T extends Node>
extends BodyDeclaration<T>
implements NodeWithSimpleName<T>,
NodeWithJavadoc<T>,
NodeWithModifiers<T>,
NodeWithMembers<T> {
    private SimpleName name;
    private EnumSet<Modifier> modifiers;
    private NodeList<BodyDeclaration<?>> members;

    public TypeDeclaration() {
        this(null, new NodeList<AnnotationExpr>(), EnumSet.noneOf(Modifier.class), new SimpleName(), new NodeList());
    }

    public TypeDeclaration(EnumSet<Modifier> modifiers, String name) {
        this(null, new NodeList<AnnotationExpr>(), modifiers, new SimpleName(name), new NodeList());
    }

    public TypeDeclaration(NodeList<AnnotationExpr> annotations, EnumSet<Modifier> modifiers, SimpleName name, NodeList<BodyDeclaration<?>> members) {
        this(null, annotations, modifiers, name, members);
    }

    public TypeDeclaration(Range range, NodeList<AnnotationExpr> annotations, EnumSet<Modifier> modifiers, SimpleName name, NodeList<BodyDeclaration<?>> members) {
        super(range, annotations);
        this.setName(name);
        this.setModifiers(modifiers);
        this.setMembers(members);
    }

    @Override
    public T addMember(BodyDeclaration<?> decl) {
        NodeList<BodyDeclaration<?>> members = this.getMembers();
        members.add(decl);
        return (T)this;
    }

    @Override
    public NodeList<BodyDeclaration<?>> getMembers() {
        return this.members;
    }

    @Override
    public final EnumSet<Modifier> getModifiers() {
        return this.modifiers;
    }

    @Override
    public T setMembers(NodeList<BodyDeclaration<?>> members) {
        Utils.assertNotNull(members);
        this.notifyPropertyChange(ObservableProperty.MEMBERS, this.members, members);
        if (this.members != null) {
            this.members.setParentNode(null);
        }
        this.members = members;
        this.setAsParentNodeOf(members);
        return (T)this;
    }

    @Override
    public T setModifiers(EnumSet<Modifier> modifiers) {
        Utils.assertNotNull(modifiers);
        this.notifyPropertyChange(ObservableProperty.MODIFIERS, this.modifiers, modifiers);
        this.modifiers = modifiers;
        return (T)this;
    }

    @Override
    public T setName(SimpleName name) {
        Utils.assertNotNull(name);
        this.notifyPropertyChange(ObservableProperty.NAME, this.name, name);
        if (this.name != null) {
            this.name.setParentNode(null);
        }
        this.name = name;
        this.setAsParentNodeOf(name);
        return (T)this;
    }

    @Override
    public final SimpleName getName() {
        return this.name;
    }

    @Override
    public List<NodeList<?>> getNodeLists() {
        LinkedList res = new LinkedList(super.getNodeLists());
        res.add(this.members);
        return res;
    }

    @Override
    public boolean remove(Node node) {
        if (node == null) {
            return false;
        }
        for (int i = 0; i < this.members.size(); ++i) {
            if (this.members.get(i) != node) continue;
            this.members.remove(i);
            return true;
        }
        return super.remove(node);
    }

    @Override
    public TypeDeclaration<?> clone() {
        return (TypeDeclaration)this.accept(new CloneVisitor(), null);
    }

    @Override
    public TypeDeclarationMetaModel getMetaModel() {
        return JavaParserMetaModel.typeDeclarationMetaModel;
    }
}

